/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.machine;

import muramasa.antimatter.client.AntimatterModelManager;
import muramasa.antimatter.datagen.builder.AntimatterBlockModelBuilder;
import muramasa.antimatter.datagen.providers.AntimatterBlockStateProvider;
import muramasa.antimatter.machine.BlockMachine;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.types.Machine;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockMultiMachine
extends BlockMachine {
    public static final EnumProperty<MachineState> MACHINE_STATE = EnumProperty.m_61598_((String)"machine_state", MachineState.class, (Enum[])new MachineState[]{MachineState.INVALID_STRUCTURE, MachineState.IDLE, MachineState.ACTIVE});

    public BlockMultiMachine(Machine<?> type, Tier tier) {
        super(type, tier);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.type == null) {
            return;
        }
        if (this.type.allowVerticalFacing()) {
            builder.m_61104_(new Property[]{BlockStateProperties.f_61372_}).m_61104_(new Property[]{MACHINE_STATE});
        } else {
            builder.m_61104_(new Property[]{BlockStateProperties.f_61374_}).m_61104_(new Property[]{MACHINE_STATE});
        }
    }

    @Override
    public void onBlockModelBuild(Block block, AntimatterBlockStateProvider prov) {
        AntimatterBlockModelBuilder builder = prov.getBuilder(block);
        this.buildModelsForState(builder, MachineState.IDLE);
        this.buildModelsForState(builder, MachineState.ACTIVE);
        this.buildModelsForState(builder, MachineState.INVALID_STRUCTURE);
        builder.loader(AntimatterModelManager.LOADER_MACHINE);
        builder.property("particle", this.getType().getBaseTexture(this.tier)[0].toString());
        prov.state(block, builder);
    }
}

