/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.machine;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.Data;
import muramasa.antimatter.Ref;
import muramasa.antimatter.block.BlockBasic;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.capability.machine.MachineFluidHandler;
import muramasa.antimatter.client.AntimatterModelManager;
import muramasa.antimatter.client.SoundHelper;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.cover.ICover;
import muramasa.antimatter.cover.IHaveCover;
import muramasa.antimatter.data.AntimatterDefaultTools;
import muramasa.antimatter.datagen.builder.AntimatterBlockModelBuilder;
import muramasa.antimatter.datagen.builder.AntimatterItemModelBuilder;
import muramasa.antimatter.datagen.json.JLoaderModel;
import muramasa.antimatter.datagen.providers.AntimatterBlockStateProvider;
import muramasa.antimatter.datagen.providers.AntimatterItemModelProvider;
import muramasa.antimatter.item.ItemFluidCell;
import muramasa.antimatter.machine.MachineFlag;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.registration.IItemBlockProvider;
import muramasa.antimatter.texture.Texture;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.tile.TileEntityTickable;
import muramasa.antimatter.tool.AntimatterToolType;
import muramasa.antimatter.util.AntimatterCapUtils;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.antimatter.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tesseract.TesseractCapUtils;

public class BlockMachine
extends BlockBasic
implements IItemBlockProvider,
EntityBlock {
    public static final EnumProperty<MachineState> MACHINE_STATE = EnumProperty.m_61598_((String)"machine_state", MachineState.class, (Enum[])new MachineState[]{MachineState.IDLE, MachineState.ACTIVE});
    protected Machine<?> type;
    protected Tier tier;
    protected final StateDefinition<Block, BlockState> stateContainer;

    public BlockMachine(Machine<?> type, Tier tier) {
        this(type, tier, BlockBehaviour.Properties.m_60939_((Material)Data.WRENCH_MATERIAL).m_60913_(1.0f, 10.0f).m_60918_(SoundType.f_56743_).m_60999_());
    }

    public BlockMachine(Machine<?> type, Tier tier, BlockBehaviour.Properties properties) {
        super(type.getDomain(), type.getId() + (String)(tier == Tier.NONE ? "" : "_" + tier.getId()), properties);
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.type = type;
        this.tier = tier;
        this.m_7926_((StateDefinition.Builder<Block, BlockState>)builder);
        this.stateContainer = builder.m_61101_(Block::m_49966_, BlockState::new);
        this.m_49959_((BlockState)this.stateContainer.m_61090_());
    }

    public Machine<?> getType() {
        return this.type;
    }

    public Tier getTier() {
        return this.tier;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.type == null) {
            return;
        }
        if (this.type.allowVerticalFacing()) {
            builder.m_61104_(new Property[]{BlockStateProperties.f_61372_}).m_61104_(new Property[]{MACHINE_STATE});
        } else {
            builder.m_61104_(new Property[]{BlockStateProperties.f_61374_}).m_61104_(new Property[]{MACHINE_STATE});
        }
    }

    public StateDefinition<Block, BlockState> m_49965_() {
        return this.stateContainer;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (this.type.allowVerticalFacing()) {
            Direction dir = context.m_7820_().m_122424_();
            dir = dir.m_122434_() == Direction.Axis.Y ? dir.m_122424_() : dir;
            return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)this.type.handlePlacementFacing(context, (Property<?>)BlockStateProperties.f_61372_, dir));
        }
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)this.type.handlePlacementFacing(context, (Property<?>)BlockStateProperties.f_61374_, context.m_8125_().m_122424_()));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        TileEntityMachine tile;
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (!worldIn.f_46443_ && (tile = (TileEntityMachine)worldIn.m_7702_(pos)) != null) {
            tile.onBlockUpdate(fromPos);
        }
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        TileEntityMachine tile = (TileEntityMachine)world.m_7702_(pos);
        if (tile != null) {
            ItemStack stack = player.m_21120_(hand);
            AntimatterToolType type = Utils.getToolType(player);
            InteractionResult ty = tile.onInteractBoth(state, world, pos, player, hand, hit, type);
            if (ty.m_19077_()) {
                return ty;
            }
            if (!world.f_46443_ && hand == InteractionHand.MAIN_HAND) {
                boolean coverInteract;
                if (player.m_21120_(hand).m_41720_() instanceof IHaveCover) {
                    CoverFactory factory = ((IHaveCover)stack.m_41720_()).getCover();
                    Direction dir = Utils.getInteractSide(hit);
                    boolean ok = AntimatterCapUtils.getCoverHandler(tile, Utils.getInteractSide(hit)).map(i -> i.placeCover(player, Utils.getInteractSide(hit), stack, factory.get().get((ICoverHandler<?>)i, ((IHaveCover)stack.m_41720_()).getTier(), dir, factory))).orElse(false);
                    if (ok) {
                        return InteractionResult.SUCCESS;
                    }
                }
                if (type == AntimatterDefaultTools.WRENCH || type == AntimatterDefaultTools.ELECTRIC_WRENCH) {
                    if (tile.wrenchMachine(player, hit, player.m_6047_())) {
                        Utils.damageStack(stack, hand, (LivingEntity)player);
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    if (type == AntimatterDefaultTools.SOFT_HAMMER) {
                        tile.toggleMachine();
                        if (tile.getMachineState() == MachineState.DISABLED) {
                            player.m_6352_((Component)new TextComponent("Disabled machine."), player.m_142081_());
                        } else {
                            player.m_6352_((Component)new TextComponent("Enabled machine."), player.m_142081_());
                        }
                        Utils.damageStack(stack, (LivingEntity)player);
                        return InteractionResult.SUCCESS;
                    }
                    if (type == AntimatterDefaultTools.CROWBAR) {
                        if (!player.m_6047_()) {
                            if (AntimatterCapUtils.getCoverHandler(tile, Utils.getInteractSide(hit)).map(h -> h.removeCover(player, Utils.getInteractSide(hit), false)).orElse(false).booleanValue()) {
                                Utils.damageStack(stack, hand, (LivingEntity)player);
                                return InteractionResult.SUCCESS;
                            }
                        } else if (AntimatterCapUtils.getCoverHandler(tile, Utils.getInteractSide(hit)).map(h -> h.moveCover(player, hit.m_82434_(), Utils.getInteractSide(hit))).orElse(false).booleanValue()) {
                            Utils.damageStack(stack, hand, (LivingEntity)player);
                            return InteractionResult.SUCCESS;
                        }
                    } else if (type == AntimatterDefaultTools.SCREWDRIVER || type == AntimatterDefaultTools.ELECTRIC_SCREWDRIVER) {
                        ICover instance = AntimatterCapUtils.getCoverHandler(tile, Utils.getInteractSide(hit)).map(h -> h.get(Utils.getInteractSide(hit))).orElse(ICover.empty);
                        if (!player.m_6047_() && !instance.isEmpty() && instance.openGui(player, Utils.getInteractSide(hit))) {
                            Utils.damageStack(stack, hand, (LivingEntity)player);
                            return InteractionResult.SUCCESS;
                        }
                    }
                }
                if (coverInteract = AntimatterCapUtils.getCoverHandler(tile, hit.m_82434_()).map(h -> h.onInteract(player, hand, hit.m_82434_(), Utils.getToolType(player))).orElse(false).booleanValue()) {
                    return InteractionResult.SUCCESS;
                }
                if (TesseractCapUtils.getFluidHandler((BlockEntity)tile, (Direction)hit.m_82434_()).map(fh -> {
                    int n;
                    Item item = stack.m_41720_();
                    if (item instanceof ItemFluidCell) {
                        ItemFluidCell cell = (ItemFluidCell)item;
                        n = cell.getCapacity();
                    } else {
                        n = 1000;
                    }
                    int capacity = n;
                    fh = tile.fluidHandler.map(MachineFluidHandler::getGuiHandler).orElse((IFluidHandler)fh);
                    FluidActionResult res = FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)fh, (int)capacity, (Player)player, (boolean)true);
                    if (res.isSuccess() && !player.m_7500_()) {
                        boolean single = stack.m_41613_() == 1;
                        stack.m_41774_(1);
                        if (single) {
                            player.m_21008_(hand, res.result);
                        } else if (!player.m_36356_(res.result)) {
                            player.m_36176_(res.result, true);
                        }
                    }
                    if (!res.isSuccess() && (res = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)fh, (int)capacity, (Player)player, (boolean)true)).isSuccess() && !player.m_7500_()) {
                        boolean single = stack.m_41613_() == 1;
                        stack.m_41774_(1);
                        if (single) {
                            player.m_21008_(hand, res.result);
                        } else if (!player.m_36356_(res.result)) {
                            player.m_36176_(res.result, true);
                        }
                    }
                    return res.isSuccess();
                }).orElse(false).booleanValue()) {
                    return InteractionResult.SUCCESS;
                }
                if (this.getType().has(MachineFlag.GUI) && tile.canPlayerOpenGui(player)) {
                    AntimatterPlatformUtils.openGui((ServerPlayer)player, tile, extra -> extra.m_130064_(pos));
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
        }
        return InteractionResult.CONSUME;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        List list = super.m_7381_(state, builder);
        BlockEntity tileentity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (tileentity instanceof TileEntityMachine) {
            TileEntityMachine machine = (TileEntityMachine)tileentity;
            machine.onDrop(state, builder, list);
            machine.itemHandler.ifPresent(t -> list.addAll(t.getAllItems()));
            machine.coverHandler.ifPresent(t -> list.addAll(t.getDrops()));
        }
        return list;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof TileEntityMachine) {
            TileEntityMachine machine = (TileEntityMachine)tileEntity;
            machine.onPlacedBy(world, pos, state, placer, stack);
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_()) && worldIn.f_46443_) {
            SoundHelper.clear(worldIn, pos);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    @Override
    public Component getDisplayName(ItemStack stack) {
        return this.getType().getDisplayName(this.getTier());
    }

    @Override
    public CreativeModeTab getItemGroup() {
        return this.getType().getGroup();
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        if (this.getType().has(MachineFlag.BASIC) && !this.getType().has(MachineFlag.RF) && this.getTier().getVoltage() > 0) {
            tooltip.add((Component)new TranslatableComponent("machine.voltage.in").m_130946_(": ").m_7220_((Component)new TextComponent(this.getTier().getVoltage() + " (" + this.getTier().getId().toUpperCase() + ")")).m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)new TranslatableComponent("machine.power.capacity").m_130946_(": ").m_7220_((Component)new TextComponent("" + this.getTier().getVoltage() * 64)).m_130940_(ChatFormatting.BLUE));
        }
        this.type.getTooltipFunction().getTooltips(stack, world, tooltip, flag);
    }

    @Override
    public void onItemModelBuild(ItemLike item, AntimatterItemModelProvider prov) {
        AntimatterItemModelBuilder b = (AntimatterItemModelBuilder)((AntimatterItemModelBuilder)prov.getBuilder(item).parent(prov.existing("antimatter", "block/preset/layered"))).texture("base", this.type.getBaseTexture(this.tier)[0]);
        Texture[] base = this.type.getBaseTexture(this.tier);
        if (base.length >= 6) {
            for (int s = 0; s < 6; ++s) {
                b.texture("base" + Utils.coverRotateFacing(Ref.DIRS[s], Direction.NORTH).m_7912_(), base[s]);
            }
        }
        Texture[] overlays = this.type.getOverlayTextures(MachineState.ACTIVE, this.tier);
        for (int s = 0; s < 6; ++s) {
            b.texture("overlay" + Utils.coverRotateFacing(Ref.DIRS[s], Direction.NORTH).m_7912_(), overlays[s]);
        }
    }

    @Override
    public void onBlockModelBuild(Block block, AntimatterBlockStateProvider prov) {
        AntimatterBlockModelBuilder builder = prov.getBuilder(block);
        this.buildModelsForState(builder, MachineState.IDLE);
        this.buildModelsForState(builder, MachineState.ACTIVE);
        builder.loader(AntimatterModelManager.LOADER_MACHINE);
        builder.property("particle", this.getType().getBaseTexture(this.tier)[0].toString());
        prov.state(block, builder);
    }

    void buildModelsForState(AntimatterBlockModelBuilder builder, MachineState state) {
        Texture[] overlays = this.type.getOverlayTextures(state, this.tier);
        ArrayList<JLoaderModel> arr = new ArrayList<JLoaderModel>();
        for (Direction dir : Ref.DIRS) {
            JLoaderModel obj = builder.addModelObject(JLoaderModel.modelKeepElements(), this.getType().getOverlayModel(state, dir).toString(), (ImmutableMap<String, String>)ImmutableMap.of((Object)"base", (Object)this.getType().getBaseTexture(this.tier, dir).toString(), (Object)"overlay", (Object)overlays[dir.m_122411_()].toString()));
            arr.add(obj);
        }
        builder.property(state.toString().toLowerCase(), arr);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity entity = blockAccess.m_7702_(pos);
        if (entity instanceof TileEntityMachine) {
            TileEntityMachine machine = (TileEntityMachine)entity;
            return machine.getWeakRedstonePower(side);
        }
        return super.m_6378_(blockState, blockAccess, pos, side);
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity entity = blockAccess.m_7702_(pos);
        if (entity instanceof TileEntityMachine) {
            TileEntityMachine machine = (TileEntityMachine)entity;
            return machine.getStrongRedstonePower(side);
        }
        return super.m_6376_(blockState, blockAccess, pos, side);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        TileEntityMachine machine = (TileEntityMachine)this.getType().getTileType().m_155264_(pos, state);
        return machine;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_() && !this.getType().canClientTick()) {
            return null;
        }
        return TileEntityTickable::commonTick;
    }
}

