/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.item;

import java.util.Objects;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.cover.IHaveCover;
import muramasa.antimatter.item.ItemBasic;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.texture.Texture;

public class ItemCover
extends ItemBasic<ItemCover>
implements IHaveCover {
    private final CoverFactory cover;
    private final Tier tier;
    private Texture[] override;

    public ItemCover(String domain, String id) {
        super(domain, id);
        this.cover = Objects.requireNonNull(AntimatterAPI.get(CoverFactory.class, id, this.getDomain()));
        this.tier = null;
    }

    public ItemCover(String domain, String id, Tier tier) {
        super(domain, id + "_" + tier.getId());
        this.cover = Objects.requireNonNull(AntimatterAPI.get(CoverFactory.class, id, this.getDomain()));
        this.tier = tier;
    }

    public ItemCover texture(Texture ... texture) {
        this.override = texture;
        return this;
    }

    @Override
    public Tier getTier() {
        return this.tier;
    }

    @Override
    public CoverFactory getCover() {
        return this.cover;
    }

    @Override
    public Texture[] getTextures() {
        if (this.override == null) {
            return super.getTextures();
        }
        return this.override;
    }
}

