/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.capability.energy.ItemEnergyHandler;
import muramasa.antimatter.item.ItemBasic;
import muramasa.antimatter.machine.Tier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import tesseract.TesseractCapUtils;
import tesseract.api.context.TesseractItemContext;
import tesseract.api.gt.IEnergyHandlerItem;
import tesseract.api.gt.IEnergyItem;
import tesseract.api.gt.IGTNode;

public class ItemBattery
extends ItemBasic<ItemBattery>
implements IEnergyItem {
    protected Tier tier;
    protected final long cap;
    protected final boolean reusable;

    public ItemBattery(String domain, String id, Tier tier, long cap, boolean reusable) {
        super(domain, id);
        this.tier = tier;
        this.cap = cap;
        this.reusable = reusable;
    }

    public Tier getTier() {
        return this.tier;
    }

    public long getCapacity() {
        return this.cap;
    }

    public boolean isReusable() {
        return this.reusable;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            items.add((Object)stack.m_41777_());
            items.add((Object)ItemBattery.getFilledBattery(this));
        }
    }

    public static ItemStack getFilledBattery(ItemBasic<?> item) {
        ItemStack stack = item.m_7968_();
        if (!(item instanceof ItemBattery)) {
            return stack;
        }
        ItemBattery battery = (ItemBattery)item;
        stack.m_41698_("ied").m_128356_("e", battery.cap);
        return stack;
    }

    public int m_142159_(ItemStack stack) {
        long energy = stack.m_41698_("ied").m_128454_("e");
        if (energy <= 0L) {
            return super.m_142159_(stack);
        }
        return 49151;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return (int)(13.0 * ((double)stack.m_41698_("ied").m_128454_("e") / (double)this.cap));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.m_5776_() && player.m_6047_()) {
            boolean newMode = this.chargeModeSwitch(stack);
            player.m_6352_((Component)new TranslatableComponent(newMode ? "message.discharge.on" : "message.discharge.off"), player.m_142081_());
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private static Optional<ItemEnergyHandler> getCastedHandler(ItemStack stack) {
        Optional itemHandler = TesseractCapUtils.getEnergyHandlerItem((ItemStack)stack);
        return itemHandler.map(e -> (ItemEnergyHandler)e);
    }

    private boolean chargeModeSwitch(ItemStack stack) {
        return ItemBattery.getCastedHandler(stack).map(itemEnergyHandler -> {
            boolean switchMode = itemEnergyHandler.chargeModeSwitch();
            stack.m_41751_(itemEnergyHandler.getContainer().getTag());
            return switchMode;
        }).orElse(true);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        if (this.reusable) {
            tooltip.add((Component)new TranslatableComponent("item.reusable"));
        }
        long energy = TesseractCapUtils.getEnergyHandlerItem((ItemStack)stack).map(IGTNode::getEnergy).orElse(0L);
        tooltip.add((Component)new TranslatableComponent("item.charge").m_130946_(": ").m_7220_((Component)new TextComponent(energy + "/" + this.cap).m_130940_(energy == 0L ? ChatFormatting.RED : ChatFormatting.GREEN)).m_130946_(" (" + this.tier.getId().toUpperCase() + ")"));
        super.m_7373_(stack, worldIn, tooltip, flag);
    }

    public IEnergyHandlerItem createEnergyHandler(TesseractItemContext context) {
        return new ItemEnergyHandler(context, this.cap, this.isReusable() ? this.tier.getVoltage() : 0, this.tier.getVoltage(), this.reusable ? 2 : 0, 1);
    }
}

