/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.item;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Set;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.Ref;
import muramasa.antimatter.item.ItemTag;
import muramasa.antimatter.registration.IAntimatterObject;
import muramasa.antimatter.registration.IModelProvider;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.registration.ITextureProvider;
import muramasa.antimatter.texture.Texture;
import muramasa.antimatter.util.Utils;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemBasic<T extends ItemBasic<T>>
extends Item
implements IAntimatterObject,
ITextureProvider,
IModelProvider {
    protected String domain;
    protected String id;
    protected String tooltip = "";
    protected boolean enabled = true;
    protected Set<ItemTag> tags = new ObjectOpenHashSet();

    public ItemBasic(String domain, String id, Item.Properties properties) {
        super(properties);
        this.domain = domain;
        this.id = id;
        AntimatterAPI.register(this.getClass(), this);
    }

    public ItemBasic(String domain, String id, Class clazz, Item.Properties properties) {
        super(properties);
        this.domain = domain;
        this.id = id;
        AntimatterAPI.register(clazz, this);
    }

    public ItemBasic(String domain, String id) {
        this(domain, id, new Item.Properties().m_41491_(Ref.TAB_ITEMS));
    }

    public T tip(String tooltip) {
        this.tooltip = tooltip;
        return (T)this;
    }

    public T tags(ItemTag ... tags) {
        this.tags.addAll(Arrays.asList(tags));
        return (T)this;
    }

    @Override
    public String getDomain() {
        return this instanceof ISharedAntimatterObject ? "antimatter_shared" : this.domain;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public boolean isEnabled() {
        return this.enabled || AntimatterConfig.DATA.ALL_MATERIAL_ITEMS;
    }

    public boolean isEqual(ItemStack stack) {
        return stack.m_41720_() == this;
    }

    public ItemStack get(int count) {
        if (count == 0) {
            return Utils.addNoConsumeTag(new ItemStack((ItemLike)this, 1));
        }
        return new ItemStack((ItemLike)this, count);
    }

    @Override
    public Texture[] getTextures() {
        return new Texture[]{new Texture(this.domain, "item/basic/" + this.getId())};
    }
}

