/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.integration.rei.category;

import com.google.common.collect.ImmutableList;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import muramasa.antimatter.integration.rei.REIUtils;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.antimatter.recipe.map.RecipeMap;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class RecipeMapDisplay
implements Display {
    private final CategoryIdentifier<RecipeMapDisplay> id;
    private final List<EntryIngredient> input;
    private final List<EntryIngredient> output;
    private final IRecipe recipe;

    public RecipeMapDisplay(IRecipe recipe) {
        this.id = CategoryIdentifier.of((String)"antimatter_shared", (String)recipe.getMapId());
        this.recipe = recipe;
        List<EntryIngredient> fluidInputs = RecipeMapDisplay.createFluidInputEntries(recipe.getInputFluids().stream().map(fluidIngredient -> Arrays.stream(fluidIngredient.getStacks()).map(REIUtils::toREIFLuidStack).toList()).toList());
        List<EntryIngredient> itemInputs = RecipeMapDisplay.createInputEntries(recipe.getInputItems(), recipe);
        this.input = new ArrayList<EntryIngredient>(itemInputs);
        this.input.addAll(fluidInputs);
        ImmutableList.Builder builder = ImmutableList.builder();
        ItemStack[] stacks = recipe.getOutputItems(false);
        if (stacks != null) {
            builder.addAll(RecipeMapDisplay.createOutputEntries(Arrays.asList(stacks), recipe));
        }
        if (recipe.getOutputFluids() != null) {
            builder.addAll(RecipeMapDisplay.createFluidOutputEntries(Arrays.stream(recipe.getOutputFluids()).map(REIUtils::toREIFLuidStack).toList()));
        }
        this.output = builder.build();
    }

    public static List<EntryIngredient> createOutputEntries(List<ItemStack> input, IRecipe recipe) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        return input.stream().map(i -> {
            int chance = recipe.hasChances() ? Objects.requireNonNull(recipe.getChances())[atomicInteger.getAndIncrement()] : 10000;
            return EntryStacks.of((ItemStack)i).setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, RecipeMapDisplay.getProbabilitySetting(chance));
        }).map(EntryIngredient::of).toList();
    }

    public static List<EntryIngredient> createFluidOutputEntries(List<FluidStack> input) {
        return input.stream().map(i -> {
            EntryStack fluidStackEntryStack = EntryStacks.of((FluidStack)i);
            if (AntimatterPlatformUtils.isFabric()) {
                fluidStackEntryStack.setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, RecipeMapDisplay.getFluidSetting(i));
            }
            return fluidStackEntryStack;
        }).map(EntryIngredient::of).toList();
    }

    public static List<EntryIngredient> createFluidInputEntries(List<List<FluidStack>> input) {
        return input.stream().map(i -> {
            List<EntryStack> fluidStackEntryStack = i.stream().map(EntryStacks::of).toList();
            if (AntimatterPlatformUtils.isFabric()) {
                fluidStackEntryStack.stream().forEach(e -> e.setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, RecipeMapDisplay.getFluidSetting((FluidStack)e.getValue())));
            }
            return fluidStackEntryStack;
        }).map(EntryIngredient::of).toList();
    }

    public static List<EntryIngredient> createInputEntries(List<Ingredient> input, IRecipe recipe) {
        return input.stream().map(i -> {
            List<EntryStack> entry = Arrays.stream(i.m_43908_()).map(EntryStacks::of).toList();
            if (i instanceof RecipeIngredient) {
                RecipeIngredient ri = (RecipeIngredient)((Object)i);
                entry.forEach(e -> e.setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, f -> {
                    ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
                    if (ri.ignoreConsume()) {
                        components.add(new TextComponent("Does not get consumed in the process.").m_130940_(ChatFormatting.WHITE));
                    }
                    if (ri.ignoreNbt()) {
                        components.add(new TextComponent("Ignores NBT.").m_130940_(ChatFormatting.WHITE));
                    }
                    if (RecipeMap.isIngredientSpecial(i)) {
                        components.add(new TextComponent("Special ingredient. Class name: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(i.getClass().getSimpleName()).m_130940_(ChatFormatting.GOLD)));
                    }
                    return components;
                }));
            }
            return entry;
        }).map(EntryIngredient::of).toList();
    }

    public static Component getProbabilityTooltip(int probability) {
        if (probability == 10000) {
            return null;
        }
        TextComponent text = new TextComponent("Chance: " + (float)probability / 100.0f + "%");
        text.m_130940_(ChatFormatting.WHITE);
        return text;
    }

    public static Function<EntryStack<?>, List<Component>> getProbabilitySetting(int probability) {
        Component tooltip = RecipeMapDisplay.getProbabilityTooltip(probability);
        return es -> tooltip == null ? List.of() : List.of(tooltip);
    }

    private static Function<EntryStack<?>, List<Component>> getFluidSetting(FluidStack fluidStack) {
        TextComponent tooltip = new TextComponent(fluidStack.getAmount() / 81L + " " + RecipeMapDisplay.intToSuperScript(fluidStack.getAmount() % 81L) + "/\u2088\u2081 mb");
        return arg_0 -> RecipeMapDisplay.lambda$getFluidSetting$9((Component)tooltip, arg_0);
    }

    private static String intToSuperScript(long i) {
        String intString = String.valueOf(i);
        StringBuilder builder = new StringBuilder();
        for (char c : intString.toCharArray()) {
            builder.append(RecipeMapDisplay.charToSuperScript(c));
        }
        return builder.toString();
    }

    private static String charToSuperScript(char c) {
        return switch (c) {
            case '0' -> "\u2070";
            case '1' -> "\u00b9";
            case '2' -> "\u00b2";
            case '3' -> "\u00b3";
            case '4' -> "\u2074";
            case '5' -> "\u2075";
            case '6' -> "\u2076";
            case '7' -> "\u2077";
            case '8' -> "\u2078";
            case '9' -> "\u2079";
            default -> String.valueOf(c);
        };
    }

    public List<EntryIngredient> getInputEntries() {
        return this.input;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return this.id;
    }

    public IRecipe getRecipe() {
        return this.recipe;
    }

    private static /* synthetic */ List lambda$getFluidSetting$9(Component tooltip, EntryStack es) {
        return List.of(tooltip);
    }
}

