/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.integration.rei;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import me.shedaniel.rei.api.client.entry.filtering.base.BasicFilteringRule;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.category.extension.CategoryExtensionProvider;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.settings.EntrySettingsAdapterRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterStoneTypes;
import muramasa.antimatter.integration.jeirei.AntimatterJEIREIPlugin;
import muramasa.antimatter.integration.rei.REIUtils;
import muramasa.antimatter.integration.rei.category.RecipeMapCategory;
import muramasa.antimatter.integration.rei.category.RecipeMapDisplay;
import muramasa.antimatter.integration.rei.extension.REIMaterialRecipeExtension;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.material.MaterialTypeBlock;
import muramasa.antimatter.material.MaterialTypeItem;
import muramasa.antimatter.ore.BlockOre;
import muramasa.antimatter.ore.CobbleStoneType;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.recipe.map.IRecipeMap;
import muramasa.antimatter.recipe.map.RecipeBuilder;
import muramasa.antimatter.recipe.map.RecipeMap;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class AntimatterREIClientPlugin
implements REIClientPlugin {
    public String getPluginProviderName() {
        return "antimatter:rei";
    }

    public void registerCollapsibleEntries(CollapsibleEntryRegistry registry) {
        if (!AntimatterConfig.CLIENT.ADD_REI_GROUPS) {
            return;
        }
        AntimatterAPI.all(MaterialType.class).stream().filter(t -> t instanceof MaterialTypeItem || t instanceof MaterialTypeBlock).forEach(t -> {
            MaterialTypeBlock typeBlock;
            Object func2;
            Object patt2838$temp = t.get();
            if (patt2838$temp instanceof MaterialTypeBlock.IOreGetter) {
                MaterialTypeBlock.IOreGetter getter = (MaterialTypeBlock.IOreGetter)patt2838$temp;
                AntimatterAPI.all(StoneType.class, s -> {
                    if (s != AntimatterStoneTypes.STONE && !AntimatterConfig.CLIENT.SHOW_ALL_ORES && t != AntimatterMaterialTypes.ROCK) {
                        return;
                    }
                    if (t == AntimatterMaterialTypes.ROCK && !AntimatterConfig.CLIENT.SHOW_ROCKS) {
                        return;
                    }
                    List<Object> entries = t.all().stream().map(m -> EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)getter.get((Material)m, (StoneType)s).asStack())).toList();
                    registry.group(new ResourceLocation("antimatter_shared", t.getId() + "_" + s.getId()), (Component)new TranslatableComponent("antimatter.rei.group." + t.getId() + "." + s.getId()), entries);
                });
                if (t != AntimatterMaterialTypes.ROCK) {
                    return;
                }
            }
            if (AntimatterConfig.CLIENT.GROUP_ORES_ONLY) {
                return;
            }
            Function<Material, ItemStack> func = null;
            if (t instanceof MaterialTypeItem) {
                MaterialTypeItem typeItem = (MaterialTypeItem)t;
                func = m -> typeItem.get((Material)m, 1);
            }
            if (t instanceof MaterialTypeBlock && (func2 = (typeBlock = (MaterialTypeBlock)t).get()) instanceof MaterialTypeBlock.IBlockGetter) {
                MaterialTypeBlock.IBlockGetter getter = (MaterialTypeBlock.IBlockGetter)func2;
                func = m -> getter.get((Material)m).asStack();
            }
            if (func == null) {
                return;
            }
            Function<Material, ItemStack> finalFunc = func;
            List<Object> entries = t.all().stream().map(m -> EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)((ItemStack)finalFunc.apply((Material)m)))).toList();
            registry.group(new ResourceLocation("antimatter_shared", t.getId()), (Component)new TranslatableComponent("antimatter.rei.group." + t.getId()), entries);
        });
        if (AntimatterConfig.CLIENT.GROUP_ORES_ONLY) {
            return;
        }
        AntimatterAPI.all(StoneType.class, s -> {
            if (s instanceof CobbleStoneType) {
                CobbleStoneType cobble = (CobbleStoneType)s;
                List<EntryStack> entries = cobble.getBlocks().values().stream().map(b -> EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)b.m_5456_()))).toList();
                registry.group(new ResourceLocation("antimatter_shared", s.getId()), (Component)new TranslatableComponent("antimatter.rei.group." + s.getId()), entries);
            }
        });
    }

    public void registerBasicEntryFiltering(BasicFilteringRule<?> rule) {
        if (!AntimatterConfig.CLIENT.SHOW_ALL_ORES) {
            AntimatterMaterialTypes.ORE.all().forEach(m -> AntimatterAPI.all(StoneType.class, s -> {
                if (s != AntimatterStoneTypes.STONE && s != AntimatterStoneTypes.SAND && s.generateOre) {
                    Block ore = ((MaterialTypeBlock.IOreGetter)AntimatterMaterialTypes.ORE.get()).get((Material)m, (StoneType)s).asBlock();
                    if (ore instanceof BlockOre) {
                        rule.hide(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)ore)));
                    }
                    if (m.has(AntimatterMaterialTypes.ORE_SMALL) && (ore = ((MaterialTypeBlock.IOreGetter)AntimatterMaterialTypes.ORE_SMALL.get()).get((Material)m, (StoneType)s).asBlock()) instanceof BlockOre) {
                        rule.hide(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)ore)));
                    }
                }
            }));
        }
        if (!AntimatterConfig.CLIENT.SHOW_ROCKS) {
            AntimatterMaterialTypes.ROCK.all().forEach(m -> AntimatterAPI.all(StoneType.class, s -> {
                if (s.generateOre) {
                    rule.hide(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)((MaterialTypeBlock.IOreGetter)AntimatterMaterialTypes.ROCK.get()).get((Material)m, (StoneType)s).asStack()));
                }
            }));
        }
        AntimatterJEIREIPlugin.getItemsToHide().forEach(i -> rule.hide(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)i.m_5456_().m_7968_())));
    }

    public void registerCategories(CategoryRegistry registry) {
        ObjectOpenHashSet registeredMachineCats = new ObjectOpenHashSet();
        AntimatterJEIREIPlugin.getREGISTRY().forEach((arg_0, arg_1) -> AntimatterREIClientPlugin.lambda$registerCategories$14((Set)registeredMachineCats, registry, arg_0, arg_1));
        AntimatterAPI.all(Machine.class, machine -> {
            IRecipeMap map = machine.getRecipeMap();
            if (map == null) {
                return;
            }
            machine.getTiers().forEach(t -> {
                ItemStack stack = new ItemStack((ItemLike)machine.getItem((Tier)t));
                if (!stack.m_41619_()) {
                    registry.addWorkstations(CategoryIdentifier.of((ResourceLocation)map.getLoc()), new EntryStack[]{EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)stack)});
                }
            });
        });
        REIUtils.EXTRA_CATEGORIES.forEach(c -> c.accept(registry));
    }

    public void registerDisplays(DisplayRegistry registry) {
        registry.registerRecipeFiller(IRecipe.class, type -> Objects.equals(muramasa.antimatter.recipe.Recipe.RECIPE_TYPE, type), r -> !r.isHidden(), RecipeMapDisplay::new);
        AntimatterAPI.all(RecipeMap.class, m -> {
            if (m.getProxy() != null) {
                registry.registerRecipeFiller(Recipe.class, m.getProxy().loc(), r -> new RecipeMapDisplay(m.getProxy().handler().apply((Recipe<?>)r, (RecipeBuilder)m.RB())));
            }
        });
        REIUtils.EXTRA_DISPLAYS.forEach(c -> c.accept(registry));
    }

    public void postStage(PluginManager<REIClientPlugin> manager, ReloadStage stage) {
        if (stage != ReloadStage.END || !manager.equals((Object)PluginManager.getClientInstance())) {
            return;
        }
        CategoryRegistry.getInstance().get(BuiltinPlugin.CRAFTING).registerExtension((CategoryExtensionProvider)new REIMaterialRecipeExtension());
    }

    public void registerEntrySettingsAdapters(EntrySettingsAdapterRegistry registry) {
        super.registerEntrySettingsAdapters(registry);
    }

    private static /* synthetic */ void lambda$registerCategories$14(Set registeredMachineCats, CategoryRegistry registry, ResourceLocation id, AntimatterJEIREIPlugin.RegistryValue tuple) {
        if (!registeredMachineCats.contains(tuple.map.getLoc())) {
            RecipeMapCategory category = new RecipeMapCategory(tuple.map, tuple.gui, tuple.tier, tuple.model);
            registry.add((DisplayCategory)category);
            registeredMachineCats.add(tuple.map.getLoc());
        }
    }
}

