/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.integration.kubejs;

import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import muramasa.antimatter.AntimatterMod;
import muramasa.antimatter.datagen.AntimatterDynamics;
import muramasa.antimatter.datagen.providers.AntimatterBlockLootProvider;
import muramasa.antimatter.datagen.providers.AntimatterBlockStateProvider;
import muramasa.antimatter.datagen.providers.AntimatterBlockTagProvider;
import muramasa.antimatter.datagen.providers.AntimatterItemModelProvider;
import muramasa.antimatter.datagen.providers.AntimatterItemTagProvider;
import muramasa.antimatter.datagen.providers.AntimatterLanguageProvider;
import muramasa.antimatter.event.ProvidersEvent;
import muramasa.antimatter.integration.kubejs.AntimatterKubeJS;
import muramasa.antimatter.registration.RegistrationEvent;
import muramasa.antimatter.registration.Side;
import muramasa.antimatter.util.AntimatterPlatformUtils;

public class KubeJSRegistrar
extends AntimatterMod {
    public KubeJSRegistrar() {
        if (AntimatterPlatformUtils.isFabric()) {
            this.onRegistrarInit();
        }
    }

    @Override
    public void onRegistrarInit() {
        super.onRegistrarInit();
        AntimatterDynamics.clientProvider("kubejs", () -> new AntimatterBlockStateProvider("kubejs", "KubeJS BlockStates"));
        AntimatterDynamics.clientProvider("kubejs", () -> new AntimatterItemModelProvider("kubejs", "KubeJS Item Models"));
        AntimatterDynamics.clientProvider("kubejs", () -> new AntimatterLanguageProvider("kubejs", "KubeJS en_us Localization", "en_us"));
    }

    public static void providerEvent(ProvidersEvent ev) {
        AntimatterBlockTagProvider[] p = new AntimatterBlockTagProvider[1];
        ev.addProvider("kubejs", () -> {
            p[0] = new AntimatterBlockTagProvider("kubejs", "KubeJS Block Tags", false);
            return p[0];
        });
        ev.addProvider("kubejs", () -> new AntimatterItemTagProvider("kubejs", "KubeJS Item Tags", false, p[0]));
        ev.addProvider("kubejs", () -> new AntimatterBlockLootProvider("kubejs", "KubeJS Loot generator"));
    }

    @Override
    public String getId() {
        return "kubejs";
    }

    @Override
    public void onRegistrationEvent(RegistrationEvent event, Side side) {
        if (event == RegistrationEvent.DATA_INIT) {
            AntimatterKubeJS.loadStartup();
        }
    }

    @Override
    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    public static void checkKubeJSServerScriptManager() {
        if (ServerScriptManager.instance == null) {
            ServerScriptManager.instance = new ServerScriptManager();
            try {
                if (Files.notExists(KubeJSPaths.DATA, new LinkOption[0])) {
                    Files.createDirectories(KubeJSPaths.DATA, new FileAttribute[0]);
                }
            }
            catch (Throwable var3) {
                throw new RuntimeException("KubeJS failed to register it's script loader!", var3);
            }
        }
    }
}

