/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.integration.kubejs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import muramasa.antimatter.integration.kubejs.RecipeIngredientJS;
import muramasa.antimatter.integration.rei.REIUtils;
import muramasa.antimatter.recipe.ingredient.FluidIngredient;
import muramasa.antimatter.recipe.serializer.AntimatterRecipeSerializer;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import tesseract.FluidPlatformUtils;

public class KubeJSRecipe
extends RecipeJS {
    public final List<FluidIngredient> fluidInput = new ObjectArrayList();
    public final List<FluidStack> fluidOutput = new ObjectArrayList();
    private int duration;
    private int special;
    private long power;
    private int amps;
    private boolean hidden;
    private final List<Integer> chances = new ObjectArrayList();
    private String map;

    public void create(ListJS listJS) {
        FluidStackJS fluidStack;
        MapJS map;
        this.map = (String)listJS.get(0);
        if (listJS.get(1) != null) {
            for (Object inputItem : ListJS.orSelf((Object)listJS.get(1))) {
                if (inputItem instanceof MapJS) {
                    map = (MapJS)inputItem;
                    this.inputItems.add(RecipeIngredientJS.fromJson((JsonElement)map.toJson()));
                    continue;
                }
                this.inputItems.add(IngredientJS.of(inputItem));
            }
        }
        if (listJS.get(2) != null) {
            for (Object outputItem : ListJS.orSelf((Object)listJS.get(2))) {
                this.outputItems.add(ItemStackJS.of(outputItem));
            }
        }
        if (listJS.get(3) != null) {
            for (Object inputFluid : ListJS.orSelf((Object)listJS.get(3))) {
                if (inputFluid instanceof FluidStackJS) {
                    fluidStack = (FluidStackJS)inputFluid;
                    this.fluidInput.add(FluidIngredient.of(REIUtils.fromREIFluidStack(fluidStack.getFluidStack())));
                    continue;
                }
                if (inputFluid instanceof MapJS) {
                    map = (MapJS)inputFluid;
                    this.fluidInput.add(AntimatterRecipeSerializer.getFluidIngredient((JsonElement)map.toJson()));
                    continue;
                }
                throw new IllegalArgumentException("Invalid entry type in fluid output");
            }
        }
        if (listJS.get(4) != null) {
            for (Object outputFluid : ListJS.orSelf((Object)listJS.get(4))) {
                if (outputFluid instanceof FluidStackJS) {
                    fluidStack = (FluidStackJS)outputFluid;
                    this.fluidOutput.add(REIUtils.fromREIFluidStack(fluidStack.getFluidStack()));
                    continue;
                }
                if (outputFluid instanceof MapJS) {
                    map = (MapJS)outputFluid;
                    this.fluidOutput.add(AntimatterRecipeSerializer.getStack((JsonElement)map.toJson()));
                    continue;
                }
                throw new IllegalArgumentException("Invalid entry type in fluid output");
            }
        }
        this.duration = ((Number)listJS.get(5)).intValue();
        this.power = ((Number)listJS.get(6)).longValue();
        this.hidden = false;
        if (listJS.size() > 7) {
            this.amps = ((Number)listJS.get(7)).intValue();
            this.special = ((Number)listJS.get(8)).intValue();
            if (listJS.size() > 9) {
                for (Object chance : ListJS.orSelf((Object)listJS.get(9))) {
                    this.chances.add(((Number)chance).intValue());
                }
            }
        } else {
            this.amps = 1;
            this.special = 0;
        }
        if (this.inputItems.size() == 0 && this.fluidInput.size() == 0) {
            throw new IllegalStateException("No input in recipe");
        }
    }

    public void deserialize() {
        for (JsonElement e : GsonHelper.m_13832_((JsonObject)this.json, (String)"item_in", (JsonArray)new JsonArray())) {
            this.inputItems.add(RecipeIngredientJS.fromJson(e));
        }
        for (JsonElement e : GsonHelper.m_13832_((JsonObject)this.json, (String)"item_out", (JsonArray)new JsonArray())) {
            this.outputItems.add(ItemStackJS.of((Object)e));
        }
        for (JsonElement e : GsonHelper.m_13832_((JsonObject)this.json, (String)"fluid_in", (JsonArray)new JsonArray())) {
            this.fluidInput.add(AntimatterRecipeSerializer.getFluidIngredient(e));
        }
        for (JsonElement e : GsonHelper.m_13832_((JsonObject)this.json, (String)"fluid_out", (JsonArray)new JsonArray())) {
            this.fluidOutput.add(AntimatterRecipeSerializer.getStack(e));
        }
        this.duration = GsonHelper.m_13927_((JsonObject)this.json, (String)"duration");
        this.special = GsonHelper.m_13824_((JsonObject)this.json, (String)"special", (int)0);
        this.power = GsonHelper.m_13927_((JsonObject)this.json, (String)"eu");
        this.amps = GsonHelper.m_13824_((JsonObject)this.json, (String)"amps", (int)1);
        this.map = GsonHelper.m_13906_((JsonObject)this.json, (String)"map");
        this.hidden = GsonHelper.m_13912_((JsonObject)this.json, (String)"hidden");
        for (JsonElement e : GsonHelper.m_13832_((JsonObject)this.json, (String)"chances", (JsonArray)new JsonArray())) {
            this.chances.add(e.getAsInt());
        }
    }

    public static JsonElement serializeStack(FluidStack stack) {
        JsonObject obj = new JsonObject();
        obj.addProperty("fluid", FluidPlatformUtils.getFluidId((Fluid)stack.getFluid()).toString());
        obj.addProperty("amount", (Number)stack.getRealAmount());
        if (stack.hasTag()) {
            obj.add("tag", (JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)stack.getTag()));
        }
        return obj;
    }

    @Nullable
    public JsonElement serializeIngredientStack(IngredientStackJS in) {
        JsonElement element = in.ingredient.toJson();
        if (element instanceof JsonObject) {
            JsonObject object = (JsonObject)element;
            if (in.getCount() > 1) {
                object.addProperty(in.countKey, (Number)in.getCount());
            }
        }
        return element;
    }

    public static JsonElement serializeFluid(FluidIngredient stack) {
        return stack.toJson();
    }

    public void serialize() {
        JsonArray arr;
        if (this.inputItems.size() > 0) {
            arr = new JsonArray();
            this.inputItems.forEach(t -> arr.add(t.toJson()));
            this.json.add("item_in", (JsonElement)arr);
        }
        if (this.outputItems.size() > 0) {
            arr = new JsonArray();
            this.outputItems.forEach(t -> arr.add(t.toResultJson()));
            this.json.add("item_out", (JsonElement)arr);
        }
        if (this.fluidInput.size() > 0) {
            arr = new JsonArray();
            this.fluidInput.forEach(t -> arr.add(KubeJSRecipe.serializeFluid(t)));
            this.json.add("fluid_in", (JsonElement)arr);
        }
        if (this.fluidOutput.size() > 0) {
            arr = new JsonArray();
            this.fluidOutput.forEach(t -> arr.add(KubeJSRecipe.serializeStack(t)));
            this.json.add("fluid_out", (JsonElement)arr);
        }
        if (this.chances.size() > 0) {
            arr = new JsonArray();
            this.chances.forEach(arg_0 -> ((JsonArray)arr).add(arg_0));
            this.json.add("chances", (JsonElement)arr);
        }
        this.json.addProperty("eu", (Number)this.power);
        this.json.addProperty("duration", (Number)this.duration);
        this.json.addProperty("amps", (Number)this.amps);
        this.json.addProperty("special", (Number)this.special);
        this.json.addProperty("hidden", Boolean.valueOf(this.hidden));
        this.json.addProperty("map", this.map);
    }
}

