/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.integration.kubejs;

import dev.latvian.mods.kubejs.event.EventJS;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.worldgen.StoneLayerOre;
import muramasa.antimatter.worldgen.object.WorldGenStoneLayer;
import muramasa.antimatter.worldgen.object.WorldGenStoneLayerBuilder;
import muramasa.antimatter.worldgen.vein.WorldGenVeinLayer;
import muramasa.antimatter.worldgen.vein.WorldGenVeinLayerBuilder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class AMWorldEvent
extends EventJS {
    public final List<WorldGenVeinLayer> VEINS = new ObjectArrayList();
    public final List<WorldGenStoneLayer> STONE_LAYERS = new ObjectArrayList();
    public final Int2ObjectOpenHashMap<List<StoneLayerOre>> COLLISION_MAP = new Int2ObjectOpenHashMap();
    public boolean disableBuiltin = false;

    public final void vein(String id, int minY, int maxY, int weight, int density, int size, Material primary, Material secondary, Material between, Material sporadic, String ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            dimensions = new String[]{"overworld"};
        }
        this.VEINS.add(new WorldGenVeinLayerBuilder(id).asOreVein(minY, maxY, weight, density, size, primary, secondary, between, sporadic, (ResourceKey[])Arrays.stream(dimensions).map(t -> ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(t))).toArray(ResourceKey[]::new)).buildVein());
    }

    public final void stoneLayer(String id, String stoneType, int weight, int minHeight, int maxHeight, String ... dimensionKeys) {
        if (dimensionKeys == null || dimensionKeys.length == 0) {
            dimensionKeys = new String[]{"overworld"};
        }
        List<ResourceKey<Level>> dimension = Arrays.stream(dimensionKeys).map(dimensionKey -> ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(dimensionKey))).toList();
        StoneType type = Objects.requireNonNull(AntimatterAPI.get(StoneType.class, stoneType));
        this.STONE_LAYERS.addAll(new WorldGenStoneLayerBuilder(id).withStone(type).withWeight(weight).atHeight(minHeight, maxHeight).inDimensions(dimension).buildVein());
    }

    public final void disableBuiltin() {
        this.disableBuiltin = true;
    }

    public void addCollision(BlockState top, BlockState bottom, StoneLayerOre ... oresToAdd) {
        ((List)this.COLLISION_MAP.computeIfAbsent(Objects.hash(top, bottom), k -> new ObjectArrayList())).addAll(Arrays.asList(oresToAdd));
    }
}

