/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.integration.jeirei.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import muramasa.antimatter.integration.jeirei.renderer.IRecipeInfoRenderer;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.recipe.IRecipe;
import net.minecraft.client.gui.Font;

public class InfoRenderers {
    public static final IRecipeInfoRenderer BLASTING_RENDERER = new IRecipeInfoRenderer(){

        @Override
        public void render(PoseStack stack, IRecipe recipe, Font fontRenderer, int guiOffsetX, int guiOffsetY) {
            if (recipe.getDuration() == 0 && recipe.getPower() == 0L) {
                return;
            }
            String power = "Duration: " + recipe.getDuration() + " ticks";
            String euT = "EU/t: " + recipe.getPower();
            String total = "Total: " + recipe.getPower() * (long)recipe.getDuration() + " EU";
            String temperature = "Temperature: " + recipe.getSpecialValue() + " K";
            Tier tier = Tier.getTier((int)(recipe.getPower() / (long)recipe.getAmps()));
            String formattedText = " (" + tier.getId().toUpperCase() + ")";
            this.renderString(stack, power, fontRenderer, 5.0f, 0.0f, guiOffsetX, guiOffsetY);
            this.renderString(stack, euT, fontRenderer, 5.0f, 10.0f, guiOffsetX, guiOffsetY);
            this.renderString(stack, formattedText, fontRenderer, 5 + this.stringWidth(euT, fontRenderer), 10.0f, Tier.EV.getRarityFormatting().m_126665_(), guiOffsetX, guiOffsetY);
            this.renderString(stack, temperature, fontRenderer, 5.0f, 20.0f, guiOffsetX, guiOffsetY);
            this.renderString(stack, total, fontRenderer, 5.0f, 30.0f, guiOffsetX, guiOffsetY);
        }

        @Override
        public int getRows() {
            return 4;
        }
    };
    public static final IRecipeInfoRenderer BASIC_RENDERER = new IRecipeInfoRenderer(){

        @Override
        public void render(PoseStack stack, IRecipe recipe, Font fontRenderer, int guiOffsetX, int guiOffsetY) {
            this.renderString(stack, "Duration: " + recipe.getDuration() + " ticks", fontRenderer, 5.0f, 0.0f, guiOffsetX, guiOffsetY);
        }

        @Override
        public int getRows() {
            return 1;
        }
    };
    public static final IRecipeInfoRenderer EMPTY_RENDERER = (stack, recipe, fontRenderer, guiOffsetX, guiOffsetY) -> {};
    public static final IRecipeInfoRenderer DEFAULT_RENDERER = new IRecipeInfoRenderer(){

        @Override
        public void render(PoseStack stack, IRecipe recipe, Font fontRenderer, int guiOffsetX, int guiOffsetY) {
            if (recipe.getDuration() == 0 && recipe.getPower() == 0L) {
                return;
            }
            String power = "Duration: " + recipe.getDuration() + " ticks";
            String euT = "EU/t: " + recipe.getPower();
            String amps = "Amps: " + recipe.getAmps();
            String total = "Total: " + recipe.getPower() * (long)recipe.getDuration() + " EU";
            Tier tier = Tier.getTier((int)(recipe.getPower() / (long)recipe.getAmps()));
            String formattedText = " (" + tier.getId().toUpperCase() + ")";
            this.renderString(stack, power, fontRenderer, 5.0f, 0.0f, guiOffsetX, guiOffsetY);
            this.renderString(stack, euT, fontRenderer, 5.0f, 10.0f, guiOffsetX, guiOffsetY);
            this.renderString(stack, formattedText, fontRenderer, 5 + this.stringWidth(euT, fontRenderer), 10.0f, Tier.EV.getRarityFormatting().m_126665_(), guiOffsetX, guiOffsetY);
            this.renderString(stack, amps, fontRenderer, 5.0f, 20.0f, guiOffsetX, guiOffsetY);
            this.renderString(stack, total, fontRenderer, 5.0f, 30.0f, guiOffsetX, guiOffsetY);
        }

        @Override
        public int getRows() {
            return 4;
        }
    };
    public static final IRecipeInfoRenderer RF_RENDERER = new IRecipeInfoRenderer(){

        @Override
        public void render(PoseStack stack, IRecipe recipe, Font fontRenderer, int guiOffsetX, int guiOffsetY) {
            if (recipe.getDuration() == 0 && recipe.getPower() == 0L) {
                return;
            }
            String power = "Duration: " + recipe.getDuration() + " ticks";
            String euT = "RF/t: " + recipe.getPower();
            String total = "Total: " + recipe.getPower() * (long)recipe.getDuration() + " RF";
            this.renderString(stack, power, fontRenderer, 5.0f, 0.0f, guiOffsetX, guiOffsetY);
            this.renderString(stack, euT, fontRenderer, 5.0f, 10.0f, guiOffsetX, guiOffsetY);
            this.renderString(stack, total, fontRenderer, 5.0f, 20.0f, guiOffsetX, guiOffsetY);
        }

        @Override
        public int getRows() {
            return 3;
        }
    };
    public static final IRecipeInfoRenderer FUEL_RENDERER = new IRecipeInfoRenderer(){

        @Override
        public void render(PoseStack stack, IRecipe recipe, Font fontRenderer, int guiOffsetX, int guiOffsetY) {
            String fuelPerMb = "Fuel content(mb): " + (double)recipe.getPower() / (double)Objects.requireNonNull(recipe.getInputFluids()).get(0).getAmount();
            String fuelPerB = "Fuel content(bb): " + (double)recipe.getPower() / (double)Objects.requireNonNull(recipe.getInputFluids()).get(0).getAmount() * 1000.0;
            this.renderString(stack, fuelPerMb, fontRenderer, 5.0f, 0.0f, guiOffsetX, guiOffsetY);
            this.renderString(stack, fuelPerB, fontRenderer, 5.0f, 10.0f, guiOffsetX, guiOffsetY);
        }

        @Override
        public int getRows() {
            return 2;
        }
    };
    public static final IRecipeInfoRenderer STEAM_RENDERER = new IRecipeInfoRenderer(){

        @Override
        public void render(PoseStack stack, IRecipe recipe, Font fontRenderer, int guiOffsetX, int guiOffsetY) {
            String power = "Duration: " + recipe.getDuration() + " ticks";
            String euT = "Steam: ";
            String total = "Total steam: " + (long)recipe.getDuration() * recipe.getPower() + " mb";
            this.renderString(stack, power, fontRenderer, 5.0f, 0.0f, guiOffsetX, guiOffsetY);
            this.renderString(stack, euT + recipe.getPower() + "mb/t", fontRenderer, 5.0f, 10.0f, guiOffsetX, guiOffsetY);
            this.renderString(stack, total, fontRenderer, 5.0f, 20.0f, guiOffsetX, guiOffsetY);
        }

        @Override
        public int getRows() {
            return 3;
        }
    };
}

