/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.integration.jeirei;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import muramasa.antimatter.Antimatter;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.gui.GuiData;
import muramasa.antimatter.integration.jei.AntimatterJEIPlugin;
import muramasa.antimatter.integration.rei.REIUtils;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.recipe.map.IRecipeMap;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class AntimatterJEIREIPlugin {
    private static final List<ItemLike> ITEMS_TO_HIDE = new ArrayList<ItemLike>();
    private static final Object2ObjectMap<ResourceLocation, RegistryValue> REGISTRY = new Object2ObjectLinkedOpenHashMap();

    public static void registerCategory(IRecipeMap map, GuiData gui, Tier tier, ResourceLocation model, boolean override) {
        if (REGISTRY.containsKey((Object)new ResourceLocation(map.getDomain(), map.getId())) && !override) {
            Antimatter.LOGGER.info("Attempted duplicate category registration: " + map.getId());
            return;
        }
        REGISTRY.put((Object)new ResourceLocation(map.getDomain(), map.getId()), (Object)new RegistryValue(map, map.getGui() == null ? gui : map.getGui(), tier, model));
    }

    public static void registerCategoryModel(IRecipeMap map, ResourceLocation model, Tier tier) {
        RegistryValue value = (RegistryValue)REGISTRY.get((Object)map.getLoc());
        if (value != null) {
            if (value.model == null) {
                value.model = model;
            }
            if (value.tier != tier) {
                value.tier = tier;
            }
        }
    }

    public static Object2ObjectMap<ResourceLocation, RegistryValue> getREGISTRY() {
        return REGISTRY;
    }

    public static void showCategory(Machine<?> ... types) {
        if (AntimatterAPI.isModLoaded("jei") && !AntimatterAPI.isModLoaded("roughlyenoughitems")) {
            AntimatterJEIPlugin.showCategory(types);
        } else if (AntimatterAPI.isModLoaded("roughlyenoughitems")) {
            REIUtils.showCategory(types);
        }
    }

    public static void uses(FluidStack val, boolean USE) {
        if (AntimatterAPI.isModLoaded("jei") && !AntimatterAPI.isModLoaded("roughlyenoughitems")) {
            AntimatterJEIPlugin.uses(val, USE);
        } else if (AntimatterAPI.isModLoaded("roughlyenoughitems")) {
            REIUtils.uses(val, USE);
        }
    }

    public static <T> void addModDescriptor(List<Component> tooltip, T t) {
        if (AntimatterAPI.isModLoaded("jei") && !AntimatterAPI.isModLoaded("roughlyenoughitems")) {
            AntimatterJEIPlugin.addModDescriptor(tooltip, t);
        } else if (AntimatterAPI.isModLoaded("roughlyenoughitems")) {
            REIUtils.addModDescriptor(tooltip, t);
        }
    }

    public static void addItemsToHide(ItemLike ... itens) {
        ITEMS_TO_HIDE.addAll(Arrays.asList(itens));
    }

    public static List<ItemLike> getItemsToHide() {
        return ITEMS_TO_HIDE;
    }

    public static class RegistryValue {
        public IRecipeMap map;
        public GuiData gui;
        public Tier tier;
        public ResourceLocation model;

        public RegistryValue(IRecipeMap map, GuiData gui, Tier tier, ResourceLocation model) {
            this.map = map;
            this.gui = gui;
            this.tier = tier;
            this.model = model;
        }
    }
}

