/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.integration.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.Data;
import muramasa.antimatter.gui.BarDir;
import muramasa.antimatter.gui.GuiData;
import muramasa.antimatter.gui.SlotData;
import muramasa.antimatter.gui.SlotType;
import muramasa.antimatter.gui.slot.AbstractSlot;
import muramasa.antimatter.gui.slot.SlotOutput;
import muramasa.antimatter.integration.jei.AntimatterJEIPlugin;
import muramasa.antimatter.integration.jeirei.renderer.IRecipeInfoRenderer;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.recipe.ingredient.FluidIngredient;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.antimatter.recipe.map.IRecipeMap;
import muramasa.antimatter.recipe.map.RecipeMap;
import muramasa.antimatter.util.Utils;
import muramasa.antimatter.util.int4;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapCategory
implements IRecipeCategory<IRecipe> {
    protected static int JEI_OFFSET_X = 1;
    protected static int JEI_OFFSET_Y = 1;
    protected static IGuiHelper guiHelper;
    protected String title;
    protected final ResourceLocation loc;
    protected final RecipeType<IRecipe> type;
    protected IDrawable background;
    protected IDrawable icon;
    protected IDrawableAnimated progressBar;
    protected GuiData gui;
    protected Tier guiTier;
    private final IRecipeInfoRenderer infoRenderer;

    public RecipeMapCategory(IRecipeMap map, RecipeType<IRecipe> type, GuiData gui, Tier defaultTier, ResourceLocation blockItemModel) {
        this.loc = map.getLoc();
        this.type = type;
        this.guiTier = map.getGuiTier() == null ? defaultTier : map.getGuiTier();
        this.title = map.getDisplayName().getString();
        int4 area = gui.getArea();
        int4 progress = gui.dir.getUV();
        this.background = guiHelper.drawableBuilder(gui.getTexture(this.guiTier, "machine"), area.x, area.y, area.z, area.w).addPadding(0, map.getInfoRenderer().getRows() <= 0 ? 0 : 7 + 10 * map.getInfoRenderer().getRows(), 0, 0).build();
        this.progressBar = guiHelper.drawableBuilder(gui.getTexture(this.guiTier, "machine"), progress.x, progress.y, progress.z, progress.w).buildAnimated(50, this.fromDir(gui.dir), !gui.barFill);
        Object icon = map.getIcon();
        if (icon != null) {
            if (icon instanceof ItemStack) {
                this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)((ItemStack)icon));
            }
            if (icon instanceof ItemLike) {
                this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)icon));
            }
            if (icon instanceof IDrawable) {
                this.icon = (IDrawable)icon;
            }
        } else {
            Machine machine = blockItemModel == null ? null : AntimatterAPI.get(Machine.class, blockItemModel.m_135815_(), blockItemModel.m_135827_());
            this.icon = machine == null || !machine.getTiers().contains(defaultTier) ? guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)Data.DEBUG_SCANNER, 1)) : guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)machine.getItem(defaultTier), 1));
        }
        this.gui = gui;
        this.infoRenderer = map.getInfoRenderer();
    }

    private IDrawableAnimated.StartDirection fromDir(BarDir dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case BarDir.TOP -> IDrawableAnimated.StartDirection.TOP;
            case BarDir.BOTTOM -> IDrawableAnimated.StartDirection.BOTTOM;
            case BarDir.LEFT -> IDrawableAnimated.StartDirection.LEFT;
            case BarDir.RIGHT -> IDrawableAnimated.StartDirection.RIGHT;
        };
    }

    public RecipeType<IRecipe> getRecipeType() {
        return this.type;
    }

    public ResourceLocation getUid() {
        return this.loc;
    }

    public Component getTitle() {
        return new TextComponent(this.title);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder slot;
        int s;
        List<SlotData<AbstractSlot>> slots;
        int slotCount;
        List inputs = recipe.hasInputItems() ? recipe.getInputItems().stream().map(t -> Arrays.asList(t.m_43908_())).toList() : Collections.emptyList();
        List outputs = recipe.hasOutputItems() ? Arrays.stream(recipe.getOutputItems(false)).toList() : Collections.emptyList();
        boolean groupIndex = false;
        int offsetX = this.gui.getArea().x + JEI_OFFSET_X;
        int offsetY = this.gui.getArea().y + JEI_OFFSET_Y;
        int inputItems = 0;
        int inputFluids = 0;
        if (recipe.hasInputItems() && (slotCount = (slots = this.gui.getSlots().getSlots(SlotType.IT_IN, this.guiTier)).size()) > 0) {
            if (inputs.size() > 0) {
                slotCount = Math.min(slotCount, inputs.size());
                for (s = 0; s < slotCount; ++s) {
                    slot = builder.addSlot(RecipeIngredientRole.INPUT, slots.get(s).getX() - (offsetX - 1), slots.get(s).getY() - (offsetY - 1));
                    List input = (List)inputs.get(s);
                    if (input.size() == 0) {
                        ObjectArrayList st = new ObjectArrayList(1);
                        st.add(new ItemStack((ItemLike)Data.DEBUG_SCANNER, 1));
                        slot.addIngredients(VanillaTypes.ITEM, (List)st);
                        continue;
                    }
                    slot.addIngredients(VanillaTypes.ITEM, input);
                    int ss = s;
                    slot.addTooltipCallback((ing, list) -> {
                        Ingredient patt7169$temp = recipe.getInputItems().get(ss);
                        if (patt7169$temp instanceof RecipeIngredient) {
                            Ingredient i;
                            RecipeIngredient ri = (RecipeIngredient)patt7169$temp;
                            if (ri.ignoreConsume()) {
                                list.add(new TextComponent("Does not get consumed in the process.").m_130940_(ChatFormatting.WHITE));
                            }
                            if (ri.ignoreNbt()) {
                                list.add(new TextComponent("Ignores NBT.").m_130940_(ChatFormatting.WHITE));
                            }
                            if (RecipeMap.isIngredientSpecial(i = recipe.getInputItems().get(ss))) {
                                list.add(new TextComponent("Special ingredient. Class name: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(i.getClass().getSimpleName()).m_130940_(ChatFormatting.GOLD)));
                            }
                        }
                    });
                    ++inputItems;
                }
            }
        }
        if (recipe.hasOutputItems() && (slotCount = (slots = this.gui.getSlots().getSlots(SlotType.IT_OUT, this.guiTier)).size()) > 0) {
            slotCount = Math.min(slotCount, outputs.size());
            s = 0;
            while (s < slotCount) {
                slot = builder.addSlot(RecipeIngredientRole.OUTPUT, slots.get(s).getX() - (offsetX - 1), slots.get(s).getY() - (offsetY - 1));
                slot.addIngredient(VanillaTypes.ITEM, (Object)((ItemStack)outputs.get(s)));
                int ss = s++;
                slot.addTooltipCallback((ing, list) -> {
                    if (recipe.hasChances() && recipe.getChances()[ss] < 10000) {
                        list.add(new TextComponent("Chance: " + (float)recipe.getChances()[ss] / 100.0f + "%").m_130940_(ChatFormatting.WHITE));
                    }
                });
            }
        }
        if (recipe.hasInputFluids() && (slotCount = (slots = this.gui.getSlots().getSlots(SlotType.FL_IN, this.guiTier)).size()) > 0) {
            List<FluidIngredient> fluids = recipe.getInputFluids();
            slotCount = Math.min(slotCount, fluids.size());
            for (int s2 = 0; s2 < slotCount; ++s2) {
                IRecipeSlotBuilder slot2 = builder.addSlot(RecipeIngredientRole.INPUT, slots.get(s2).getX() - (offsetX - 1), slots.get(s2).getY() - (offsetY - 1));
                AntimatterJEIPlugin.addFluidIngredients(slot2, Arrays.asList(fluids.get(s2).getStacks()));
                slot2.setFluidRenderer((int)fluids.get(s2).getAmount(), true, 16, 16);
                slot2.addTooltipCallback((ing, list) -> {
                    if (Utils.hasNoConsumeTag(AntimatterJEIPlugin.getIngredient((ITypedIngredient)ing.getDisplayedIngredient().get()))) {
                        list.add(new TextComponent("Does not get consumed in the process").m_130940_(ChatFormatting.WHITE));
                    }
                });
                ++inputFluids;
            }
        }
        if (recipe.hasOutputFluids() && (slotCount = (slots = this.gui.getSlots().getSlots(SlotType.FL_OUT, this.guiTier)).size()) > 0) {
            FluidStack[] fluids = recipe.getOutputFluids();
            slotCount = Math.min(slotCount, fluids.length);
            for (int s3 = 0; s3 < slotCount; ++s3) {
                IRecipeSlotBuilder slot3 = builder.addSlot(RecipeIngredientRole.OUTPUT, slots.get(s3).getX() - (offsetX - 1), slots.get(s3).getY() - (offsetY - 1));
                slot3.setFluidRenderer(fluids[s3].getAmount(), true, 16, 16);
                AntimatterJEIPlugin.addFluidIngredients(slot3, Collections.singletonList(fluids[s3]));
            }
        }
    }

    public Class getRecipeClass() {
        return IRecipe.class;
    }

    public void draw(IRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        if (this.progressBar != null) {
            this.progressBar.draw(stack, this.gui.dir.getPos().x + this.gui.getArea().x, this.gui.dir.getPos().y + this.gui.getArea().y);
        }
        this.infoRenderer.render(stack, recipe, Minecraft.m_91087_().f_91062_, JEI_OFFSET_X, this.gui.getArea().y + JEI_OFFSET_Y + this.gui.getArea().z / 2);
        int offsetX = this.gui.getArea().x + JEI_OFFSET_X;
        int offsetY = this.gui.getArea().y + JEI_OFFSET_Y;
        if (recipe.hasChances()) {
            List views = recipeSlotsView.getSlotViews(RecipeIngredientRole.OUTPUT);
            List<SlotData<SlotOutput>> slots = this.gui.getSlots().getSlots(SlotType.IT_OUT, this.guiTier);
            for (int i = 0; i < views.size(); ++i) {
                if (!((double)recipe.getChances()[i] < 1.0)) continue;
                RenderSystem.m_69461_();
                RenderSystem.m_69465_();
                stack.m_85836_();
                stack.m_85841_(0.5f, 0.5f, 1.0f);
                String ch = recipe.getChances()[i] * 100 + "%";
                Minecraft.m_91087_().f_91062_.m_92750_(stack, ch, 2.0f * ((float)slots.get(i).getX() - (float)(offsetX - 1)), 2.0f * ((float)slots.get(i).getY() - (float)(offsetY - 1)), 0xFFFF00);
                stack.m_85849_();
                RenderSystem.m_69478_();
                RenderSystem.m_69482_();
            }
        }
    }

    public static void setGuiHelper(IGuiHelper helper) {
        guiHelper = helper;
    }
}

