/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.integration.jei.category;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeRegistration;
import muramasa.antimatter.Data;
import muramasa.antimatter.integration.jei.category.MultiMachineInfoPage;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MultiMachineInfoCategory
implements IRecipeCategory<MultiMachineInfoPage> {
    private static IGuiHelper guiHelper;
    private final IDrawable background = guiHelper.createBlankDrawable(176, 150);
    private final IDrawable icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)Data.DEBUG_SCANNER, 1));
    private static final ResourceLocation UID;
    private static final Set<MultiMachineInfoPage> MULTI_MACHINES_PAGES;

    public static void setGuiHelper(IGuiHelper guiHelper) {
        MultiMachineInfoCategory.guiHelper = guiHelper;
    }

    public static void addMultiMachine(MultiMachineInfoPage page) {
        MULTI_MACHINES_PAGES.add(page);
    }

    public static void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(MULTI_MACHINES_PAGES, UID);
    }

    public boolean handleClick(@Nonnull MultiMachineInfoPage recipe, double mouseX, double mouseY, int mouseButton) {
        return recipe.handleClick(mouseX, mouseY, mouseButton);
    }

    public void draw(@Nonnull MultiMachineInfoPage recipe, @Nonnull PoseStack matrixStack, double mouseX, double mouseY) {
        recipe.drawInfo(matrixStack, (int)mouseX, (int)mouseY);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends MultiMachineInfoPage> getRecipeClass() {
        return MultiMachineInfoPage.class;
    }

    @Nonnull
    public Component getTitle() {
        return new TextComponent("Multi Machines Title");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull MultiMachineInfoPage recipe, @Nonnull IIngredients ingredients) {
        recipe.setIngredients(ingredients);
    }

    @Nonnull
    public List<Component> getTooltipStrings(@Nonnull MultiMachineInfoPage recipe, double mouseX, double mouseY) {
        return recipe.getTooltipStrings(mouseX, mouseY);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull MultiMachineInfoPage recipe, @Nonnull IIngredients ingredients) {
        recipe.setRecipeLayout(recipeLayout, guiHelper);
    }

    static {
        UID = new ResourceLocation("antimatter_shared", "multi_machine_info");
        MULTI_MACHINES_PAGES = Sets.newHashSet();
    }
}

