/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.integration.jei;

import java.util.List;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.gui.SlotType;
import muramasa.antimatter.gui.container.ContainerBasicMachine;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.recipe.map.IRecipeMap;
import muramasa.antimatter.tile.TileEntityMachine;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;

public class MachineTransferHandler
implements IRecipeTransferInfo<ContainerBasicMachine, IRecipe> {
    final ResourceLocation id;

    public MachineTransferHandler(ResourceLocation id) {
        this.id = id;
    }

    public Class<ContainerBasicMachine> getContainerClass() {
        return ContainerBasicMachine.class;
    }

    public boolean canHandle(ContainerBasicMachine container, IRecipe recipe) {
        String name;
        String[] split = recipe.getMapId().split(":");
        if (split.length == 2) {
            name = split[1];
        } else if (split.length == 1) {
            name = split[0];
        } else {
            return false;
        }
        IRecipeMap rmap = AntimatterAPI.get(IRecipeMap.class, name);
        if (rmap == null) {
            return false;
        }
        Machine<?> machine = ((TileEntityMachine)container.getTile()).getMachineType();
        if (machine.getRecipeMap() == null || machine.getRecipeMap() != rmap) {
            return false;
        }
        if (!recipe.hasInputItems()) {
            return false;
        }
        return container.slotMap.containsKey(SlotType.IT_IN);
    }

    public List<Slot> getRecipeSlots(ContainerBasicMachine container, IRecipe recipe) {
        return (List)container.slotMap.get(SlotType.IT_IN);
    }

    public List<Slot> getInventorySlots(ContainerBasicMachine container, IRecipe recipe) {
        return container.playerSlots;
    }

    public RecipeType<IRecipe> getRecipeType() {
        return new RecipeType(this.getRecipeCategoryUid(), this.getRecipeClass());
    }

    public Class<IRecipe> getRecipeClass() {
        return IRecipe.class;
    }

    public ResourceLocation getRecipeCategoryUid() {
        return this.id;
    }
}

