/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.integration.jei;

import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import muramasa.antimatter.Antimatter;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.Data;
import muramasa.antimatter.fluid.AntimatterFluid;
import muramasa.antimatter.integration.jei.MachineTransferHandler;
import muramasa.antimatter.integration.jei.category.MultiMachineInfoCategory;
import muramasa.antimatter.integration.jei.category.RecipeMapCategory;
import muramasa.antimatter.integration.jei.extension.JEIMaterialRecipeExtension;
import muramasa.antimatter.integration.jei.forge.AntimatterJEIPluginImpl;
import muramasa.antimatter.integration.jeirei.AntimatterJEIREIPlugin;
import muramasa.antimatter.machine.MachineFlag;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTypeItem;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.recipe.Recipe;
import muramasa.antimatter.recipe.map.IRecipeMap;
import muramasa.antimatter.recipe.material.MaterialRecipe;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@JeiPlugin
public class AntimatterJEIPlugin
implements IModPlugin {
    public static final Map<String, RecipeType<IRecipe>> RECIPE_TYPES = new Object2ObjectOpenHashMap();
    private static IJeiRuntime runtime;
    private static IJeiHelpers helpers;

    public AntimatterJEIPlugin() {
        Antimatter.LOGGER.info("Creating AntimatterAPI's JEI Plugin");
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("antimatter", "jei");
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        if (AntimatterAPI.isModLoaded("roughlyenoughitems")) {
            return;
        }
        runtime = jeiRuntime;
        runtime.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM, (Collection)AntimatterAPI.all(AntimatterFluid.class).stream().map(t -> new ItemStack((ItemLike)Item.f_41373_.get(t.getFluidBlock()))).collect(Collectors.toList()));
        runtime.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM, Collections.singletonList(new ItemStack((ItemLike)Data.PROXY_INSTANCE)));
        AntimatterAPI.all(MaterialTypeItem.class, t -> {
            if (!t.hidden()) {
                return;
            }
            List stacks = t.all().stream().map(obj -> t.get((Material)obj, 1)).collect(Collectors.toList());
            if (stacks.isEmpty()) {
                return;
            }
            runtime.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM, stacks);
        });
        runtime.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM, AntimatterJEIREIPlugin.getItemsToHide().stream().map(i -> i.m_5456_().m_7968_()).toList());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (AntimatterAPI.isModLoaded("roughlyenoughitems")) {
            return;
        }
        RecipeMapCategory.setGuiHelper(registry.getJeiHelpers().getGuiHelper());
        MultiMachineInfoCategory.setGuiHelper(registry.getJeiHelpers().getGuiHelper());
        if (helpers == null) {
            helpers = registry.getJeiHelpers();
        }
        ObjectOpenHashSet registeredMachineCats = new ObjectOpenHashSet();
        AntimatterJEIREIPlugin.getREGISTRY().forEach((arg_0, arg_1) -> AntimatterJEIPlugin.lambda$registerCategories$4((Set)registeredMachineCats, registry, arg_0, arg_1));
        registry.addRecipeCategories(new IRecipeCategory[]{new MultiMachineInfoCategory()});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        if (AntimatterAPI.isModLoaded("roughlyenoughitems")) {
            return;
        }
        if (helpers == null) {
            helpers = registration.getJeiHelpers();
        }
        AntimatterJEIREIPlugin.getREGISTRY().forEach((id, tuple) -> registration.addRecipes(RECIPE_TYPES.get(id.toString()), this.getRecipes(id.m_135815_())));
        MultiMachineInfoCategory.registerRecipes(registration);
    }

    private List<IRecipe> getRecipes(String recipeMap) {
        RecipeManager manager = this.getRecipeManager();
        if (manager == null) {
            return Collections.emptyList();
        }
        return manager.m_44013_(Recipe.RECIPE_TYPE).stream().filter(r -> r.getMapId().equals(recipeMap) && !r.isHidden()).toList();
    }

    private RecipeManager getRecipeManager() {
        if (AntimatterAPI.getSIDE().isServer()) {
            return AntimatterPlatformUtils.getCurrentServer().m_129894_();
        }
        if (this.getWorld() == null) {
            return null;
        }
        return this.getWorld().m_7465_();
    }

    @OnlyIn(value=Dist.CLIENT)
    ClientLevel getWorld() {
        return Minecraft.m_91087_().f_91073_;
    }

    public static void showCategory(Machine<?> ... types) {
        if (runtime != null) {
            LinkedList<ResourceLocation> list = new LinkedList<ResourceLocation>();
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].has(MachineFlag.RECIPE)) continue;
                list.add(types[i].getRecipeMap().getLoc());
            }
            runtime.getRecipesGui().showCategories(list);
        }
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        if (AntimatterAPI.isModLoaded("roughlyenoughitems")) {
            return;
        }
        registration.getCraftingCategory().addCategoryExtension(MaterialRecipe.class, JEIMaterialRecipeExtension::new);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        AntimatterJEIREIPlugin.getREGISTRY().forEach((id, tuple) -> registration.addRecipeTransferHandler((IRecipeTransferInfo)new MachineTransferHandler(tuple.map.getLoc())));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void uses(FluidStack val, boolean USE) {
        void var1_1;
        AntimatterJEIPluginImpl.uses(val, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addFluidIngredients(IRecipeSlotBuilder builder, List<FluidStack> stacks) {
        void var1_1;
        AntimatterJEIPluginImpl.addFluidIngredients(builder, (List<FluidStack>)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static FluidStack getIngredient(ITypedIngredient<?> ingredient) {
        return AntimatterJEIPluginImpl.getIngredient(ingredient);
    }

    public static IJeiRuntime getRuntime() {
        return runtime;
    }

    public static <T> void addModDescriptor(List<Component> tooltip, T t) {
        if (t == null || helpers == null) {
            return;
        }
        String text = helpers.getModIdHelper().getFormattedModNameForModId(AntimatterJEIPlugin.getRuntime().getIngredientManager().getIngredientHelper(t).getDisplayModId(t));
        tooltip.add((Component)new TextComponent(text));
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        if (AntimatterAPI.isModLoaded("roughlyenoughitems")) {
            return;
        }
        AntimatterAPI.all(Machine.class, machine -> {
            IRecipeMap map = machine.getRecipeMap();
            if (map == null) {
                return;
            }
            machine.getTiers().forEach(t -> {
                ItemStack stack = new ItemStack((ItemLike)machine.getItem((Tier)t));
                if (!stack.m_41619_()) {
                    registration.addRecipeCatalyst(stack, new ResourceLocation[]{map.getLoc()});
                }
            });
        });
    }

    private static /* synthetic */ void lambda$registerCategories$4(Set registeredMachineCats, IRecipeCategoryRegistration registry, ResourceLocation id, AntimatterJEIREIPlugin.RegistryValue tuple) {
        if (!registeredMachineCats.contains(tuple.map.getLoc())) {
            RecipeType type = new RecipeType(tuple.map.getLoc(), IRecipe.class);
            RECIPE_TYPES.put(type.getUid().toString(), (RecipeType<IRecipe>)type);
            registry.addRecipeCategories(new IRecipeCategory[]{new RecipeMapCategory(tuple.map, (RecipeType<IRecipe>)type, tuple.gui, tuple.tier, tuple.model)});
            registeredMachineCats.add(tuple.map.getLoc());
        }
    }
}

