/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import muramasa.antimatter.capability.machine.MachineRecipeHandler;
import muramasa.antimatter.gui.BarDir;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.ICanSyncData;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.Widget;
import muramasa.antimatter.gui.container.ContainerMachine;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.integration.jeirei.AntimatterJEIREIPlugin;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.util.int4;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class ProgressWidget
extends Widget {
    public final BarDir direction;
    public final boolean barFill;
    private final int4 uv;
    private int progress = 0;
    private int maxProgress = 0;
    private float percent = 0.0f;

    public ProgressWidget(GuiInstance instance, IGuiElement parent, int4 loc, BarDir dir, int x, int y, int width, int height, boolean barFill) {
        super(instance, parent);
        this.direction = dir;
        this.uv = loc;
        this.barFill = barFill;
        this.setX(x);
        this.setY(y);
        this.setW(width);
        this.setH(height);
    }

    @Override
    public void init() {
        super.init();
        this.gui.syncFloat(() -> ((TileEntityMachine)((ContainerMachine)this.gui.container).getTile()).recipeHandler.map(MachineRecipeHandler::getClientProgress).orElse(Float.valueOf(0.0f)), i -> {
            this.percent = i.floatValue();
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        this.gui.syncInt(() -> ((TileEntityMachine)((ContainerMachine)this.gui.container).getTile()).recipeHandler.map(MachineRecipeHandler::getCurrentProgress).orElse(0), i -> {
            this.progress = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        this.gui.syncInt(() -> ((TileEntityMachine)((ContainerMachine)this.gui.container).getTile()).recipeHandler.map(rec -> rec.getActiveRecipe() == null ? 0 : rec.getActiveRecipe().getDuration()).orElse(0), i -> {
            this.maxProgress = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
    }

    public static WidgetSupplier build(BarDir dir, boolean barFill) {
        return ProgressWidget.builder((a, b) -> new ProgressWidget((GuiInstance)a, (IGuiElement)b, dir.getUV(), dir, dir.getPos().x + 6, dir.getPos().y + 6, dir.getUV().z, dir.getUV().w, barFill));
    }

    @Override
    public void render(PoseStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        int x = this.realX();
        int y = this.realY();
        int xLocation = this.uv.x;
        int yLocation = this.uv.y;
        int length = this.uv.z;
        int width = this.uv.w;
        switch (this.direction) {
            case TOP: {
                int progressTime = (int)((float)this.uv.w * this.percent);
                if (!this.barFill) {
                    progressTime = width - progressTime;
                }
                y = y + width - progressTime;
                yLocation = yLocation + width - progressTime;
                width = progressTime;
                break;
            }
            case LEFT: {
                int progressTime = (int)((float)this.uv.z * this.percent);
                if (this.barFill) {
                    length = progressTime;
                    break;
                }
                length -= progressTime;
                break;
            }
            case BOTTOM: {
                int progressTime = (int)((float)this.uv.w * this.percent);
                if (this.barFill) {
                    width = progressTime;
                    break;
                }
                width -= progressTime;
                break;
            }
            default: {
                int progressTime = (int)((float)this.uv.z * this.percent);
                if (!this.barFill) {
                    progressTime = length - progressTime;
                }
                x = x + length - progressTime;
                xLocation = xLocation + length - progressTime;
                length = progressTime;
            }
        }
        if (this.progress > 0) {
            this.drawTexture(matrixStack, this.gui.handler.getGuiTexture(), this.realX(), this.realY(), xLocation, yLocation, length, width);
        }
    }

    @Override
    public void mouseOver(PoseStack stack, double mouseX, double mouseY, float partialTicks) {
        super.mouseOver(stack, mouseX, mouseY, partialTicks);
        if (this.isInside(mouseX, mouseY)) {
            this.renderTooltip(stack, (Component)new TranslatableComponent("antimatter.gui.show_recipes"), mouseX, mouseY);
        }
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        if (this.gui.handler instanceof TileEntityMachine) {
            AntimatterJEIREIPlugin.showCategory(((TileEntityMachine)this.gui.handler).getMachineType());
        }
    }
}

