/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.Widget;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.machine.MachineFlag;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.util.int4;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class MachineStateWidget
extends Widget {
    protected final int4 state = new int4(176, 56, 8, 8);
    protected final boolean isRecipe;

    protected MachineStateWidget(GuiInstance gui, IGuiElement parent) {
        super(gui, parent);
        this.isRecipe = ((TileEntityMachine)gui.handler).has(MachineFlag.RECIPE);
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void render(PoseStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        MachineState machineState = ((TileEntityMachine)this.gui.handler).getMachineState();
        if (this.isRecipe && machineState == MachineState.POWER_LOSS) {
            this.drawTexture(matrixStack, this.gui.handler.getGuiTexture(), this.realX(), this.realY(), this.state.x, this.state.y, this.state.z, this.state.w);
        }
    }

    @Override
    public void mouseOver(PoseStack stack, double mouseX, double mouseY, float partialTicks) {
        super.mouseOver(stack, mouseX, mouseY, partialTicks);
        MachineState machineState = ((TileEntityMachine)this.gui.handler).getMachineState();
        if (this.isRecipe) {
            this.renderTooltip(stack, (Component)new TextComponent(machineState.getDisplayName()), mouseX, mouseY);
        }
    }

    public static WidgetSupplier build() {
        return MachineStateWidget.builder(MachineStateWidget::new);
    }
}

