/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import muramasa.antimatter.capability.machine.MachineRecipeHandler;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.ICanSyncData;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.Widget;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.integration.jeirei.renderer.IInfoRenderer;
import muramasa.antimatter.tile.multi.TileEntityMultiMachine;
import muramasa.antimatter.tile.pipe.TileEntityFluidPipe;
import muramasa.antimatter.tile.pipe.TileEntityPipe;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import tesseract.FluidPlatformUtils;
import tesseract.TesseractGraphWrappers;
import tesseract.api.ITickingController;
import tesseract.api.fluid.FluidHolder;
import tesseract.api.gt.GTController;
import tesseract.api.item.ItemController;

public class InfoRenderWidget<T extends InfoRenderWidget<T>>
extends Widget {
    final IInfoRenderer<T> renderer;

    protected InfoRenderWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<T> renderer) {
        super(gui, parent);
        this.renderer = renderer;
    }

    @Override
    public void render(PoseStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        this.renderer.drawInfo(this, matrixStack, Minecraft.m_91087_().f_91062_, this.realX(), this.realY());
    }

    public static <T extends InfoRenderWidget<T>> WidgetSupplier build(IInfoRenderer<T> renderer) {
        return InfoRenderWidget.builder((a, b) -> new InfoRenderWidget((GuiInstance)a, (IGuiElement)b, renderer));
    }

    public static WidgetSupplier build() {
        return InfoRenderWidget.builder((a, b) -> new InfoRenderWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer)((Object)a.handler)));
    }

    public static class TesseractFluidWidget
    extends InfoRenderWidget<TesseractFluidWidget> {
        public int holderPressure = 0;
        public FluidStack stack = FluidStack.EMPTY;

        protected TesseractFluidWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<TesseractFluidWidget> renderer) {
            super(gui, parent, renderer);
        }

        @Override
        public void init() {
            super.init();
            TileEntityFluidPipe pipe = (TileEntityFluidPipe)this.gui.handler;
            long pos = pipe.m_58899_().m_121878_();
            this.gui.syncFluidStack(() -> {
                Set fluids;
                FluidHolder holder = pipe.getHolder();
                if (holder != null && (fluids = holder.getFluids()) != null && fluids.size() > 0) {
                    long pressure = holder.tickPressure * 20L - holder.getPressureAvailable();
                    return FluidPlatformUtils.createFluidStack((Fluid)((FluidHolder.SetHolder)fluids.iterator().next()).fluid, (long)pressure);
                }
                return FluidStack.EMPTY;
            }, a -> {
                this.stack = a;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }

        public static WidgetSupplier build() {
            return TesseractFluidWidget.builder((a, b) -> new TesseractFluidWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer)((Object)a.handler)));
        }
    }

    public static class TesseractItemWidget
    extends InfoRenderWidget<TesseractItemWidget> {
        public int transferred = 0;
        public int cableTransferred = 0;

        protected TesseractItemWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<TesseractItemWidget> renderer) {
            super(gui, parent, renderer);
        }

        @Override
        public void init() {
            super.init();
            TileEntityPipe pipe = (TileEntityPipe)this.gui.handler;
            long pos = pipe.m_58899_().m_121878_();
            this.gui.syncInt(() -> {
                ITickingController controller = TesseractGraphWrappers.ITEM.getController(pipe.m_58904_(), pipe.m_58899_().m_121878_());
                if (controller == null) {
                    return 0;
                }
                ItemController gt = (ItemController)controller;
                return gt.getTransferred();
            }, a -> {
                this.transferred = a;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncInt(() -> {
                ITickingController controller = TesseractGraphWrappers.ITEM.getController(pipe.m_58904_(), pipe.m_58899_().m_121878_());
                if (controller == null) {
                    return 0;
                }
                ItemController gt = (ItemController)controller;
                return gt.getCableTransferred(pipe.m_58899_().m_121878_());
            }, a -> {
                this.cableTransferred = a;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }

        public static WidgetSupplier build() {
            return TesseractItemWidget.builder((a, b) -> new TesseractItemWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer)((Object)a.handler)));
        }
    }

    public static class TesseractGTWidget
    extends InfoRenderWidget<TesseractGTWidget> {
        public long voltAverage = 0L;
        public long ampAverage = 0L;
        public long loss = 0L;

        protected TesseractGTWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<TesseractGTWidget> renderer) {
            super(gui, parent, renderer);
        }

        @Override
        public void init() {
            super.init();
            TileEntityPipe pipe = (TileEntityPipe)this.gui.handler;
            long pos = pipe.m_58899_().m_121878_();
            this.gui.syncLong(() -> {
                ITickingController controller = TesseractGraphWrappers.GT_ENERGY.getController(pipe.m_58904_(), pipe.m_58899_().m_121878_());
                if (controller == null) {
                    return 0L;
                }
                GTController gt = (GTController)controller;
                return gt.getTotalVoltage();
            }, a -> {
                this.voltAverage = a;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncLong(() -> {
                ITickingController controller = TesseractGraphWrappers.GT_ENERGY.getController(pipe.m_58904_(), pipe.m_58899_().m_121878_());
                if (controller == null) {
                    return 0L;
                }
                GTController gt = (GTController)controller;
                return gt.totalAmps();
            }, a -> {
                this.ampAverage = a;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncLong(() -> {
                ITickingController controller = TesseractGraphWrappers.GT_ENERGY.getController(pipe.m_58904_(), pipe.m_58899_().m_121878_());
                if (controller == null) {
                    return 0L;
                }
                GTController gt = (GTController)controller;
                return gt.totalLoss();
            }, a -> {
                this.loss = a;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }

        public static WidgetSupplier build() {
            return TesseractGTWidget.builder((a, b) -> new TesseractGTWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer)((Object)a.handler)));
        }
    }

    public static class MultiRenderWidget
    extends InfoRenderWidget<MultiRenderWidget> {
        public int currentProgress = 0;
        public int maxProgress = 0;
        public int overclock = 0;
        public long euT = 0L;

        protected MultiRenderWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<MultiRenderWidget> renderer) {
            super(gui, parent, renderer);
        }

        public boolean drawActiveInfo() {
            return true;
        }

        @Override
        public void init() {
            super.init();
            TileEntityMultiMachine m = (TileEntityMultiMachine)this.gui.handler;
            this.gui.syncInt(() -> m.recipeHandler.map(MachineRecipeHandler::getCurrentProgress).orElse(0), i -> {
                this.currentProgress = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncInt(() -> m.recipeHandler.map(MachineRecipeHandler::getMaxProgress).orElse(0), i -> {
                this.maxProgress = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncInt(() -> m.recipeHandler.map(MachineRecipeHandler::getOverclock).orElse(0), i -> {
                this.overclock = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncLong(() -> m.recipeHandler.map(MachineRecipeHandler::getPower).orElse(0L), i -> {
                this.euT = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }

        public static WidgetSupplier build() {
            return MultiRenderWidget.builder((a, b) -> new MultiRenderWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer)((Object)a.handler)));
        }
    }
}

