/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import muramasa.antimatter.cover.CoverOutput;
import muramasa.antimatter.gui.ButtonOverlay;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.ICanSyncData;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.container.ContainerMachine;
import muramasa.antimatter.gui.event.GuiEvents;
import muramasa.antimatter.gui.widget.AbstractSwitchWidget;
import muramasa.antimatter.gui.widget.ButtonWidget;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.machine.MachineFlag;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.util.int4;
import net.minecraft.resources.ResourceLocation;

public class IOWidget
extends AbstractSwitchWidget {
    @Nullable
    protected ButtonWidget item;
    @Nullable
    protected ButtonWidget fluid;
    private static final int4 fluidLoc = new int4(176, 18, 18, 18);
    private static final int4 itemLoc = new int4(176, 36, 18, 18);
    private boolean itemState = false;
    private boolean fluidState = false;

    protected IOWidget(GuiInstance instance, IGuiElement parent, int x, int y, int w, int h) {
        super(instance, parent, new ResourceLocation(instance.handler.handlerDomain(), "textures/gui/button/gui_buttons.png"), ButtonOverlay.INPUT_OUTPUT, IOWidget::handler, false);
        this.setX(x);
        this.setY(y);
        this.setW(w);
        this.setH(h);
        ContainerMachine m = (ContainerMachine)instance.container;
        if (((TileEntityMachine)m.getTile()).getMachineType().has(MachineFlag.ITEM)) {
            this.item = (ButtonWidget)ButtonWidget.build(new ResourceLocation(instance.handler.handlerDomain(), "textures/gui/button/gui_buttons.png"), instance.handler.getGuiTexture(), itemLoc, null, GuiEvents.ITEM_EJECT, 0).setSize(26, 0, w, h).buildAndAdd(instance, this);
            this.item.setEnabled(false);
            this.item.setStateHandler(wid -> this.itemState);
            this.item.setDepth(this.depth() + 1);
        }
        if (((TileEntityMachine)m.getTile()).getMachineType().has(MachineFlag.FLUID)) {
            this.fluid = (ButtonWidget)ButtonWidget.build(new ResourceLocation(instance.handler.handlerDomain(), "textures/gui/button/gui_buttons.png"), instance.handler.getGuiTexture(), fluidLoc, null, GuiEvents.FLUID_EJECT, 0).setSize(44, 0, w, h).buildAndAdd(instance, this);
            this.fluid.setStateHandler(wid -> this.fluidState);
            this.fluid.setEnabled(false);
            this.fluid.setDepth(this.depth() + 1);
        }
    }

    @Override
    public void render(PoseStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        if (this.item != null && this.item.isEnabled()) {
            this.item.render(matrixStack, mouseX, mouseY, partialTicks);
        }
        if (this.fluid != null && this.fluid.isEnabled()) {
            this.fluid.render(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void init() {
        super.init();
        ContainerMachine m = (ContainerMachine)this.gui.container;
        if (this.item != null) {
            this.gui.syncBoolean(() -> ((TileEntityMachine)m.getTile()).coverHandler.map(t -> ((CoverOutput)t.getOutputCover()).shouldOutputItems()).orElse(false), this::setItem, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }
        if (this.fluid != null) {
            this.gui.syncBoolean(() -> ((TileEntityMachine)m.getTile()).coverHandler.map(t -> ((CoverOutput)t.getOutputCover()).shouldOutputFluids()).orElse(false), this::setFluid, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }
    }

    @Override
    public void updateSize() {
        super.updateSize();
        if (this.item != null) {
            this.item.updateSize();
        }
        if (this.fluid != null) {
            this.fluid.updateSize();
        }
    }

    private static void handler(AbstractSwitchWidget widget, boolean state) {
        IOWidget wid = (IOWidget)widget;
        if (wid.item != null) {
            wid.item.setEnabled(state);
        }
        if (wid.fluid != null) {
            wid.fluid.setEnabled(state);
        }
    }

    private void setItem(boolean item) {
        this.itemState = item;
    }

    private void setFluid(boolean item) {
        this.fluidState = item;
    }

    public static WidgetSupplier build(int x, int y, int w, int h) {
        return IOWidget.builder((a, b) -> new IOWidget((GuiInstance)a, (IGuiElement)b, x, y, w, h));
    }
}

