/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.gui.widget;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import muramasa.antimatter.capability.IGuiHandler;
import muramasa.antimatter.client.RenderHelper;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.ICanSyncData;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.SlotData;
import muramasa.antimatter.gui.Widget;
import muramasa.antimatter.gui.event.SlotClickEvent;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.integration.jeirei.AntimatterJEIREIPlugin;
import muramasa.antimatter.network.packets.AbstractGuiEventPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import tesseract.TesseractCapUtils;

public class FluidSlotWidget
extends Widget {
    private final int slot;
    private final SlotData<?> slots;
    private FluidStack stack = FluidStack.EMPTY;

    protected FluidSlotWidget(GuiInstance gui, IGuiElement parent, int fluidSlot, SlotData<?> slots) {
        super(gui, parent);
        this.slot = fluidSlot;
        this.slots = slots;
        this.setX(slots.getX());
        this.setY(slots.getY());
        this.setW(16);
        this.setH(16);
    }

    public static WidgetSupplier build(int slot, SlotData<?> slots) {
        return FluidSlotWidget.builder((a, b) -> new FluidSlotWidget((GuiInstance)a, (IGuiElement)b, slot, slots));
    }

    @Override
    public void init() {
        super.init();
        IGuiHandler iGuiHandler = this.gui.handler;
        if (iGuiHandler instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)iGuiHandler;
            this.gui.syncFluidStack(() -> TesseractCapUtils.getFluidHandler((BlockEntity)blockEntity, null).map(t -> t.getFluidInTank(this.slot)).orElse(FluidStack.EMPTY), stack -> {
                this.stack = stack;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }
    }

    @Override
    public void render(PoseStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        this.renderFluid(matrixStack, this.stack, this.realX(), this.realY());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderFluid(PoseStack stack, FluidStack fluid, int x, int y) {
        if (fluid.isEmpty()) {
            return;
        }
        RenderHelper.drawFluid(stack, Minecraft.m_91087_(), x, y, this.getW(), this.getH(), 16, fluid);
    }

    @Override
    public void mouseOver(PoseStack stack, double mouseX, double mouseY, float partialTicks) {
        super.mouseOver(stack, mouseX, mouseY, partialTicks);
        if (this.stack.isEmpty()) {
            return;
        }
        int x = this.realX();
        int y = this.realY();
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        int slotColor = -2130706433;
        this.fillGradient(stack, x, y, x + 16, y + 16, slotColor, slotColor);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
        ArrayList<Component> str = new ArrayList<Component>();
        str.add((Component)new TextComponent(this.stack.getDisplayName().getString()));
        str.add((Component)new TextComponent(NumberFormat.getNumberInstance(Locale.US).format(this.stack.getAmount()) + " mB").m_130940_(ChatFormatting.GRAY));
        AntimatterJEIREIPlugin.addModDescriptor(str, this.stack);
        this.drawHoverText(str, (int)mouseX, (int)mouseY, Minecraft.m_91087_().f_91062_, stack);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers, double mouseX, double mouseY) {
        if (!this.isInside(mouseX, mouseY)) {
            return super.keyPressed(keyCode, scanCode, modifiers, mouseX, mouseY);
        }
        InputConstants.Key input = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (!input.m_84874_().equals("key.keyboard.u") && !input.m_84874_().equals("key.keyboard.r")) {
            return false;
        }
        AntimatterJEIREIPlugin.uses(this.stack, input.m_84874_().equals("key.keyboard.u"));
        return true;
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        AbstractGuiEventPacket pkt = this.gui.handler.createGuiPacket(new SlotClickEvent(this.slot, this.slots.getType()));
        this.gui.sendPacket(pkt);
    }
}

