/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import muramasa.antimatter.gui.ButtonBody;
import muramasa.antimatter.gui.ButtonOverlay;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.Widget;
import muramasa.antimatter.gui.event.GuiEvents;
import muramasa.antimatter.gui.event.IGuiEvent;
import muramasa.antimatter.gui.widget.ScreenWidget;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.util.int4;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ButtonWidget
extends Widget {
    protected final ResourceLocation res;
    @Nullable
    protected final ResourceLocation bodyLoc;
    @Nullable
    protected final int4 resLoc;
    @Nullable
    protected final ButtonBody body;
    @Nullable
    protected final ButtonOverlay overlayOn;
    @Nullable
    protected final ButtonOverlay overlayOff;
    @Nullable
    protected String message;
    @Nullable
    protected String tooltipKey;
    protected Function<ButtonWidget, Boolean> activeHandler;
    protected Consumer<ButtonWidget> onPress;
    protected boolean pressed = false;

    public ButtonWidget(GuiInstance instance, IGuiElement parent, ResourceLocation res, @Nullable ButtonBody body, @Nullable ButtonOverlay overlayOn, @Nullable ButtonOverlay overlayOff, @Nullable Consumer<ButtonWidget> onPress) {
        super(instance, parent);
        this.res = res;
        this.body = body;
        this.overlayOff = overlayOff;
        this.overlayOn = overlayOn;
        this.resLoc = null;
        this.bodyLoc = null;
        this.onPress = onPress;
    }

    protected void setClick(Consumer<ButtonWidget> clicker) {
        this.onPress = clicker;
    }

    public ButtonWidget setStateHandler(Function<ButtonWidget, Boolean> func) {
        this.activeHandler = func;
        return this;
    }

    public ButtonWidget setTooltipKey(@Nullable String tooltipKey) {
        this.tooltipKey = tooltipKey;
        return this;
    }

    @Override
    public void onRelease(double mouseX, double mouseY) {
        this.pressed = false;
        super.onRelease(mouseX, mouseY);
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return;
        }
        this.pressed = true;
        super.onClick(mouseX, mouseY, button);
        if (this.onPress != null) {
            if (this.gui.handler.isRemote()) {
                this.clientClick();
            }
            this.onPress.accept(this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void clientClick() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    @Override
    public void mouseOver(PoseStack stack, double mouseX, double mouseY, float partialTicks) {
        super.mouseOver(stack, mouseX, mouseY, partialTicks);
        if (this.tooltipKey != null) {
            this.renderTooltip(stack, (Component)new TranslatableComponent(this.tooltipKey), mouseX, mouseY);
        }
    }

    @Override
    public void render(PoseStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        ButtonOverlay overlay;
        float color;
        boolean isActive;
        Minecraft minecraft = Minecraft.m_91087_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.res);
        RenderSystem.m_69465_();
        if (this.body != null) {
            int xTex = this.body.getX();
            int yTex = this.body.getY();
            if (this.isInside(mouseX, mouseY)) {
                xTex += this.body.getX2();
                yTex += this.body.getY2();
            }
            ScreenWidget.blit(matrixStack, this.realX(), this.realY(), this.getW(), this.getH(), xTex, yTex, this.body.getW(), this.body.getH(), 256, 256);
        }
        boolean bl = isActive = this.activeHandler == null || this.activeHandler.apply(this) != false;
        float f = isActive ? 1.0f : (color = this.pressed ? 0.75f : 0.5f);
        if (color < 1.0f) {
            RenderSystem.m_157429_((float)color, (float)color, (float)color, (float)1.0f);
        }
        if ((overlay = isActive && this.overlayOn != null ? this.overlayOn : this.overlayOff) != null) {
            ScreenWidget.blit(matrixStack, this.realX(), this.realY(), this.getW(), this.getH(), overlay.getX(), overlay.getY(), overlay.getW(), overlay.getH(), 256, 256);
        } else if (this.bodyLoc != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.bodyLoc);
            ScreenWidget.blit(matrixStack, this.realX(), this.realY(), this.getW(), this.getH(), this.resLoc.x, this.resLoc.y, this.resLoc.z, this.resLoc.w, 256, 256);
        }
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Component message = this.getMessage();
        if (!message.getString().isEmpty()) {
            GuiComponent.m_93215_((PoseStack)matrixStack, (Font)minecraft.f_91062_, (Component)message, (int)(this.realX() + this.getW() / 2), (int)(this.realY() + (this.getH() - 8) / 2), (int)0xFFFFFF);
        }
    }

    public ButtonWidget(GuiInstance instance, IGuiElement parent, ResourceLocation res, @Nullable ResourceLocation bodyLoc, @Nullable int4 loc, @Nullable ButtonOverlay overlayOn, @Nullable ButtonOverlay overlayOff, Consumer<ButtonWidget> onPress) {
        super(instance, parent);
        this.res = res;
        this.body = null;
        this.overlayOn = overlayOn;
        this.overlayOff = overlayOff;
        this.resLoc = loc;
        this.bodyLoc = bodyLoc;
        this.onPress = onPress;
    }

    public static WidgetSupplier build(ResourceLocation res, ButtonBody body, ButtonOverlay overlay, Consumer<ButtonWidget> onPress) {
        return ButtonWidget.builder((a, b) -> new ButtonWidget((GuiInstance)a, (IGuiElement)b, res, body, overlay, null, onPress)).clientSide();
    }

    public static WidgetSupplier build(ResourceLocation res, ButtonBody body, ButtonOverlay overlayOn, ButtonOverlay overlayOff, Consumer<ButtonWidget> onPress) {
        return ButtonWidget.builder((a, b) -> new ButtonWidget((GuiInstance)a, (IGuiElement)b, res, body, overlayOn, overlayOff, onPress)).clientSide();
    }

    public static WidgetSupplier build(ResourceLocation res, ResourceLocation bodyLoc, int4 loc, ButtonOverlay overlay, Consumer<ButtonWidget> onPress) {
        return ButtonWidget.builder((a, b) -> new ButtonWidget((GuiInstance)a, (IGuiElement)b, res, bodyLoc, loc, overlay, null, onPress)).clientSide();
    }

    public static WidgetSupplier build(ResourceLocation res, ResourceLocation bodyLoc, int4 loc, ButtonOverlay overlay, IGuiEvent.IGuiEventFactory ev, int id) {
        return ButtonWidget.builder((a, b) -> new ButtonWidget((GuiInstance)a, (IGuiElement)b, res, bodyLoc, loc, overlay, null, but -> but.gui.sendPacket(but.gui.handler.createGuiPacket(new GuiEvents.GuiEvent(ev, Screen.m_96638_() ? 1 : 0, id))))).clientSide();
    }

    public static WidgetSupplier build(ResourceLocation res, ResourceLocation bodyLoc, int4 loc, ButtonOverlay overlayOn, ButtonOverlay overlayOff, IGuiEvent.IGuiEventFactory ev, int id) {
        return ButtonWidget.builder((a, b) -> new ButtonWidget((GuiInstance)a, (IGuiElement)b, res, bodyLoc, loc, overlayOn, overlayOff, but -> but.gui.sendPacket(but.gui.handler.createGuiPacket(new GuiEvents.GuiEvent(ev, Screen.m_96638_() ? 1 : 0, id))))).clientSide();
    }

    public static WidgetSupplier build(String res, ButtonBody body, ButtonOverlay overlay, IGuiEvent.IGuiEventFactory ev, int id) {
        return ButtonWidget.builder((a, b) -> new ButtonWidget((GuiInstance)a, (IGuiElement)b, new ResourceLocation(a.handler.handlerDomain(), res), body, overlay, null, but -> but.gui.sendPacket(but.gui.handler.createGuiPacket(new GuiEvents.GuiEvent(ev, Screen.m_96638_() ? 1 : 0, id))))).clientSide();
    }

    public static WidgetSupplier build(String res, ButtonBody body, ButtonOverlay overlay, IGuiEvent.IGuiEventFactory ev, int id, String tooltipKey) {
        return ButtonWidget.builder((a, b) -> new ButtonWidget((GuiInstance)a, (IGuiElement)b, new ResourceLocation(a.handler.handlerDomain(), res), body, overlay, null, but -> but.gui.sendPacket(but.gui.handler.createGuiPacket(new GuiEvents.GuiEvent(ev, Screen.m_96638_() ? 1 : 0, id)))).setTooltipKey(tooltipKey)).clientSide();
    }
}

