/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.Widget;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BackgroundWidget
extends Widget {
    private final int xSize;
    private final int ySize;
    private final int guiXSize;
    private final int guiYSize;
    private final ResourceLocation loc;

    protected BackgroundWidget(GuiInstance instance, IGuiElement parent, ResourceLocation loc, int xSize, int ySize, int guiXSize, int guiYSize) {
        super(instance, parent);
        this.xSize = xSize;
        this.ySize = ySize;
        this.guiXSize = guiXSize;
        this.guiYSize = guiYSize;
        this.loc = loc;
        this.setDepth(-1);
    }

    @Override
    public void setParent(IGuiElement parent) {
        super.setParent(parent);
        this.setDepth(parent.depth() - 1);
    }

    public static WidgetSupplier build(ResourceLocation loc, int w, int h) {
        return BackgroundWidget.builder((a, b) -> new BackgroundWidget((GuiInstance)a, (IGuiElement)b, loc, w, h, 256, 256)).clientSide();
    }

    public static WidgetSupplier build(ResourceLocation loc, int w, int h, int guiW, int guiH) {
        return BackgroundWidget.builder((a, b) -> new BackgroundWidget((GuiInstance)a, (IGuiElement)b, loc, w, h, guiW, guiH)).clientSide();
    }

    @Override
    public void render(PoseStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        this.drawTexture(matrixStack, this.loc, this.realX(), this.realY(), 0, 0, this.xSize, this.ySize);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawTexture(PoseStack stack, ResourceLocation loc, int left, int top, int x, int y, int sizeX, int sizeY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)loc);
        GuiComponent.m_93133_((PoseStack)stack, (int)left, (int)top, (float)x, (float)y, (int)sizeX, (int)sizeY, (int)this.guiXSize, (int)this.guiYSize);
    }
}

