/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import muramasa.antimatter.gui.ButtonBody;
import muramasa.antimatter.gui.ButtonOverlay;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.widget.ButtonWidget;
import muramasa.antimatter.gui.widget.ScreenWidget;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractSwitchWidget
extends ButtonWidget {
    private final ResourceLocation res;
    private ButtonBody on;
    private ButtonBody off;
    private ButtonOverlay body;
    private boolean state;
    protected final ISwitchable onSwitch;

    protected AbstractSwitchWidget(GuiInstance instance, IGuiElement parent, ResourceLocation res, ButtonBody on, ButtonBody off, ISwitchable onSwitch) {
        super(instance, parent, res, on, off, null, null);
        this.res = res;
        this.on = on;
        this.off = off;
        this.onSwitch = onSwitch;
        this.setClick(b -> this.onPress());
    }

    protected AbstractSwitchWidget(GuiInstance instance, IGuiElement parent, ResourceLocation res, ButtonOverlay body, ISwitchable onSwitch, boolean defaultState) {
        super(instance, parent, res, null, body, null, null);
        this.res = res;
        this.body = body;
        this.onSwitch = onSwitch;
        this.state = defaultState;
        this.setClick(b -> this.onPress());
    }

    protected AbstractSwitchWidget(GuiInstance instance, IGuiElement parent, ResourceLocation res, ButtonOverlay body, String text, ISwitchable onSwitch) {
        super(instance, parent, res, null, body, null, null);
        this.res = res;
        this.body = body;
        this.onSwitch = onSwitch;
        this.setClick(b -> this.onPress());
    }

    protected boolean state() {
        return this.state;
    }

    @Override
    public void render(PoseStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.res);
        RenderSystem.m_69465_();
        boolean mouseOver = this.isInside(mouseX, mouseY);
        if (this.body == null) {
            ButtonBody body = this.isSwitched() ? this.on : this.off;
            int xTex = body.getX();
            int yTex = body.getY();
            if (mouseOver) {
                xTex += body.getX2();
                yTex += body.getY2();
            }
            ScreenWidget.blit(matrixStack, this.realX(), this.realY(), this.getW(), this.getH(), xTex, yTex, body.getW(), body.getH(), 256, 256);
        } else {
            int xTex = this.body.getX();
            int yTex = this.body.getY();
            float f = this.isSwitched() ? 1.0f : (mouseOver ? 0.75f : 0.5f);
            RenderSystem.m_157429_((float)f, (float)f, (float)f, (float)1.0f);
            ScreenWidget.blit(matrixStack, this.realX(), this.realY(), this.getW(), this.getH(), xTex, yTex, this.body.getW(), this.body.getH(), 256, 256);
        }
        RenderSystem.m_69482_();
    }

    public boolean isSwitched() {
        return this.state;
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
    }

    public void onPress() {
        this.state = !this.state;
        this.onSwitch.onSwitch(this, this.isSwitched());
    }

    public static interface ISwitchable {
        public void onSwitch(AbstractSwitchWidget var1, boolean var2);
    }
}

