/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.stream.Collectors;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.Widget;
import muramasa.antimatter.gui.container.IAntimatterContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class AntimatterContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements MenuAccess<T>,
IGuiElement {
    public AntimatterContainerScreen(T container, Inventory invPlayer, Component title) {
        super(container, invPlayer, title);
        ((IAntimatterContainer)container).source().initClient(this);
    }

    protected void m_7856_() {
        super.m_7856_();
        ((IAntimatterContainer)this.f_97732_).source().rescale(this);
    }

    public void m_181908_() {
        super.m_181908_();
        ((IAntimatterContainer)this.f_97732_).source().update(this.mouseX(), this.mouseY());
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (Widget widget : ((IAntimatterContainer)this.f_97732_).source().getWidgets(mouseX, mouseY)) {
            if (!widget.isEnabled() || !widget.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public double mouseX() {
        return this.f_96541_.f_91067_.m_91589_() * (double)this.f_96541_.m_91268_().m_85445_() / (double)this.f_96541_.m_91268_().m_85443_();
    }

    public double mouseY() {
        return this.f_96541_.f_91067_.m_91594_() * (double)this.f_96541_.m_91268_().m_85446_() / (double)this.f_96541_.m_91268_().m_85444_();
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (Widget wid : ((IAntimatterContainer)this.f_97732_).source().getWidgets(mouseX, mouseY)) {
            if (!wid.isEnabled() || !wid.mouseDragged(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        for (Widget wid : ((IAntimatterContainer)this.f_97732_).source().getWidgets(mouseX, mouseY)) {
            if (!wid.isEnabled() || !wid.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        double x = this.mouseX();
        double y = this.mouseY();
        for (Widget wid : ((IAntimatterContainer)this.f_97732_).source().getWidgets(x, y)) {
            if (!wid.isEnabled() || !wid.keyPressed(keyCode, scanCode, modifiers, x, y)) continue;
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
        float ticks = Minecraft.m_91087_().m_91296_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(-this.f_97735_), (double)(-this.f_97736_), 0.0);
        for (Widget widget : ((IAntimatterContainer)this.f_97732_).source().widgetsToRender()) {
            if (!widget.isEnabled() || !widget.isVisible() || widget.depth() < this.depth()) continue;
            widget.render(matrixStack, x, y, ticks);
        }
        ((IAntimatterContainer)this.f_97732_).source().getTopLevelWidget(x, y).ifPresent(t -> t.mouseOver(matrixStack, x, y, ticks));
        matrixStack.m_85849_();
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        this.m_7333_(matrixStack);
        for (Widget widget : ((IAntimatterContainer)this.f_97732_).source().widgetsToRender()) {
            if (!widget.isEnabled() || !widget.isVisible()) continue;
            if (widget.depth() >= this.depth()) {
                return;
            }
            widget.render(matrixStack, x, y, Minecraft.m_91087_().m_91296_());
        }
    }

    public void drawTexture(PoseStack stack, ResourceLocation loc, int left, int top, int x, int y, int sizeX, int sizeY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.m_91087_().m_91097_().m_174784_(loc);
        this.m_93228_(stack, left, top, x, y, sizeX, sizeY);
    }

    public int getCenteredStringX(String s) {
        return this.f_97726_ / 2 - Minecraft.m_91087_().f_91062_.m_92895_(s) / 2;
    }

    public void drawTooltipInArea(PoseStack stack, String line, int mouseX, int mouseY, int x, int y, int sizeX, int sizeY) {
        ObjectArrayList list = new ObjectArrayList();
        list.add(line);
        this.drawTooltipInArea(stack, (List<String>)list, mouseX, mouseY, x, y, sizeX, sizeY);
    }

    public void drawTooltipInArea(PoseStack stack, List<String> lines, int mouseX, int mouseY, int x, int y, int sizeX, int sizeY) {
        if (this.isInGui(x, y, sizeX, sizeY, mouseX, mouseY)) {
            this.m_96617_(stack, lines.stream().map(t -> FormattedCharSequence.m_13714_((String)t, (Style)Style.f_131099_)).collect(Collectors.toList()), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    public boolean isInRect(int x, int y, int xSize, int ySize, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX <= (double)(x + xSize) && mouseY >= (double)y && mouseY <= (double)(y + ySize);
    }

    public boolean isInGui(int x, int y, int xSize, int ySize, double mouseX, double mouseY) {
        return this.isInRect(x, y, xSize, ySize, mouseX - (double)this.f_97735_, mouseY - (double)this.f_97736_);
    }

    @Override
    public int getX() {
        return this.f_97735_;
    }

    @Override
    public int getY() {
        return this.f_97736_;
    }

    @Override
    public int getW() {
        return this.f_96543_;
    }

    @Override
    public int getH() {
        return this.f_96544_;
    }

    @Override
    public IGuiElement parent() {
        return null;
    }

    @Override
    public void setX(int x) {
        throw new IllegalStateException("Cannot set X on root gui");
    }

    @Override
    public void setY(int y) {
        throw new IllegalStateException("Cannot set X on root gui");
    }

    @Override
    public void setW(int w) {
        throw new IllegalStateException("Cannot set X on root gui");
    }

    @Override
    public void setH(int h) {
        throw new IllegalStateException("Cannot set X on root gui");
    }

    @Override
    public int realX() {
        return this.getX();
    }

    @Override
    public int realY() {
        return this.getY();
    }

    @Override
    public int depth() {
        return 0;
    }
}

