/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.gui.event;

import java.util.Optional;
import java.util.function.BiFunction;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.capability.IGuiHandler;
import muramasa.antimatter.capability.machine.MachineFluidHandler;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.SlotType;
import muramasa.antimatter.gui.event.IGuiEvent;
import muramasa.antimatter.item.ItemFluidCell;
import muramasa.antimatter.tile.TileEntityMachine;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import tesseract.TesseractCapUtils;

public class SlotClickEvent
implements IGuiEvent {
    public static final IGuiEvent.IGuiEventFactory SLOT_CLICKED = AntimatterAPI.register(IGuiEvent.IGuiEventFactory.class, new IGuiEvent.IGuiEventFactory(){

        @Override
        public BiFunction<IGuiEvent.IGuiEventFactory, FriendlyByteBuf, IGuiEvent> factory() {
            return SlotClickEvent::new;
        }

        @Override
        public String getId() {
            return "slot_click";
        }
    });
    public final SlotType<?> type;
    public final int index;

    public SlotClickEvent(IGuiEvent.IGuiEventFactory factory, FriendlyByteBuf buffer) {
        this.index = buffer.m_130242_();
        ResourceLocation loc = buffer.m_130281_();
        this.type = AntimatterAPI.get(SlotType.class, loc.m_135815_(), loc.m_135827_());
    }

    public SlotClickEvent(int slotIndex, SlotType<?> type) {
        this.index = slotIndex;
        this.type = type;
    }

    @Override
    public boolean forward() {
        return false;
    }

    private IFluidHandler tryGetCap(IGuiHandler handler) {
        if (handler instanceof TileEntityMachine) {
            TileEntityMachine machine = (TileEntityMachine)handler;
            return machine.fluidHandler.map(MachineFluidHandler::getGuiHandler).orElse(null);
        }
        if (handler instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)handler;
            return TesseractCapUtils.getFluidHandler((BlockEntity)be, null).orElse(null);
        }
        return null;
    }

    @Override
    public void handle(Player player, GuiInstance instance) {
        IFluidHandler sink = this.tryGetCap(instance.handler);
        if (sink == null) {
            return;
        }
        ItemStack stack = player.f_36096_.m_142621_();
        if (this.type == SlotType.FL_IN || this.type == SlotType.FL_OUT) {
            int max = stack.m_41720_() instanceof ItemFluidCell ? ((ItemFluidCell)stack.m_41720_()).getCapacity() : 1000;
            Optional iHandler = TesseractCapUtils.getFluidHandlerItem((ItemStack)stack);
            boolean hasFluid = iHandler.map(t -> t.getTanks() > 0 && !t.getFluidInTank(0).isEmpty()).orElse(false);
            FluidActionResult res = hasFluid && this.type == SlotType.FL_IN ? FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)sink, (IItemHandler)new InvWrapper((Container)player.m_150109_()), (int)max, (Player)player, (boolean)true) : FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)sink, (IItemHandler)new InvWrapper((Container)player.m_150109_()), (int)max, (Player)player, (boolean)true);
            if (res.isSuccess() && !player.m_7500_()) {
                player.f_36096_.m_142503_(res.getResult());
            }
        }
    }

    @Override
    public IGuiEvent.IGuiEventFactory getFactory() {
        return SLOT_CLICKED;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.index);
        buffer.m_130085_(new ResourceLocation(this.type.getDomain(), this.type.getId()));
    }

    public static void init() {
    }
}

