/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.gui.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import muramasa.antimatter.gui.IGuiElement;

public class RTree<T extends IGuiElement> {
    private final int maxEntries;
    private final int minEntries;
    private final int numDims;
    private final float[] pointDims;
    private final SeedPicker seedPicker;
    private Node root;
    private volatile int size;

    public RTree(int maxEntries, int minEntries, int numDims, SeedPicker seedPicker) {
        assert (minEntries <= maxEntries / 2);
        this.numDims = numDims;
        this.maxEntries = maxEntries;
        this.minEntries = minEntries;
        this.seedPicker = seedPicker;
        this.pointDims = new float[numDims];
        this.root = this.buildRoot(true);
    }

    public RTree(int maxEntries, int minEntries, int numDims) {
        this(maxEntries, minEntries, numDims, SeedPicker.LINEAR);
    }

    private Node buildRoot(boolean asLeaf) {
        float[] initCoords = new float[this.numDims];
        float[] initDimensions = new float[this.numDims];
        for (int i = 0; i < this.numDims; ++i) {
            initCoords[i] = (float)Math.sqrt(3.4028234663852886E38);
            initDimensions[i] = -2.0f * (float)Math.sqrt(3.4028234663852886E38);
        }
        return new Node(initCoords, initDimensions, asLeaf);
    }

    public RTree() {
        this(50, 2, 2, SeedPicker.LINEAR);
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public int getMinEntries() {
        return this.minEntries;
    }

    public int getNumDims() {
        return this.numDims;
    }

    public int size() {
        return this.size;
    }

    public List<T> search(float[] coords, float[] dimensions) {
        assert (coords.length == this.numDims);
        assert (dimensions.length == this.numDims);
        LinkedList results = new LinkedList();
        this.search(coords, dimensions, this.root, results);
        return results;
    }

    private void search(float[] coords, float[] dimensions, Node n, LinkedList<T> results) {
        if (n.leaf) {
            for (Node e : n.children) {
                if (!this.isOverlap(coords, dimensions, e.coords, e.dimensions)) continue;
                results.add(((Entry)e).entry);
            }
        } else {
            for (Node c : n.children) {
                if (!this.isOverlap(coords, dimensions, c.coords, c.dimensions)) continue;
                this.search(coords, dimensions, c, results);
            }
        }
    }

    public boolean delete(float[] coords, float[] dimensions, T entry) {
        assert (coords.length == this.numDims);
        assert (dimensions.length == this.numDims);
        Node l = this.findLeaf(this.root, coords, dimensions, entry);
        if (l == null) {
            System.out.println("WTF?");
            this.findLeaf(this.root, coords, dimensions, entry);
        }
        assert (l != null) : "Could not find leaf for entry to delete";
        assert (l.leaf) : "Entry is not found at leaf?!?";
        ListIterator li = l.children.listIterator();
        Object removed = null;
        while (li.hasNext()) {
            Entry e = (Entry)li.next();
            if (!e.entry.equals(entry)) continue;
            removed = e.entry;
            li.remove();
            break;
        }
        if (removed != null) {
            this.condenseTree(l);
            --this.size;
        }
        if (this.size == 0) {
            this.root = this.buildRoot(true);
        }
        return removed != null;
    }

    public boolean delete(float[] coords, T entry) {
        return this.delete(coords, this.pointDims, entry);
    }

    private Node findLeaf(Node n, float[] coords, float[] dimensions, T entry) {
        if (n.leaf) {
            for (Node c : n.children) {
                if (!((Entry)c).entry.equals(entry)) continue;
                return n;
            }
            return null;
        }
        for (Node c : n.children) {
            Node result;
            if (!this.isOverlap(c.coords, c.dimensions, coords, dimensions) || (result = this.findLeaf(c, coords, dimensions, entry)) == null) continue;
            return result;
        }
        return null;
    }

    private void condenseTree(Node n) {
        HashSet<Node> q = new HashSet<Node>();
        while (n != this.root) {
            if (n.leaf && n.children.size() < this.minEntries) {
                q.addAll(n.children);
                n.parent.children.remove(n);
            } else if (!n.leaf && n.children.size() < this.minEntries) {
                LinkedList<Node> toVisit = new LinkedList<Node>(n.children);
                while (!toVisit.isEmpty()) {
                    Node c = toVisit.pop();
                    if (c.leaf) {
                        q.addAll(c.children);
                        continue;
                    }
                    toVisit.addAll(c.children);
                }
                n.parent.children.remove(n);
            } else {
                this.tighten(n);
            }
            n = n.parent;
        }
        if (this.root.children.size() == 0) {
            this.root = this.buildRoot(true);
        } else if (this.root.children.size() == 1 && !this.root.leaf) {
            this.root = this.root.children.get(0);
            this.root.parent = null;
        } else {
            this.tighten(this.root);
        }
        for (Node ne : q) {
            Entry e = (Entry)ne;
            this.insert(e.coords, e.dimensions, e.entry);
        }
        this.size -= q.size();
    }

    public void clear() {
        this.root = this.buildRoot(true);
    }

    public void insert(T w) {
        int x1 = w.realX();
        int y1 = w.realY();
        int width = w.getW();
        int height = w.getH();
        this.insert(new float[]{x1, y1}, new float[]{width, height}, w);
    }

    public boolean delete(T w) {
        int x1 = w.realX();
        int y1 = w.realY();
        int width = w.getW();
        int height = w.getH();
        return this.delete(new float[]{x1, y1}, new float[]{width, height}, w);
    }

    public void insert(float[] coords, float[] dimensions, T entry) {
        assert (coords.length == this.numDims);
        assert (dimensions.length == this.numDims);
        Entry e = new Entry(this, coords, dimensions, entry);
        Node l = this.chooseLeaf(this.root, e);
        l.children.add(e);
        ++this.size;
        e.parent = l;
        if (l.children.size() > this.maxEntries) {
            Node[] splits = this.splitNode(l);
            this.adjustTree(splits[0], splits[1]);
        } else {
            this.adjustTree(l, null);
        }
    }

    public void insert(float[] coords, T entry) {
        this.insert(coords, this.pointDims, entry);
    }

    public void visit(NodeVisitor<T> nv) {
        float[] coordBuf = new float[this.numDims];
        float[] dimBuf = new float[this.numDims];
        LinkedList<Node> toVisit = new LinkedList<Node>();
        HashMap<Node, Integer> nodeDepths = new HashMap<Node, Integer>();
        nodeDepths.put(this.root, 0);
        toVisit.add(this.root);
        while (!toVisit.isEmpty()) {
            Node currentNode = (Node)toVisit.remove();
            if (currentNode.parent != null) {
                nodeDepths.put(currentNode, (Integer)nodeDepths.get(currentNode.parent) + 1);
            }
            System.arraycopy(currentNode.coords, 0, coordBuf, 0, this.numDims);
            System.arraycopy(currentNode.dimensions, 0, dimBuf, 0, this.numDims);
            if (currentNode instanceof Entry) {
                nv.visit((Integer)nodeDepths.get(currentNode), coordBuf, dimBuf, ((Entry)currentNode).entry);
            } else {
                nv.visit((Integer)nodeDepths.get(currentNode), coordBuf, dimBuf, null);
            }
            toVisit.addAll(currentNode.children);
        }
    }

    private void adjustTree(Node n, Node nn) {
        if (n == this.root) {
            if (nn != null) {
                this.root = this.buildRoot(false);
                this.root.children.add(n);
                n.parent = this.root;
                this.root.children.add(nn);
                nn.parent = this.root;
            }
            this.tighten(this.root);
            return;
        }
        this.tighten(n);
        if (nn != null) {
            this.tighten(nn);
            if (n.parent.children.size() > this.maxEntries) {
                Node[] splits = this.splitNode(n.parent);
                this.adjustTree(splits[0], splits[1]);
            }
        }
        if (n.parent != null) {
            this.adjustTree(n.parent, null);
        }
    }

    private Node[] splitNode(Node n) {
        Node[] nn = new Node[]{n, new Node(n.coords, n.dimensions, n.leaf)};
        nn[1].parent = n.parent;
        if (nn[1].parent != null) {
            nn[1].parent.children.add(nn[1]);
        }
        LinkedList<Node> cc = new LinkedList<Node>(n.children);
        n.children.clear();
        Node[] ss = this.seedPicker == SeedPicker.LINEAR ? this.lPickSeeds(cc) : this.qPickSeeds(cc);
        nn[0].children.add(ss[0]);
        nn[1].children.add(ss[1]);
        this.tighten(nn);
        while (!cc.isEmpty()) {
            float a1;
            float a0;
            float e1;
            if (nn[0].children.size() >= this.minEntries && nn[1].children.size() + cc.size() == this.minEntries) {
                nn[1].children.addAll(cc);
                cc.clear();
                this.tighten(nn);
                return nn;
            }
            if (nn[1].children.size() >= this.minEntries && nn[0].children.size() + cc.size() == this.minEntries) {
                nn[0].children.addAll(cc);
                cc.clear();
                this.tighten(nn);
                return nn;
            }
            Node c = this.seedPicker == SeedPicker.LINEAR ? this.lPickNext(cc) : this.qPickNext(cc, nn);
            float e0 = this.getRequiredExpansion(nn[0].coords, nn[0].dimensions, c);
            Node preferred = e0 < (e1 = this.getRequiredExpansion(nn[1].coords, nn[1].dimensions, c)) ? nn[0] : (e0 > e1 ? nn[1] : ((a0 = this.getArea(nn[0].dimensions)) < (a1 = this.getArea(nn[1].dimensions)) ? nn[0] : (e0 > a1 ? nn[1] : (nn[0].children.size() < nn[1].children.size() ? nn[0] : (nn[0].children.size() > nn[1].children.size() ? nn[1] : nn[(int)Math.round(Math.random())])))));
            preferred.children.add(c);
            this.tighten(preferred);
        }
        return nn;
    }

    private Node[] qPickSeeds(LinkedList<Node> nn) {
        Node[] bestPair = new Node[2];
        float maxWaste = -3.4028235E38f;
        for (Node n1 : nn) {
            for (Node n2 : nn) {
                if (n1 == n2) continue;
                float n1a = this.getArea(n1.dimensions);
                float n2a = this.getArea(n2.dimensions);
                float ja = 1.0f;
                for (int i = 0; i < this.numDims; ++i) {
                    float jc0 = Math.min(n1.coords[i], n2.coords[i]);
                    float jc1 = Math.max(n1.coords[i] + n1.dimensions[i], n2.coords[i] + n2.dimensions[i]);
                    ja *= jc1 - jc0;
                }
                float waste = ja - n1a - n2a;
                if (!(waste > maxWaste)) continue;
                maxWaste = waste;
                bestPair[0] = n1;
                bestPair[1] = n2;
            }
        }
        nn.remove(bestPair[0]);
        nn.remove(bestPair[1]);
        return bestPair;
    }

    private Node qPickNext(LinkedList<Node> cc, Node[] nn) {
        float maxDiff = -3.4028235E38f;
        Node nextC = null;
        for (Node c : cc) {
            float n0Exp = this.getRequiredExpansion(nn[0].coords, nn[0].dimensions, c);
            float n1Exp = this.getRequiredExpansion(nn[1].coords, nn[1].dimensions, c);
            float diff = Math.abs(n1Exp - n0Exp);
            if (!(diff > maxDiff)) continue;
            maxDiff = diff;
            nextC = c;
        }
        assert (nextC != null) : "No node selected from qPickNext";
        cc.remove(nextC);
        return nextC;
    }

    private Node[] lPickSeeds(LinkedList<Node> nn) {
        Node[] bestPair = new Node[2];
        boolean foundBestPair = false;
        float bestSep = 0.0f;
        for (int i = 0; i < this.numDims; ++i) {
            float sep;
            float dimLb = Float.MAX_VALUE;
            float dimMinUb = Float.MAX_VALUE;
            float dimUb = -3.4028235E38f;
            float dimMaxLb = -3.4028235E38f;
            Node nMaxLb = null;
            Node nMinUb = null;
            for (Node n : nn) {
                if (n.coords[i] < dimLb) {
                    dimLb = n.coords[i];
                }
                if (n.dimensions[i] + n.coords[i] > dimUb) {
                    dimUb = n.dimensions[i] + n.coords[i];
                }
                if (n.coords[i] > dimMaxLb) {
                    dimMaxLb = n.coords[i];
                    nMaxLb = n;
                }
                if (!(n.dimensions[i] + n.coords[i] < dimMinUb)) continue;
                dimMinUb = n.dimensions[i] + n.coords[i];
                nMinUb = n;
            }
            float f = sep = nMaxLb == nMinUb ? -1.0f : Math.abs((dimMinUb - dimMaxLb) / (dimUb - dimLb));
            if (!(sep >= bestSep)) continue;
            bestPair[0] = nMaxLb;
            bestPair[1] = nMinUb;
            bestSep = sep;
            foundBestPair = true;
        }
        if (!foundBestPair) {
            bestPair = new Node[]{nn.get(0), nn.get(1)};
        }
        nn.remove(bestPair[0]);
        nn.remove(bestPair[1]);
        return bestPair;
    }

    private Node lPickNext(LinkedList<Node> cc) {
        return cc.pop();
    }

    @SafeVarargs
    private final void tighten(Node ... nodes) {
        assert (nodes.length >= 1) : "Pass some nodes to tighten!";
        for (Node n : nodes) {
            int i;
            assert (n.children.size() > 0) : "tighten() called on empty node!";
            float[] minCoords = new float[this.numDims];
            float[] maxCoords = new float[this.numDims];
            for (i = 0; i < this.numDims; ++i) {
                minCoords[i] = Float.MAX_VALUE;
                maxCoords[i] = -3.4028235E38f;
                for (Node c : n.children) {
                    c.parent = n;
                    if (c.coords[i] < minCoords[i]) {
                        minCoords[i] = c.coords[i];
                    }
                    if (!(c.coords[i] + c.dimensions[i] > maxCoords[i])) continue;
                    maxCoords[i] = c.coords[i] + c.dimensions[i];
                }
            }
            for (i = 0; i < this.numDims; ++i) {
                int n2 = i;
                maxCoords[n2] = maxCoords[n2] - minCoords[i];
            }
            System.arraycopy(minCoords, 0, n.coords, 0, this.numDims);
            System.arraycopy(maxCoords, 0, n.dimensions, 0, this.numDims);
        }
    }

    private Node chooseLeaf(Node n, Entry e) {
        if (n.leaf) {
            return n;
        }
        float minInc = Float.MAX_VALUE;
        Node next = null;
        for (Node c : n.children) {
            float inc = this.getRequiredExpansion(c.coords, c.dimensions, e);
            if (inc < minInc) {
                minInc = inc;
                next = c;
                continue;
            }
            if (inc != minInc) continue;
            float curArea = 1.0f;
            float thisArea = 1.0f;
            for (int i = 0; i < c.dimensions.length; ++i) {
                curArea *= next.dimensions[i];
                thisArea *= c.dimensions[i];
            }
            if (!(thisArea < curArea)) continue;
            next = c;
        }
        return this.chooseLeaf(next, e);
    }

    private float getRequiredExpansion(float[] coords, float[] dimensions, Node e) {
        float area = this.getArea(dimensions);
        float[] deltas = new float[dimensions.length];
        for (int i = 0; i < deltas.length; ++i) {
            if (coords[i] + dimensions[i] < e.coords[i] + e.dimensions[i]) {
                deltas[i] = e.coords[i] + e.dimensions[i] - coords[i] - dimensions[i];
                continue;
            }
            if (!(coords[i] + dimensions[i] > e.coords[i] + e.dimensions[i])) continue;
            deltas[i] = coords[i] - e.coords[i];
        }
        float expanded = 1.0f;
        for (int i = 0; i < dimensions.length; ++i) {
            expanded *= dimensions[i] + deltas[i];
        }
        return expanded - area;
    }

    private float getArea(float[] dimensions) {
        float area = 1.0f;
        for (int i = 0; i < dimensions.length; ++i) {
            area *= dimensions[i];
        }
        return area;
    }

    private boolean isOverlap(float[] scoords, float[] sdimensions, float[] coords, float[] dimensions) {
        float FUDGE_FACTOR = 1.001f;
        for (int i = 0; i < scoords.length; ++i) {
            boolean overlapInThisDimension = false;
            if (scoords[i] == coords[i]) {
                overlapInThisDimension = true;
            } else if (scoords[i] < coords[i]) {
                if (scoords[i] + 1.001f * sdimensions[i] >= coords[i]) {
                    overlapInThisDimension = true;
                }
            } else if (scoords[i] > coords[i] && coords[i] + 1.001f * dimensions[i] >= scoords[i]) {
                overlapInThisDimension = true;
            }
            if (overlapInThisDimension) continue;
            return false;
        }
        return true;
    }

    public static enum SeedPicker {
        LINEAR,
        QUADRATIC;

    }

    private static class Node {
        final float[] coords;
        final float[] dimensions;
        final LinkedList<Node> children;
        final boolean leaf;
        Node parent;

        private Node(float[] coords, float[] dimensions, boolean leaf) {
            this.coords = new float[coords.length];
            this.dimensions = new float[dimensions.length];
            System.arraycopy(coords, 0, this.coords, 0, coords.length);
            System.arraycopy(dimensions, 0, this.dimensions, 0, dimensions.length);
            this.leaf = leaf;
            this.children = new LinkedList();
        }
    }

    private static class Entry
    extends Node {
        final T entry;
        final /* synthetic */ RTree this$0;

        public Entry(float[] coords, float[] dimensions, T entry) {
            this.this$0 = var1_1;
            super(coords, dimensions, true);
            this.entry = entry;
        }

        public String toString() {
            return "Entry: " + this.entry;
        }
    }

    public static interface NodeVisitor<V> {
        public void visit(int var1, float[] var2, float[] var3, V var4);
    }
}

