/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.gui.container;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import muramasa.antimatter.capability.IGuiHandler;
import muramasa.antimatter.capability.machine.MachineItemHandler;
import muramasa.antimatter.gui.MenuHandlerMachine;
import muramasa.antimatter.gui.SlotData;
import muramasa.antimatter.gui.SlotType;
import muramasa.antimatter.gui.container.AntimatterContainer;
import muramasa.antimatter.gui.slot.AbstractSlot;
import muramasa.antimatter.tile.TileEntityMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public abstract class ContainerMachine<T extends TileEntityMachine<T>>
extends AntimatterContainer {
    protected final T tile;
    public final Map<SlotType<?>, List<Slot>> slotMap = new Object2ObjectOpenHashMap();

    public ContainerMachine(T tile, Inventory playerInv, MenuHandlerMachine<T, ContainerMachine<T>> menuHandler, int windowId) {
        super((IGuiHandler)tile, menuHandler.getContainerType(), windowId, playerInv, ((TileEntityMachine)tile).getMachineType().getSlots(((TileEntityMachine)tile).getMachineTier()).size());
        this.tile = tile;
        this.addSlots((TileEntityMachine<?>)tile);
        if (((TileEntityMachine)tile).getMachineType().getGui().enablePlayerSlots()) {
            this.addPlayerSlots();
        }
        ((TileEntityMachine)tile).addOpenContainer(this);
    }

    public T getTile() {
        return this.tile;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        ((TileEntityMachine)this.tile).onContainerClose(this);
    }

    @Override
    public void m_38946_() {
        super.m_38946_();
    }

    protected void addSlots(TileEntityMachine<?> tile) {
        Object2IntOpenHashMap slotIndexMap = new Object2IntOpenHashMap();
        for (SlotData<?> slot : tile.getMachineType().getSlots(tile.getMachineTier())) {
            slotIndexMap.computeIntIfAbsent((Object)slot.getType().getId(), k -> 0);
            Object supplier = slot.getType().getSlotSupplier().get(slot.getType(), tile, tile.itemHandler.map(MachineItemHandler::getAll).orElse(null), slotIndexMap.getInt((Object)slot.getType().getId()), slot);
            this.m_38897_((Slot)supplier);
            slotIndexMap.computeInt((Object)slot.getType().getId(), (a, b) -> {
                if (b == null) {
                    return 0;
                }
                return b + 1;
            });
        }
    }

    protected Slot m_38897_(Slot slot) {
        if (slot instanceof AbstractSlot) {
            AbstractSlot abstractSlot = (AbstractSlot)slot;
            this.slotMap.computeIfAbsent(abstractSlot.type, t -> new ArrayList()).add(abstractSlot);
        }
        return super.m_38897_(slot);
    }

    public boolean m_6875_(Player player) {
        return ContainerMachine.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.tile.m_58904_(), (BlockPos)this.tile.m_58899_()), (Player)player, (Block)this.tile.m_58900_().m_60734_());
    }
}

