/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.gui;

import earth.terrarium.botarium.common.energy.util.EnergyHooks;
import java.util.Map;
import java.util.function.BiPredicate;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.capability.FluidHandler;
import muramasa.antimatter.capability.IGuiHandler;
import muramasa.antimatter.gui.SlotData;
import muramasa.antimatter.gui.slot.AbstractSlot;
import muramasa.antimatter.gui.slot.SlotCell;
import muramasa.antimatter.gui.slot.SlotEnergy;
import muramasa.antimatter.gui.slot.SlotFake;
import muramasa.antimatter.gui.slot.SlotFakeFluid;
import muramasa.antimatter.gui.slot.SlotInput;
import muramasa.antimatter.gui.slot.SlotOutput;
import muramasa.antimatter.machine.event.ContentEvent;
import muramasa.antimatter.registration.IAntimatterObject;
import muramasa.antimatter.tile.TileEntityMachine;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import tesseract.TesseractCapUtils;

public class SlotType<T extends Slot>
implements IAntimatterObject {
    public static SlotType<SlotInput> IT_IN = new SlotType<SlotInput>("item_in", (type, gui, inv, i, d) -> new SlotInput(type, gui, (IItemHandler)inv.getOrDefault(type, new EmptyHandler()), i, d.getX(), d.getY()), new ItIn(), ContentEvent.ITEM_INPUT_CHANGED, true, false);
    public static SlotType<SlotOutput> IT_OUT = new SlotType<SlotOutput>("item_out", (type, gui, inv, i, d) -> new SlotOutput(type, gui, (IItemHandler)inv.getOrDefault(type, new EmptyHandler()), i, d.getX(), d.getY()), (t, i) -> false, ContentEvent.ITEM_OUTPUT_CHANGED, false, true);
    public static SlotType<SlotFake> DISPLAY = new SlotType<SlotFake>("display", (type, gui, item, i, d) -> new SlotFake(type, gui, (IItemHandler)item.getOrDefault(type, new EmptyHandler()), i, d.getX(), d.getY(), false), (t, i) -> false, ContentEvent.ITEM_INPUT_CHANGED, false, false);
    public static SlotType<SlotFake> DISPLAY_SETTABLE = new SlotType<SlotFake>("display_settable", (type, gui, item, i, d) -> new SlotFake(type, gui, (IItemHandler)item.getOrDefault(type, new EmptyHandler()), i, d.getX(), d.getY(), true), (t, i) -> false, ContentEvent.ITEM_INPUT_CHANGED, true, false);
    public static SlotType<AbstractSlot<?>> STORAGE = new SlotType<AbstractSlot>("storage", (type, gui, item, i, d) -> new AbstractSlot(type, gui, (IItemHandler)item.getOrDefault(type, new EmptyHandler()), i, d.getX(), d.getY()), (t, i) -> true, ContentEvent.ITEM_INPUT_CHANGED);
    public static SlotType<SlotFakeFluid> FL_IN = new SlotType<SlotFakeFluid>("fluid_in", (type, gui, inv, i, d) -> new SlotFakeFluid(type, gui, FluidHandler.FluidDirection.INPUT, i, d.getX(), d.getY()), (t, i) -> false, ContentEvent.FLUID_INPUT_CHANGED, false, false);
    public static SlotType<SlotFakeFluid> FL_OUT = new SlotType<SlotFakeFluid>("fluid_out", (type, gui, inv, i, d) -> new SlotFakeFluid(type, gui, FluidHandler.FluidDirection.OUTPUT, i, d.getX(), d.getY()), (t, i) -> false, ContentEvent.FLUID_OUTPUT_CHANGED, false, false);
    public static SlotType<SlotCell> CELL_IN = new SlotType<SlotCell>("cell_in", (type, gui, inv, i, d) -> new SlotCell(type, gui, (IItemHandler)inv.getOrDefault(type, new EmptyHandler()), i, d.getX(), d.getY()), (t, i) -> TesseractCapUtils.getFluidHandlerItem((ItemStack)i).isPresent(), ContentEvent.ITEM_CELL_CHANGED, true, false);
    public static SlotType<SlotCell> CELL_OUT = new SlotType<SlotCell>("cell_out", (type, gui, inv, i, d) -> new SlotCell(type, gui, (IItemHandler)inv.getOrDefault(type, new EmptyHandler()), i, d.getX(), d.getY()), (t, i) -> TesseractCapUtils.getFluidHandlerItem((ItemStack)i).isPresent(), ContentEvent.ITEM_CELL_CHANGED, false, true);
    public static SlotType<SlotEnergy> ENERGY = new SlotType<SlotEnergy>("energy", (type, gui, inv, i, d) -> new SlotEnergy(type, gui, (IItemHandler)inv.getOrDefault(type, new EmptyHandler()), i, d.getX(), d.getY()), (t, i) -> {
        if (t instanceof BlockEntity) {
            BlockEntity tile = (BlockEntity)t;
            return TesseractCapUtils.getEnergyHandler((BlockEntity)tile, null).map(eh -> TesseractCapUtils.getEnergyHandlerItem((ItemStack)i).map(inner -> (inner.getInputVoltage() | inner.getOutputVoltage()) == (eh.getInputVoltage() | eh.getOutputVoltage())).orElse(EnergyHooks.isEnergyItem((ItemStack)i))).orElse(EnergyHooks.isEnergyContainer((BlockEntity)tile, null) && EnergyHooks.isEnergyItem((ItemStack)i));
        }
        return true;
    }, ContentEvent.ENERGY_SLOT_CHANGED, true, false);
    protected final String id;
    protected final ISlotSupplier<T> slotSupplier;
    public final boolean output;
    public final boolean input;
    public final BiPredicate<IGuiHandler, ItemStack> tester;
    public final ContentEvent ev;

    public SlotType(String id, ISlotSupplier<T> slotSupplier, BiPredicate<IGuiHandler, ItemStack> validator, ContentEvent ev) {
        this(id, slotSupplier, validator, ev, true, true);
    }

    public SlotType(String id, ISlotSupplier<T> slotSupplier, BiPredicate<IGuiHandler, ItemStack> validator, ContentEvent ev, boolean input, boolean output) {
        this.id = id;
        this.slotSupplier = slotSupplier;
        this.output = output;
        this.tester = validator;
        this.input = input;
        this.ev = ev;
        AntimatterAPI.register(SlotType.class, this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ISlotSupplier<T> getSlotSupplier() {
        return this.slotSupplier;
    }

    public static void init() {
    }

    public static interface ISlotSupplier<T extends Slot> {
        public T get(SlotType<T> var1, IGuiHandler var2, Map<SlotType<?>, IItemHandler> var3, int var4, SlotData<T> var5);
    }

    public static class ItIn
    implements BiPredicate<IGuiHandler, ItemStack> {
        @Override
        public boolean test(IGuiHandler iGuiHandler, ItemStack stack) {
            if (iGuiHandler instanceof TileEntityMachine) {
                return ((TileEntityMachine)iGuiHandler).recipeHandler.map(rh -> rh.accepts(stack)).orElse(true);
            }
            return true;
        }
    }
}

