/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.gui;

import dev.architectury.injectables.annotations.ExpectPlatform;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.capability.IGuiHandler;
import muramasa.antimatter.gui.container.IAntimatterContainer;
import muramasa.antimatter.gui.forge.MenuHandlerImpl;
import muramasa.antimatter.registration.IAntimatterObject;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import org.apache.commons.lang3.function.TriFunction;

public abstract class MenuHandler<T extends AbstractContainerMenu>
implements IAntimatterObject {
    protected ResourceLocation loc;
    private MenuType<T> containerType;

    public MenuHandler(String domain, String id) {
        this.loc = new ResourceLocation(domain, id);
        AntimatterAPI.register(MenuHandler.class, this);
        MenuType<T> type = this.getContainerType();
        AntimatterAPI.register(MenuType.class, id, domain, type);
    }

    @Override
    public String getDomain() {
        return this.loc.m_135827_();
    }

    @Override
    public String getId() {
        return this.loc.m_135815_();
    }

    protected abstract T getMenu(IGuiHandler var1, Inventory var2, int var3);

    @MethodsReturnNonnullByDefault
    public final T menu(IGuiHandler source, Inventory playerInv, int windowId) {
        T t = this.getMenu(source, playerInv, windowId);
        if (!source.isRemote()) {
            ((IAntimatterContainer)t).source().init();
        }
        return t;
    }

    @MethodsReturnNonnullByDefault
    public MenuType<T> getContainerType() {
        if (this.containerType == null) {
            this.containerType = MenuHandler.create(this::onContainerCreate);
        }
        return this.containerType;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    static <T extends AbstractContainerMenu> MenuType<T> create(TriFunction<Integer, Inventory, FriendlyByteBuf, T> factory) {
        return MenuHandlerImpl.create(factory);
    }

    public abstract T onContainerCreate(int var1, Inventory var2, FriendlyByteBuf var3);

    public String screenID() {
        return "default";
    }

    public String screenDomain() {
        return "antimatter";
    }
}

