/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.gui;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import muramasa.antimatter.capability.IGuiHandler;
import muramasa.antimatter.gui.ButtonBody;
import muramasa.antimatter.gui.ICanSyncData;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.Widget;
import muramasa.antimatter.gui.container.IAntimatterContainer;
import muramasa.antimatter.gui.core.RTree;
import muramasa.antimatter.gui.event.GuiEvents;
import muramasa.antimatter.gui.screen.AntimatterContainerScreen;
import muramasa.antimatter.gui.widget.ButtonWidget;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.network.AntimatterNetwork;
import muramasa.antimatter.network.packets.AbstractGuiEventPacket;
import muramasa.antimatter.network.packets.ClientboundGuiSyncPacket;
import muramasa.antimatter.network.packets.GuiSyncPacket;
import muramasa.antimatter.network.packets.ServerboundGuiSyncPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuiInstance
implements ICanSyncData {
    private int buttonCounter = 0;
    public final IGuiHandler handler;
    public final AbstractContainerMenu container;
    public final boolean isRemote;
    private final List<SyncHolder> syncData = new ObjectArrayList();
    private int indexCounter = 0;
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public AntimatterContainerScreen<?> screen;
    private final List<WidgetSupplier> builders = new ObjectArrayList();
    private final RTree<Widget> widgetLookup = new RTree();
    private final Set<Widget> widgets = new ObjectOpenHashSet();
    private IGuiElement focus;

    public GuiInstance(IGuiHandler handler, AbstractContainerMenu container, boolean isRemote) {
        this.handler = handler;
        this.isRemote = isRemote;
        this.container = container;
    }

    public void rescale(IGuiElement root) {
        for (Widget w : this.unsortedWidgets()) {
            if (w.parent != root) continue;
            w.updateSize();
        }
    }

    public Iterable<Widget> getWidgets(double mouseX, double mouseY) {
        return () -> {
            Stream stream = this.widgetLookup.search(new float[]{(float)mouseX, (float)mouseY}, new float[]{0.0f, 0.0f}).stream();
            return stream.sorted((a, b) -> Integer.compare(b.depth(), a.depth())).iterator();
        };
    }

    public Optional<Widget> getTopLevelWidget(double mouseX, double mouseY) {
        Iterator<Widget> iterator = this.getWidgets(mouseX, mouseY).iterator();
        return iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Iterable<Widget> widgetsToRender() {
        return () -> this.widgets.stream().filter(t -> t.parent == this.screen).sorted(Comparator.comparing(Widget::depth)).iterator();
    }

    public boolean isOnTop(Widget wid, double mouseX, double mouseY) {
        return this.getWidgets(mouseX, mouseY).iterator().next() == wid;
    }

    public void rescaleWidget(Widget wid, int oldX, int oldY, int oldW, int oldH) {
        if (!wid.isEnabled()) {
            return;
        }
        if (!this.widgets.contains(wid)) {
            return;
        }
        float x = oldX;
        float y = oldY;
        float w = oldW;
        float h = oldH;
        if (this.widgetLookup.delete(new float[]{x, y}, new float[]{w, h}, wid)) {
            this.widgetLookup.insert(wid);
        }
    }

    public void updateWidgetStatus(Widget wid) {
        if (wid.isEnabled()) {
            this.widgetLookup.insert(wid);
        } else {
            this.widgetLookup.delete(wid);
        }
    }

    private void initWidgets(IGuiElement parent) {
        this.handler.addWidgets(this, parent);
        for (WidgetSupplier builder : this.builders) {
            if (!builder.shouldAdd(this)) continue;
            builder.buildAndAdd(this, parent);
        }
    }

    private void putWidget(Widget w) {
        this.widgets.add(w);
        this.updateWidgetStatus(w);
        w.init();
    }

    public void init() {
        this.initWidgets(null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient(AntimatterContainerScreen<?> parent) {
        this.screen = parent;
        this.initWidgets(parent);
        for (Widget mut : this.unsortedWidgets()) {
            if (mut.parent != null) continue;
            mut.setParent(parent);
        }
    }

    public GuiInstance addWidget(Widget widget) {
        this.putWidget(widget);
        return this;
    }

    public GuiInstance addWidget(WidgetSupplier provider) {
        this.builders.add(provider);
        return this;
    }

    public GuiInstance addButton(int x, int y, int w, int h, ButtonBody body) {
        this.addWidget(ButtonWidget.build("textures/gui/button/gui_buttons.png", body, null, GuiEvents.EXTRA_BUTTON, this.buttonCounter++).setSize(x, y, w, h));
        return this;
    }

    public GuiInstance addButton(int x, int y, int w, int h, ButtonBody body, String tooltipKey) {
        this.addWidget(ButtonWidget.build("textures/gui/button/gui_buttons.png", body, null, GuiEvents.EXTRA_BUTTON, this.buttonCounter++, tooltipKey).setSize(x, y, w, h));
        return this;
    }

    public Iterable<Widget> unsortedWidgets() {
        return this.widgets;
    }

    public void update(double mouseX, double mouseY) {
        this.getTopLevelWidget(mouseX, mouseY).ifPresent(t -> {
            this.focus = t;
        });
        this.unsortedWidgets().forEach(t -> t.update(mouseX, mouseY));
        ObjectArrayList toSync = new ObjectArrayList();
        for (SyncHolder sync : this.syncData) {
            Object value;
            if (sync.direction == ICanSyncData.SyncDirection.SERVER_TO_CLIENT || sync.equality.apply(value = sync.source.get(), sync.current).booleanValue()) continue;
            sync.current = value;
            toSync.add(sync);
        }
        if (toSync.size() > 0) {
            this.writeToServer((List<SyncHolder>)toSync);
        }
    }

    public void sendPacket(AbstractGuiEventPacket pkt) {
        AntimatterNetwork.NETWORK.sendToServer((Packet)pkt);
    }

    public void update() {
        ObjectArrayList toSync = new ObjectArrayList();
        for (SyncHolder sync : this.syncData) {
            Object value = sync.source.get();
            if (sync.equality.apply(value, sync.current).booleanValue()) continue;
            sync.current = value;
            toSync.add(sync);
        }
        if (toSync.size() > 0) {
            this.writeToClient((List<SyncHolder>)toSync);
        }
    }

    public ItemStack getHeldItem() {
        return this.container.m_142621_();
    }

    @Nullable
    public IGuiElement getFocus() {
        return this.focus;
    }

    public void receivePacket(GuiSyncPacket packet, ICanSyncData.SyncDirection dir) {
        ByteBuf data = packet.clientData;
        FriendlyByteBuf buf = new FriendlyByteBuf(data);
        int size = buf.m_130242_();
        for (int i = 0; i < size; ++i) {
            int offset = buf.m_130242_();
            Object o = this.syncData.get((int)offset).reader.apply(buf);
            SyncHolder holder = this.syncData.get(offset);
            holder.current = o;
            holder.sink.accept(o);
        }
    }

    private void writeToClient(List<SyncHolder> data) {
        ClientboundGuiSyncPacket pkt = new ClientboundGuiSyncPacket(data);
        for (ServerPlayer listener : ((IAntimatterContainer)this.container).listeners()) {
            AntimatterNetwork.NETWORK.sendToPlayer((Packet)pkt, (Player)listener);
        }
    }

    private void writeToServer(List<SyncHolder> data) {
        ServerboundGuiSyncPacket pkt = new ServerboundGuiSyncPacket(data);
        AntimatterNetwork.NETWORK.sendToServer((Packet)pkt);
    }

    @Override
    public <T> void bind(Supplier<T> supplier, Consumer<T> consumer, Function<FriendlyByteBuf, T> reader, BiConsumer<FriendlyByteBuf, T> writer, BiFunction<Object, Object, Boolean> equality, ICanSyncData.SyncDirection direction) {
        this.syncData.add(new SyncHolder(supplier, consumer, reader, writer, this.indexCounter++, equality, direction));
    }

    public static class SyncHolder {
        public final Supplier source;
        public final Consumer sink;
        public Object current;
        public final Function<FriendlyByteBuf, Object> reader;
        public final BiConsumer<FriendlyByteBuf, Object> writer;
        public final int index;
        public BiFunction<Object, Object, Boolean> equality;
        public final ICanSyncData.SyncDirection direction;

        public SyncHolder(Supplier<?> source, Consumer<?> sink, Function<FriendlyByteBuf, ?> reader, BiConsumer<FriendlyByteBuf, ?> writer, int index, BiFunction<Object, Object, Boolean> equality, ICanSyncData.SyncDirection direction) {
            this.source = source;
            this.index = index;
            this.sink = sink;
            this.reader = reader;
            this.writer = writer;
            this.equality = equality;
            this.direction = direction;
        }
    }
}

