/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.gui;

import com.google.common.collect.ImmutableMap;
import muramasa.antimatter.gui.BarDir;
import muramasa.antimatter.gui.MenuHandler;
import muramasa.antimatter.gui.slot.ISlotProvider;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.registration.IAntimatterObject;
import muramasa.antimatter.util.int4;
import net.minecraft.resources.ResourceLocation;

public class GuiData {
    protected ResourceLocation loc;
    protected ResourceLocation override = null;
    protected MenuHandler<?> menuHandler;
    protected ImmutableMap<Tier, Tier> guiTiers;
    protected boolean enablePlayerSlots = true;
    protected int4 area = new int4(3, 3, 170, 80);
    public BarDir dir = BarDir.LEFT;
    public boolean barFill = true;
    private final int buttons = 0;
    private ISlotProvider<?> slots;

    public GuiData(String domain, String id) {
        this.loc = new ResourceLocation(domain, id);
    }

    public GuiData(String domain, String id, MenuHandler menuHandler) {
        this(domain, id);
        this.menuHandler = menuHandler;
    }

    public GuiData(IAntimatterObject type, MenuHandler menuHandler) {
        this(type.getDomain(), type.getId());
        this.menuHandler = menuHandler;
    }

    public GuiData setSlots(ISlotProvider<?> slots) {
        this.slots = slots;
        return this;
    }

    public GuiData setTieredGui(ImmutableMap.Builder<Tier, Tier> guiTiers) {
        this.guiTiers = guiTiers.build();
        return this;
    }

    public ISlotProvider<?> getSlots() {
        if (this.slots == null) {
            throw new IllegalStateException("Called GuiData::getSlots without setting it first");
        }
        return this.slots;
    }

    public MenuHandler<?> getMenuHandler() {
        return this.menuHandler;
    }

    public ResourceLocation getTexture(Tier tier, String type) {
        if (this.override != null) {
            return this.override;
        }
        if (this.guiTiers != null && this.guiTiers.get((Object)tier) != null) {
            return new ResourceLocation(this.loc.m_135827_(), "textures/gui/" + type + "/" + this.loc.m_135815_() + "_" + ((Tier)this.guiTiers.get((Object)tier)).getId() + ".png");
        }
        return new ResourceLocation(this.loc.m_135827_(), "textures/gui/" + type + "/" + this.loc.m_135815_() + ".png");
    }

    public ResourceLocation getLoc() {
        return this.loc;
    }

    public int4 getArea() {
        return this.area;
    }

    public boolean enablePlayerSlots() {
        return this.enablePlayerSlots;
    }

    public void setEnablePlayerSlots(boolean enablePlayerSlots) {
        this.enablePlayerSlots = enablePlayerSlots;
    }

    public GuiData setArea(int x, int y, int z, int w) {
        this.area.set(x, y, z, w);
        return this;
    }

    public GuiData setOverrideLocation(ResourceLocation override) {
        this.override = override;
        return this;
    }

    public void setDir(BarDir dir) {
        this.dir = dir;
    }

    public void setBarFill(boolean barFill) {
        this.barFill = barFill;
    }
}

