/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.fluid;

import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.fluid.AntimatterFluid;
import muramasa.antimatter.fluid.AntimatterFluidAttributes;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.util.Utils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class AntimatterMaterialFluid
extends AntimatterFluid {
    protected Material material;
    protected MaterialType<?> type;

    public AntimatterMaterialFluid(String domain, Material material, MaterialType<?> type, AntimatterFluidAttributes.Builder builder, BlockBehaviour.Properties blockProperties) {
        super(domain, type.getId() + "_" + material.getId(), builder, blockProperties);
        this.material = material;
        this.type = type;
    }

    public AntimatterMaterialFluid(String domain, Material material, MaterialType<?> type, ResourceLocation stillLoc, ResourceLocation flowLoc) {
        super(domain, type.getId() + "_" + material.getId(), stillLoc, flowLoc);
        this.material = material;
        this.type = type;
    }

    public AntimatterMaterialFluid(String domain, Material material, MaterialType<?> type) {
        this(domain, material, type, AntimatterMaterialFluid.prepareAttributes(domain, material, type), AntimatterMaterialFluid.prepareProperties(type));
    }

    public Material getMaterial() {
        return this.material;
    }

    public MaterialType<?> getType() {
        return this.type;
    }

    private static AntimatterFluidAttributes.Builder prepareAttributes(String domain, Material material, MaterialType<?> type) {
        if (type == AntimatterMaterialTypes.GAS) {
            return AntimatterFluidAttributes.builder(GAS_TEXTURE, GAS_FLOW_TEXTURE).overlay(OVERLAY_TEXTURE).color(0x46000000 | material.getRGB() & 0xFFFFFF).translationKey(String.join((CharSequence)"", "block.", domain, type.getId(), ".", material.getId())).viscosity(200).density(-1000).gaseous().temperature(MaterialTags.GAS_TEMPERATURE.getInt(material)).sound(SoundEvents.f_11781_, SoundEvents.f_11778_);
        }
        if (type == AntimatterMaterialTypes.PLASMA) {
            return AntimatterFluidAttributes.builder(PLASMA_TEXTURE, PLASMA_FLOW_TEXTURE).overlay(OVERLAY_TEXTURE).color(0x32000000 | material.getRGB() & 0xFFFFFF).translationKey(String.join((CharSequence)"", "block.", domain, type.getId(), ".", material.getId())).viscosity(10).density(-55536).luminosity(15).gaseous().temperature(10000).sound(SoundEvents.f_11781_, SoundEvents.f_11778_);
        }
        return AntimatterMaterialFluid.getDefaultAttributesBuilder(material.has(MaterialTags.MOLTEN)).color(0x9B000000 | material.getRGB() & 0xFFFFFF).translationKey(String.join((CharSequence)"", "block.", domain, type.getId(), ".", material.getId())).viscosity(1000).density(1000).temperature(MaterialTags.LIQUID_TEMPERATURE.getInt(material));
    }

    private static BlockBehaviour.Properties prepareProperties(MaterialType<?> type) {
        return AntimatterMaterialFluid.getDefaultBlockProperties().m_60953_(s -> type == AntimatterMaterialTypes.PLASMA ? 15 : 0);
    }

    @Override
    public String getLang(String lang) {
        if (lang.equals("en_us")) {
            String display;
            String string = display = this.material.getDisplayNameString() != null && !this.material.getDisplayNameString().isEmpty() ? this.material.getDisplayNameString() : Utils.lowerUnderscoreToUpperSpaced(this.material.getId());
            if (this.isGasType()) {
                String gas = this.getType() == AntimatterMaterialTypes.PLASMA ? " Plasma" : "";
                return display + gas;
            }
            String liquid = this.material.has(MaterialTags.MOLTEN) ? "Molten " : "";
            return liquid + display;
        }
        return super.getLang(lang);
    }

    private boolean isGasType() {
        return this.type == AntimatterMaterialTypes.PLASMA || this.type == AntimatterMaterialTypes.GAS || this.getAttributes().isGaseous();
    }
}

