/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.fluid;

import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.fluid.AntimatterFluidAttributes;
import muramasa.antimatter.fluid.AntimatterFluidUtils;
import muramasa.antimatter.fluid.AntimatterLiquidBlock;
import muramasa.antimatter.fluid.AntimatterMaterialFluid;
import muramasa.antimatter.registration.IRegistryEntryProvider;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.registration.RegistryType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;

public class AntimatterFluid
implements ISharedAntimatterObject,
IRegistryEntryProvider {
    public static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation("block/water_overlay");
    public static final ResourceLocation LIQUID_STILL_TEXTURE = new ResourceLocation("antimatter", "block/liquid/still");
    public static final ResourceLocation LIQUID_FLOW_TEXTURE = new ResourceLocation("antimatter", "block/liquid/flow");
    public static final ResourceLocation LIQUID_HOT_STILL_TEXTURE = new ResourceLocation("antimatter", "block/liquid/hot_still");
    public static final ResourceLocation LIQUID_HOT_FLOW_TEXTURE = new ResourceLocation("antimatter", "block/liquid/hot_flow");
    public static final ResourceLocation GAS_TEXTURE = new ResourceLocation("antimatter", "block/liquid/gas");
    public static final ResourceLocation GAS_FLOW_TEXTURE = new ResourceLocation("antimatter", "block/liquid/gas");
    public static final ResourceLocation PLASMA_TEXTURE = new ResourceLocation("antimatter", "block/liquid/plasma");
    public static final ResourceLocation PLASMA_FLOW_TEXTURE = new ResourceLocation("antimatter", "block/liquid/plasma");
    private final String domain;
    private final String id;
    protected FlowingFluid source;
    protected FlowingFluid flowing;
    protected BlockBehaviour.Properties blockProperties;
    protected AntimatterFluidAttributes attributes;
    protected LiquidBlock fluidBlock;
    protected Item containerItem = Items.f_41852_;

    public AntimatterFluid(String domain, String id, AntimatterFluidAttributes.Builder builder, BlockBehaviour.Properties blockProperties) {
        this.domain = domain;
        this.id = id;
        this.blockProperties = blockProperties;
        this.attributes = builder.translationKey("block." + domain + ".liquid." + id).build(this);
    }

    public AntimatterFluid(String domain, String id) {
        this(domain, id, AntimatterFluid.getDefaultAttributesBuilder(), AntimatterFluid.getDefaultBlockProperties());
    }

    public AntimatterFluid(String domain, String id, AntimatterFluidAttributes.Builder builder) {
        this(domain, id, builder, AntimatterFluid.getDefaultBlockProperties());
    }

    public AntimatterFluid(String domain, String id, ResourceLocation stillLoc, ResourceLocation flowLoc) {
        this(domain, id, AntimatterFluidAttributes.builder(stillLoc, flowLoc), AntimatterFluid.getDefaultBlockProperties());
    }

    public AntimatterFluid(String domain, String id, BlockBehaviour.Properties properties) {
        this(domain, id, AntimatterFluid.getDefaultAttributesBuilder(), properties);
    }

    @Override
    public void onRegistryBuild(RegistryType registry) {
        if (registry == RegistryType.ITEMS) {
            this.containerItem = new BucketItem((Fluid)this.getFluid(), new Item.Properties().m_41487_(1).m_41495_(Items.f_42446_).m_41491_(CreativeModeTab.f_40753_));
            AntimatterAPI.register(Item.class, this.getId() + "_bucket", this.getDomain(), this.containerItem);
        } else if (registry == RegistryType.BLOCKS) {
            int n;
            AntimatterFluidUtils.createSourceAndFlowingFluid(this, s -> {
                this.source = s;
            }, f -> {
                this.flowing = f;
            });
            AntimatterFluid antimatterFluid = this;
            if (antimatterFluid instanceof AntimatterMaterialFluid) {
                AntimatterMaterialFluid m = (AntimatterMaterialFluid)antimatterFluid;
                n = m.getMaterial().getRGB();
            } else {
                n = -1;
            }
            int color = n;
            this.fluidBlock = new AntimatterLiquidBlock(this.getFluid(), this.blockProperties, color);
            AntimatterAPI.register(Block.class, "block_fluid_".concat(this.getId()), this.getDomain(), this.fluidBlock);
        } else if (registry == RegistryType.FLUIDS) {
            AntimatterAPI.register(Fluid.class, this.getId(), this.getDomain(), this.source);
            AntimatterAPI.register(FlowingFluid.class, "flowing_".concat(this.getId()), this.getDomain(), this.flowing);
        }
    }

    public AntimatterFluid source(FlowingFluid source) {
        this.source = source;
        return this;
    }

    public AntimatterFluid flowing(FlowingFluid flowing) {
        this.flowing = flowing;
        return this;
    }

    public AntimatterFluid flowingBlock(LiquidBlock fluidBlock) {
        this.fluidBlock = fluidBlock;
        return this;
    }

    public AntimatterFluid containerItem(Item item) {
        this.containerItem = item;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public BlockBehaviour.Properties getBlockProperties() {
        return this.blockProperties;
    }

    public AntimatterFluidAttributes getAttributes() {
        return this.attributes;
    }

    public FlowingFluid getFluid() {
        return this.source;
    }

    public FlowingFluid getFlowingFluid() {
        return this.flowing;
    }

    public LiquidBlock getFluidBlock() {
        return this.fluidBlock;
    }

    public Item getContainerItem() {
        return this.containerItem;
    }

    protected static BlockBehaviour.Properties getDefaultBlockProperties() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60978_(100.0f).m_60993_();
    }

    protected static AntimatterFluidAttributes.Builder getDefaultAttributesBuilder() {
        return AntimatterFluid.getDefaultAttributesBuilder(false);
    }

    protected static AntimatterFluidAttributes.Builder getDefaultAttributesBuilder(boolean hot) {
        if (hot) {
            return AntimatterFluidAttributes.builder(LIQUID_HOT_STILL_TEXTURE, LIQUID_HOT_FLOW_TEXTURE).overlay(OVERLAY_TEXTURE).sound(SoundEvents.f_11783_, SoundEvents.f_11780_);
        }
        return AntimatterFluidAttributes.builder(LIQUID_STILL_TEXTURE, LIQUID_FLOW_TEXTURE).overlay(OVERLAY_TEXTURE).sound(SoundEvents.f_11781_, SoundEvents.f_11778_);
    }
}

