/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.dynamic;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import muramasa.antimatter.client.AntimatterModelManager;
import muramasa.antimatter.client.IAntimatterModel;
import muramasa.antimatter.client.model.IModelConfiguration;
import muramasa.antimatter.dynamic.DynamicBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class DynamicModel
implements IAntimatterModel {
    protected Int2ObjectOpenHashMap<IAntimatterModel[]> modelConfigs;
    protected String staticMapId;
    protected ResourceLocation particle;

    public DynamicModel(ResourceLocation particle, Int2ObjectOpenHashMap<IAntimatterModel[]> modelConfigs, String staticMapId) {
        this.modelConfigs = modelConfigs;
        this.staticMapId = staticMapId;
        this.particle = particle;
    }

    public DynamicModel(DynamicModel copy) {
        this.modelConfigs = copy.modelConfigs;
        this.staticMapId = copy.staticMapId;
        this.particle = copy.particle;
    }

    @Override
    public BakedModel bakeModel(ModelBakery bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ResourceLocation loc) {
        return null;
    }

    @Override
    public BakedModel bakeModel(IModelConfiguration configuration, ModelBakery bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ItemOverrides overrides, ResourceLocation loc) {
        return new DynamicBakedModel(getter.apply(new Material(InventoryMenu.f_39692_, this.particle)), this.getBakedConfigs(configuration, bakery, getter, transform, overrides, loc));
    }

    public Int2ObjectOpenHashMap<BakedModel[]> getBakedConfigs(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ItemOverrides overrides, ResourceLocation loc) {
        Int2ObjectOpenHashMap<BakedModel[]> bakedConfigs = AntimatterModelManager.getStaticConfigMap(this.staticMapId);
        this.modelConfigs.forEach((k, v) -> {
            BakedModel[] baked = new BakedModel[((IAntimatterModel[])v).length];
            for (int i = 0; i < baked.length; ++i) {
                baked[i] = v[i].bake(owner, bakery, getter, transform, overrides, loc);
            }
            bakedConfigs.put(k.intValue(), (Object)baked);
        });
        return bakedConfigs;
    }

    @Override
    public Collection<Material> getMaterials(IModelConfiguration configuration, Function<ResourceLocation, UnbakedModel> getter, Set<Pair<String, String>> errors) {
        ObjectOpenHashSet textures = new ObjectOpenHashSet();
        this.modelConfigs.values().forEach(arg_0 -> DynamicModel.lambda$getMaterials$2((Set)textures, configuration, getter, errors, arg_0));
        return textures;
    }

    private static /* synthetic */ void lambda$getMaterials$2(Set textures, IModelConfiguration configuration, Function getter, Set errors, IAntimatterModel[] v) {
        Arrays.stream(v).forEach(m -> textures.addAll(m.getMaterials(configuration, getter, errors)));
    }
}

