/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.dynamic;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import muramasa.antimatter.Ref;
import muramasa.antimatter.block.BlockBasic;
import muramasa.antimatter.block.IInfoProvider;
import muramasa.antimatter.dynamic.ModelConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockDynamic
extends BlockBasic
implements IInfoProvider {
    public static final int[] DEFAULT_CONFIG = new int[]{0};
    protected ModelConfig config = new ModelConfig();
    protected Int2ObjectLinkedOpenHashMap<VoxelShape> shapes = new Int2ObjectLinkedOpenHashMap();
    protected Random r = new Random();

    public BlockDynamic(String domain, String id, BlockBehaviour.Properties properties) {
        super(domain, id, properties);
    }

    public BlockDynamic(String domain, String id) {
        super(domain, id);
    }

    public ModelConfig getConfig(BlockState state, BlockGetter world, BlockPos.MutableBlockPos mut, BlockPos pos) {
        int[] ct = new int[1];
        for (Direction side : Ref.DIRS) {
            mut.m_122190_((Vec3i)pos.m_142300_(side));
            BlockState adjState = world.m_8055_((BlockPos)mut);
            BlockEntity adjTile = world.m_7702_((BlockPos)mut);
            if (!this.canConnect(world, adjState, adjTile, (BlockPos)mut)) continue;
            ct[0] = ct[0] + (1 << side.m_122411_());
        }
        return this.config.set(pos, ct[0] == 0 ? DEFAULT_CONFIG : ct);
    }

    public boolean canConnect(BlockGetter world, BlockState state, @Nullable BlockEntity tile, BlockPos pos) {
        return state.m_60734_() == this;
    }

    public VoxelShape getShapeByModelIndex(ModelConfig config) {
        VoxelShape shape;
        if (config.hasModelIndex() && (shape = (VoxelShape)this.shapes.get(config.getModelIndex())) != null) {
            return shape;
        }
        return Shapes.m_83144_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getShapeByModelIndex(this.getConfig(state, world, new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), pos));
    }

    @Override
    public List<String> getInfo(List<String> info, Level world, BlockState state, BlockPos pos) {
        info.add("Config: " + Arrays.toString(this.getConfig(state, (BlockGetter)world, new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), pos).getConfig()));
        return info;
    }
}

