/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.datagen.providers;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import muramasa.antimatter.datagen.AntimatterDynamics;
import muramasa.antimatter.datagen.IAntimatterProvider;
import net.devtech.arrp.json.tags.JTag;
import net.minecraft.core.Registry;
import net.minecraft.data.HashCache;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;

public abstract class AntimatterTagProvider<T>
implements IAntimatterProvider {
    private final String providerDomain;
    private final String providerName;
    private final String prefix;
    protected final Map<ResourceLocation, Tag.Builder> builders;
    protected final Registry<T> registry;
    public Object2ObjectMap<ResourceLocation, JsonObject> TAGS = new Object2ObjectOpenHashMap();
    public static Object2ObjectOpenHashMap<ResourceLocation, JsonObject> TAGS_GLOBAL = new Object2ObjectOpenHashMap();

    public AntimatterTagProvider(Registry<T> registry, String providerDomain, String providerName, String prefix) {
        this.builders = Maps.newLinkedHashMap();
        this.registry = registry;
        this.providerDomain = providerDomain;
        this.providerName = providerName;
        this.prefix = prefix;
    }

    @Override
    public void run() {
        HashMap<ResourceLocation, Tag.Builder> b = new HashMap<ResourceLocation, Tag.Builder>(this.builders);
        this.builders.clear();
        this.processTags(this.providerDomain);
        this.builders.forEach(this::addTag);
        this.builders.putAll(b);
    }

    protected abstract void processTags(String var1);

    public void m_6865_(HashCache cache) throws IOException {
    }

    @Override
    public boolean async() {
        return false;
    }

    public String m_6055_() {
        return this.providerName;
    }

    protected TagsProvider.TagAppender<T> tag(TagKey<T> tag) {
        Tag.Builder builder = this.getOrCreateRawBuilder(tag);
        return new TagsProvider.TagAppender(builder, this.registry, this.providerDomain);
    }

    protected Tag.Builder getOrCreateRawBuilder(TagKey<T> tag) {
        return this.builders.computeIfAbsent(tag.f_203868_(), location -> new Tag.Builder());
    }

    public void addTag(ResourceLocation loc, JsonObject obj) {
        this.TAGS.put((Object)loc, (Object)obj);
    }

    public static JTag fromJson(JsonObject obj) {
        JTag tag = JTag.tag();
        if (obj.getAsJsonPrimitive("replace").getAsBoolean()) {
            tag.replace();
        }
        JsonArray array = obj.getAsJsonArray("values");
        array.forEach(e -> {
            String s = e.getAsString();
            if (s.contains("#")) {
                tag.tag(new ResourceLocation(s.replace("#", "")));
            } else {
                tag.add(new ResourceLocation(s));
            }
        });
        return tag;
    }

    public void addTag(ResourceLocation loc, Tag.Builder obj) {
        JsonObject json = (JsonObject)this.TAGS.get((Object)loc);
        if (json == null) {
            this.addTag(loc, obj.m_13334_());
        } else {
            obj = obj.m_13312_(json, "Antimatter - Dynamic Data");
            this.addTag(loc, obj.m_13334_());
        }
    }

    @Override
    public void onCompletion() {
        this.TAGS.forEach((k, v) -> {
            ResourceLocation fixed = AntimatterDynamics.getTagLoc(this.prefix, k);
            JsonObject json = (JsonObject)TAGS_GLOBAL.get((Object)fixed);
            if (json != null) {
                JsonArray local = v.getAsJsonArray("values");
                JsonArray global = json.getAsJsonArray("values");
                global.forEach(arg_0 -> ((JsonArray)local).add(arg_0));
            }
            TAGS_GLOBAL.put((Object)fixed, v);
        });
    }

    public static void afterCompletion() {
        TAGS_GLOBAL.forEach((k, v) -> AntimatterDynamics.RUNTIME_DATA_PACK.addTag(k, AntimatterTagProvider.fromJson(v)));
    }
}

