/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.datagen.providers;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import muramasa.antimatter.Antimatter;
import muramasa.antimatter.datagen.builder.AntimatterShapedRecipeBuilder;
import muramasa.antimatter.datagen.builder.AntimatterShapelessRecipeBuilder;
import muramasa.antimatter.recipe.RecipeUtil;
import muramasa.antimatter.recipe.ingredient.PropertyIngredient;
import muramasa.antimatter.util.TagUtils;
import muramasa.antimatter.util.Utils;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class AntimatterRecipeProvider
extends RecipeProvider {
    protected final String providerDomain;
    protected final String providerName;

    public AntimatterRecipeProvider(String providerDomain, String providerName) {
        super(null);
        this.providerDomain = providerDomain;
        this.providerName = providerName;
    }

    public void m_6865_(HashCache cache) {
    }

    public void addConditionalRecipe(Consumer<FinishedRecipe> consumer, AntimatterShapedRecipeBuilder builtRecipe, Class configClass, String configFieldName, String recipeDomain, String recipeName) {
        RecipeUtil.addConditionalRecipe(consumer, builtRecipe, configClass, configFieldName, recipeDomain, recipeName);
    }

    public void addConditionalRecipe(Consumer<FinishedRecipe> consumer, AntimatterShapedRecipeBuilder builtRecipe, String config, String configField, String recipeDomain, String recipeName) {
        RecipeUtil.addConditionalRecipe(consumer, builtRecipe, config, configField, recipeDomain, recipeName);
    }

    public AntimatterShapedRecipeBuilder getItemRecipe(String groupName, String criterionName, CriterionTriggerInstance criterion, ItemLike output, ImmutableMap<Character, Object> inputs, String ... inputPattern) {
        return this.getStackRecipe(groupName, criterionName, criterion, new ItemStack(output), inputs, inputPattern);
    }

    public AntimatterShapedRecipeBuilder getStackRecipe(String groupName, String criterionName, CriterionTriggerInstance criterion, ItemStack output, ImmutableMap<Character, Object> inputs, String ... inputPattern) {
        return this.getStackRecipe(groupName, criterionName, criterion, Collections.singletonList(output), inputs, inputPattern);
    }

    public AntimatterShapedRecipeBuilder getStackRecipe(String groupName, String criterionName, CriterionTriggerInstance criterion, List<ItemStack> output, ImmutableMap<Character, Object> inputs, String ... inputPattern) {
        if (inputs.isEmpty()) {
            Utils.onInvalidData("Inputs should not be empty!");
        }
        if (inputPattern.length < 1 || inputPattern.length > 3) {
            Utils.onInvalidData("Input pattern must have between 1 and 3 rows!");
        }
        AntimatterShapedRecipeBuilder recipeBuilder = AntimatterShapedRecipeBuilder.shapedRecipe(output);
        recipeBuilder = this.resolveKeys(recipeBuilder, inputs);
        for (String s : inputPattern) {
            if (s.length() > 3) {
                Utils.onInvalidData("Input pattern rows must have between 0 and 3 characters!");
            }
            recipeBuilder = recipeBuilder.patternLine(s);
        }
        recipeBuilder = recipeBuilder.setGroup(groupName);
        recipeBuilder = recipeBuilder.addCriterion(criterionName, criterion);
        return recipeBuilder;
    }

    public void shapeless(Consumer<FinishedRecipe> consumer, String recipeID, String groupName, String criterionName, CriterionTriggerInstance criterion, ItemStack output, Object ... inputs) {
        this.shapeless(consumer, "antimatter", recipeID, groupName, criterionName, criterion, output, inputs);
    }

    public void shapeless(Consumer<FinishedRecipe> consumer, String domain, String recipeID, String groupName, String criterionName, CriterionTriggerInstance criterion, ItemStack output, Object ... inputs) {
        AntimatterShapelessRecipeBuilder builder = AntimatterShapelessRecipeBuilder.shapeless((ItemLike)output.m_41720_(), output.m_41613_()).unlockedBy(criterionName, criterion).group(groupName);
        for (Object input : inputs) {
            try {
                if (input instanceof ItemLike) {
                    ItemLike l = (ItemLike)input;
                    builder.requires(l);
                    continue;
                }
                if (input instanceof TagKey) {
                    TagKey tagKey = (TagKey)input;
                    builder.requires(TagUtils.nc(TagUtils.getItemTag(tagKey.f_203868_()).f_203868_()));
                    continue;
                }
                if (!(input instanceof Ingredient)) continue;
                Ingredient i = (Ingredient)input;
                builder.requires(i);
            }
            catch (ClassCastException ex) {
                throw new RuntimeException("ERROR PARSING SHAPELESS RECIPE" + ex.getMessage());
            }
        }
        if (recipeID.isEmpty()) {
            builder.save(consumer);
        } else if (domain.isEmpty()) {
            builder.save(consumer, recipeID);
        } else {
            builder.save(consumer, this.fixLoc(domain, recipeID));
        }
    }

    public void addItemRecipe(Consumer<FinishedRecipe> consumer, String groupName, String criterionName, CriterionTriggerInstance criterion, ItemLike output, ImmutableMap<Character, Object> inputs, String ... inputPattern) {
        this.addStackRecipe(consumer, "", "", groupName, criterionName, criterion, new ItemStack(output), inputs, inputPattern);
    }

    public void addItemRecipe(Consumer<FinishedRecipe> consumer, String recipeDomain, String recipeName, String groupName, String criterionName, CriterionTriggerInstance criterion, ItemLike output, ImmutableMap<Character, Object> inputs, String ... inputPattern) {
        this.addStackRecipe(consumer, recipeDomain, recipeName, groupName, criterionName, criterion, new ItemStack(output), inputs, inputPattern);
    }

    public void addStackRecipe(Consumer<FinishedRecipe> consumer, String recipeDomain, String recipeName, String groupName, String criterionName, CriterionTriggerInstance criterion, ItemStack output, Function<ImmutableMap.Builder<Character, Object>, ImmutableMap.Builder<Character, Object>> inputs, String ... inputPattern) {
        this.addStackRecipe(consumer, recipeDomain, recipeName, groupName, criterionName, criterion, output, (ImmutableMap<Character, Object>)inputs.apply((ImmutableMap.Builder<Character, Object>)new ImmutableMap.Builder()).build(), inputPattern);
    }

    public void addStackRecipe(Consumer<FinishedRecipe> consumer, String recipeDomain, String recipeName, String groupName, String criterionName, CriterionTriggerInstance criterion, ItemStack output, ImmutableMap<Character, Object> inputs, String ... inputPattern) {
        AntimatterShapedRecipeBuilder recipeBuilder = this.getStackRecipe(groupName, criterionName, criterion, output, inputs, inputPattern);
        if (recipeName.isEmpty()) {
            recipeBuilder.build(consumer);
        } else if (recipeDomain.isEmpty()) {
            recipeBuilder.build(consumer, recipeName);
        } else {
            recipeBuilder.build(consumer, this.fixLoc(recipeDomain, recipeName));
        }
    }

    public void addToolRecipe(String builder, Consumer<FinishedRecipe> consumer, String recipeDomain, String recipeName, String groupName, String criterionName, CriterionTriggerInstance criterion, List<ItemStack> output, Function<ImmutableMap.Builder<Character, Object>, ImmutableMap.Builder<Character, Object>> inputs, String ... inputPattern) {
        this.addToolRecipe(builder, consumer, recipeDomain, recipeName, groupName, criterionName, criterion, output, (ImmutableMap<Character, Object>)inputs.apply((ImmutableMap.Builder<Character, Object>)new ImmutableMap.Builder()).build(), inputPattern);
    }

    public void addToolRecipe(String builder, Consumer<FinishedRecipe> consumer, String recipeDomain, String recipeName, String groupName, String criterionName, CriterionTriggerInstance criterion, ItemStack output, Function<ImmutableMap.Builder<Character, Object>, ImmutableMap.Builder<Character, Object>> inputs, String ... inputPattern) {
        this.addToolRecipe(builder, consumer, recipeDomain, recipeName, groupName, criterionName, criterion, Collections.singletonList(output), (ImmutableMap<Character, Object>)inputs.apply((ImmutableMap.Builder<Character, Object>)new ImmutableMap.Builder()).build(), inputPattern);
    }

    public void addToolRecipe(String builder, Consumer<FinishedRecipe> consumer, String recipeDomain, String recipeName, String groupName, String criterionName, CriterionTriggerInstance criterion, ItemStack output, ImmutableMap<Character, Object> inputs, String ... inputPattern) {
        this.addToolRecipe(builder, consumer, recipeDomain, recipeName, groupName, criterionName, criterion, Collections.singletonList(output), inputs, inputPattern);
    }

    public void addToolRecipe(String builder, Consumer<FinishedRecipe> consumer, String recipeDomain, String recipeName, String groupName, String criterionName, CriterionTriggerInstance criterion, List<ItemStack> output, ImmutableMap<Character, Object> inputs, String ... inputPattern) {
        if (output.isEmpty()) {
            Antimatter.LOGGER.warn("Material recipe " + recipeDomain + ":" + recipeName + "has an empty output.");
            return;
        }
        AntimatterShapedRecipeBuilder recipeBuilder = this.getStackRecipe(groupName, criterionName, criterion, output, inputs, inputPattern);
        if (recipeName.isEmpty()) {
            recipeBuilder.build(consumer);
        } else if (recipeDomain.isEmpty()) {
            recipeBuilder.buildTool(consumer, builder, recipeName);
        } else {
            recipeBuilder.buildTool(consumer, builder, this.fixLoc(recipeDomain, recipeName));
        }
    }

    protected AntimatterShapedRecipeBuilder resolveKeys(AntimatterShapedRecipeBuilder incompleteBuilder, ImmutableMap<Character, Object> inputs) {
        for (Map.Entry entry : inputs.entrySet()) {
            Object v = entry.getValue();
            if (v instanceof ItemLike) {
                ItemLike l = (ItemLike)v;
                incompleteBuilder = incompleteBuilder.key((Character)entry.getKey(), l);
                continue;
            }
            v = entry.getValue();
            if (v instanceof TagKey) {
                TagKey tagKey = (TagKey)v;
                try {
                    incompleteBuilder = incompleteBuilder.key((Character)entry.getKey(), TagUtils.nc(tagKey.f_203868_()));
                }
                catch (ClassCastException e) {
                    Utils.onInvalidData("Tag inputs only allow Item Tags!");
                }
                continue;
            }
            v = entry.getValue();
            if (v instanceof PropertyIngredient) {
                PropertyIngredient pi = (PropertyIngredient)((Object)v);
                incompleteBuilder = incompleteBuilder.key((Character)entry.getKey(), pi);
                continue;
            }
            v = entry.getValue();
            if (!(v instanceof Ingredient)) continue;
            Ingredient i = (Ingredient)v;
            incompleteBuilder = incompleteBuilder.key((Character)entry.getKey(), i);
        }
        return incompleteBuilder;
    }

    public String fixLoc(String providerDomain, String attach) {
        return providerDomain.concat(":").concat(attach);
    }

    public String m_6055_() {
        return this.providerName;
    }

    public CriterionTriggerInstance hasSafeItem(TagKey<Item> tag) {
        return AntimatterRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_()});
    }

    public CriterionTriggerInstance hasSafeItem(ItemLike stack) {
        return RecipeProvider.m_125977_((ItemLike)stack);
    }
}

