/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.datagen.providers;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectRBTreeMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.Ref;
import muramasa.antimatter.block.BlockStone;
import muramasa.antimatter.block.BlockStoneSlab;
import muramasa.antimatter.block.BlockStoneStair;
import muramasa.antimatter.block.BlockStoneWall;
import muramasa.antimatter.block.BlockStorage;
import muramasa.antimatter.block.BlockSurfaceRock;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.datagen.AntimatterDynamics;
import muramasa.antimatter.datagen.IAntimatterProvider;
import muramasa.antimatter.fluid.AntimatterFluid;
import muramasa.antimatter.item.DebugScannerItem;
import muramasa.antimatter.item.ItemBasic;
import muramasa.antimatter.item.ItemBattery;
import muramasa.antimatter.item.ItemCover;
import muramasa.antimatter.item.ItemFluidCell;
import muramasa.antimatter.item.ItemMultiTextureBattery;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialItem;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.material.MaterialTypeBlock;
import muramasa.antimatter.material.MaterialTypeItem;
import muramasa.antimatter.ore.BlockOre;
import muramasa.antimatter.ore.BlockOreStone;
import muramasa.antimatter.ore.CobbleStoneType;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.pipe.BlockPipe;
import muramasa.antimatter.pipe.types.Cable;
import muramasa.antimatter.pipe.types.PipeType;
import muramasa.antimatter.recipe.map.RecipeMap;
import muramasa.antimatter.registration.IAntimatterObject;
import muramasa.antimatter.tool.IAntimatterArmor;
import muramasa.antimatter.tool.IAntimatterTool;
import muramasa.antimatter.util.Utils;
import net.devtech.arrp.json.lang.JLang;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.StringUtils;

public class AntimatterLanguageProvider
implements DataProvider,
IAntimatterProvider {
    private final String providerDomain;
    private final String providerName;
    private final String locale;
    private final Object2ObjectMap<String, String> data = new Object2ObjectRBTreeMap();
    private static final Object2ObjectMap<String, Object2ObjectMap<String, Object2ObjectMap<String, String>>> GLOBAL_DATA = new Object2ObjectRBTreeMap();

    public AntimatterLanguageProvider(String providerDomain, String providerName, String locale) {
        this.providerDomain = providerDomain;
        this.providerName = providerName;
        this.locale = locale;
    }

    @Override
    public final void run() {
        this.addTranslations();
        ((Object2ObjectMap)GLOBAL_DATA.computeIfAbsent((Object)this.providerDomain, d -> new Object2ObjectRBTreeMap())).put((Object)this.locale, this.data);
    }

    @Override
    public final void onCompletion() {
        this.overrides();
    }

    public static void postCompletion() {
        GLOBAL_DATA.forEach((domain, map) -> map.forEach((locale, data) -> {
            JLang lang = JLang.lang();
            data.forEach((arg_0, arg_1) -> ((JLang)lang).entry(arg_0, arg_1));
            AntimatterDynamics.DYNAMIC_RESOURCE_PACK.addLang(new ResourceLocation(domain, locale), lang);
        }));
    }

    public void m_6865_(HashCache cache) throws IOException {
    }

    protected void addTranslations() {
        if (this.locale.startsWith("en")) {
            this.english(this.providerDomain, this.locale);
        }
        if (this.providerDomain.equals("antimatter")) {
            this.processAntimatterTranslations();
        }
    }

    private String tryComponent(String lang, IAntimatterObject object, Supplier<String> otherwise) {
        String component = object.getLang(lang);
        if (component != null) {
            return component;
        }
        return otherwise.get();
    }

    protected void overrides() {
    }

    protected void english(String domain, String locale) {
        AntimatterAPI.all(ItemBasic.class, domain).forEach(i -> this.add((Item)i, Utils.lowerUnderscoreToUpperSpaced(i.getId())));
        AntimatterAPI.all(ItemFluidCell.class, domain).forEach(i -> this.add((Item)i, Utils.lowerUnderscoreToUpperSpaced(i.getId())));
        AntimatterAPI.all(DebugScannerItem.class, domain).forEach(i -> this.add((Item)i, Utils.lowerUnderscoreToUpperSpaced(i.getId())));
        AntimatterAPI.all(ItemCover.class, domain).forEach(i -> this.add((Item)i, Utils.lowerUnderscoreToUpperSpaced(i.getId())));
        AntimatterAPI.all(ItemBattery.class, domain).forEach(i -> this.add((Item)i, Utils.lowerUnderscoreToUpperSpaced(i.getId())));
        AntimatterAPI.all(ItemMultiTextureBattery.class, domain).forEach(i -> this.add((Item)i, Utils.lowerUnderscoreToUpperSpaced(i.getId())));
        AntimatterAPI.all(Machine.class, domain).forEach(i -> {
            if (!i.hasTierSpecificLang()) {
                this.add("machine." + i.getId(), i.getLang(locale).concat(" (%s)"));
                return;
            }
            Collection<Tier> tiers = i.getTiers();
            tiers.forEach(t -> this.add("machine." + i.getId() + "." + t.getId(), i.getLang(locale).concat(t == Tier.NONE ? "" : " (%s)")));
        });
        AntimatterAPI.all(IAntimatterTool.class, domain, t -> {
            if (t.getAntimatterToolType().isPowered()) {
                this.add(t.getItem().m_5524_(), Utils.lowerUnderscoreToUpperSpacedRotated(t.getId()));
            } else {
                this.add(t.getItem().m_5524_(), Utils.lowerUnderscoreToUpperSpaced(t.getId()));
            }
        });
        if (domain.equals("antimatter")) {
            AntimatterAPI.all(BlockPipe.class).forEach(s -> {
                Object str = s.getSize().getId();
                if (((String)str).equals("vtiny")) {
                    str = "very tiny";
                }
                if (s.getType() instanceof Cable) {
                    str = s.getSize().getCableThickness() + "x";
                }
                this.add((Block)s, StringUtils.join((Object[])new String[]{((String)str).substring(0, 1).toUpperCase() + ((String)str).substring(1), " ", Utils.lowerUnderscoreToUpperSpaced(((PipeType)s.getType()).getMaterial().getId()), " ", Utils.lowerUnderscoreToUpperSpaced(((PipeType)s.getType()).getType())}));
            });
            AntimatterAPI.all(Material.class).forEach(m -> this.add("material.".concat(m.getId()), Utils.getLocalizedType(m)));
            AntimatterAPI.all(BlockOre.class, o -> {
                if (o.getOreType() == AntimatterMaterialTypes.ORE) {
                    this.add((Block)o, String.join((CharSequence)"", Utils.getLocalizeStoneType(o.getStoneType()) + " ", Utils.getLocalizedType(o.getMaterial()), " Ore"));
                } else {
                    this.add((Block)o, String.join((CharSequence)"", "Small ", Utils.getLocalizeStoneType(o.getStoneType()) + " ", Utils.getLocalizedType(o.getMaterial()), " Ore"));
                }
            });
            AntimatterAPI.all(BlockOreStone.class, o -> this.add((Block)o, Utils.getLocalizedType(o.getMaterial())));
            AntimatterAPI.all(BlockStone.class).forEach(s -> {
                Object localized = Utils.getLocalizedType(s);
                if (s.getSuffix().contains("mossy")) {
                    localized = "Mossy " + ((String)localized).replace(" Mossy", "");
                }
                if (s.getSuffix().contains("chiseled")) {
                    localized = "Chiseled " + ((String)localized).replace(" Chiseled", "");
                }
                if (s.getSuffix().contains("cracked")) {
                    localized = "Cracked " + ((String)localized).replace(" Cracked", "");
                }
                if (s.getSuffix().contains("smooth")) {
                    localized = "Smooth " + ((String)localized).replace(" Smooth", "");
                }
                this.add((Block)s, (String)localized);
            });
            AntimatterAPI.all(BlockStoneSlab.class).forEach(s -> {
                Object localized = Utils.getLocalizedType(s);
                if (s.getSuffix().contains("mossy")) {
                    localized = "Mossy " + ((String)localized).replace(" Mossy", "");
                }
                if (s.getSuffix().contains("chiseled")) {
                    localized = "Chiseled " + ((String)localized).replace(" Chiseled", "");
                }
                if (s.getSuffix().contains("cracked")) {
                    localized = "Cracked " + ((String)localized).replace(" Cracked", "");
                }
                if (s.getSuffix().contains("smooth")) {
                    localized = "Smooth " + ((String)localized).replace(" Smooth", "");
                }
                this.add((Block)s, (String)localized);
            });
            AntimatterAPI.all(BlockStoneStair.class).forEach(s -> {
                Object localized = Utils.getLocalizedType(s);
                if (s.getSuffix().contains("mossy")) {
                    localized = "Mossy " + ((String)localized).replace(" Mossy", "");
                }
                if (s.getSuffix().contains("chiseled")) {
                    localized = "Chiseled " + ((String)localized).replace(" Chiseled", "");
                }
                if (s.getSuffix().contains("cracked")) {
                    localized = "Cracked " + ((String)localized).replace(" Cracked", "");
                }
                if (s.getSuffix().contains("smooth")) {
                    localized = "Smooth " + ((String)localized).replace(" Smooth", "");
                }
                this.add((Block)s, (String)localized);
            });
            AntimatterAPI.all(BlockStoneWall.class).forEach(s -> {
                Object localized = Utils.getLocalizedType(s);
                if (s.getSuffix().contains("mossy")) {
                    localized = "Mossy " + ((String)localized).replace(" Mossy", "");
                }
                if (s.getSuffix().contains("chiseled")) {
                    localized = "Chiseled " + ((String)localized).replace(" Chiseled", "");
                }
                if (s.getSuffix().contains("cracked")) {
                    localized = "Cracked " + ((String)localized).replace(" Cracked", "");
                }
                if (s.getSuffix().contains("smooth")) {
                    localized = "Smooth " + ((String)localized).replace(" Smooth", "");
                }
                this.add((Block)s, (String)localized);
            });
            AntimatterAPI.all(AntimatterFluid.class).forEach(s -> {
                this.add(s.getAttributes().getTranslationKey(), this.tryComponent(locale, (IAntimatterObject)s, () -> Utils.lowerUnderscoreToUpperSpaced(s.getId())));
                Item bucket = AntimatterAPI.get(Item.class, s.getId() + "_bucket", "antimatter_shared");
                if (bucket != null) {
                    this.add(bucket, this.tryComponent(locale, (IAntimatterObject)s, () -> Utils.lowerUnderscoreToUpperSpaced(s.getId())) + " Bucket");
                }
            });
            AntimatterAPI.all(BlockStorage.class).forEach(block -> {
                MaterialType<?> type = block.getType();
                if (type == AntimatterMaterialTypes.BLOCK) {
                    this.add((Block)block, String.join((CharSequence)"", "Block of ", Utils.getLocalizedType(block.getMaterial())));
                } else if (type == AntimatterMaterialTypes.RAW_ORE_BLOCK) {
                    this.add((Block)block, String.join((CharSequence)"", "Block of Raw ", Utils.getLocalizedType(block.getMaterial())));
                } else {
                    this.add((Block)block, String.join((CharSequence)"", Utils.getLocalizedType(block.getMaterial()), " ", Utils.getLocalizedType(block.getType())));
                }
            });
            AntimatterAPI.all(BlockSurfaceRock.class).forEach(b -> this.add((Block)b, String.join((CharSequence)"", Utils.getLocalizeStoneType(b.getStoneType()) + " ", Utils.getLocalizedType(b.getMaterial()), " Surface Rock")));
            AntimatterAPI.all(MaterialType.class).stream().filter(t -> t instanceof MaterialTypeBlock || t instanceof MaterialTypeItem).forEach(t -> {
                if (t.get() instanceof MaterialTypeBlock.IOreGetter) {
                    AntimatterAPI.all(StoneType.class, s -> this.add("antimatter.rei.group." + t.getId() + "." + s.getId(), Utils.getLocalizedType(s) + " " + Utils.getLocalizedType(t) + "s"));
                    if (t != AntimatterMaterialTypes.ROCK) {
                        return;
                    }
                }
                String[] split = Utils.getLocalizedMaterialType(t);
                if (t == AntimatterMaterialTypes.CRUSHED) {
                    this.add("antimatter.rei.group." + t.getId(), String.join((CharSequence)"", "Crushed Ores"));
                } else if (t == AntimatterMaterialTypes.CRUSHED_PURIFIED) {
                    this.add("antimatter.rei.group." + t.getId(), String.join((CharSequence)"", "Purified Ores"));
                } else if (t == AntimatterMaterialTypes.CRUSHED_REFINED) {
                    this.add("antimatter.rei.group." + t.getId(), String.join((CharSequence)"", "Refined Ores"));
                } else if (t == AntimatterMaterialTypes.RAW_ORE_BLOCK) {
                    this.add("antimatter.rei.group." + t.getId(), "Raw Ore Blocks");
                } else if (t == AntimatterMaterialTypes.ITEM_CASING) {
                    this.add("antimatter.rei.group." + t.getId(), String.join((CharSequence)"", "Item Casings"));
                } else if (split.length > 1) {
                    if (t.isSplitName()) {
                        this.add("antimatter.rei.group." + t.getId(), String.join((CharSequence)"", split[0], " ", split[1], "s"));
                    } else {
                        this.add("antimatter.rei.group." + t.getId(), String.join((CharSequence)"", split[1], " ", split[0], "s"));
                    }
                } else {
                    this.add("antimatter.rei.group." + t.getId(), split[0] + "s");
                }
            });
            AntimatterAPI.all(StoneType.class, s -> {
                if (s instanceof CobbleStoneType) {
                    this.add("antimatter.rei.group." + s.getId(), Utils.getLocalizedType(s));
                }
            });
            AntimatterAPI.all(MaterialItem.class).forEach(item -> {
                MaterialType<?> type = item.getType();
                if (type == AntimatterMaterialTypes.ROCK) {
                    this.add((Item)item, String.join((CharSequence)"", Utils.getLocalizedType(item.getMaterial()), " Bearing Rock"));
                } else if (type == AntimatterMaterialTypes.CRUSHED) {
                    this.add((Item)item, String.join((CharSequence)"", "Crushed ", Utils.getLocalizedType(item.getMaterial()), " Ore"));
                } else if (type == AntimatterMaterialTypes.CRUSHED_PURIFIED) {
                    this.add((Item)item, String.join((CharSequence)"", "Purified ", Utils.getLocalizedType(item.getMaterial()), " Ore"));
                } else if (type == AntimatterMaterialTypes.CRUSHED_REFINED) {
                    this.add((Item)item, String.join((CharSequence)"", "Refined ", Utils.getLocalizedType(item.getMaterial()), " Ore"));
                } else if (type == AntimatterMaterialTypes.DUST_TINY) {
                    this.add((Item)item, String.join((CharSequence)"", "Tiny ", Utils.getLocalizedType(item.getMaterial()), " Dust"));
                } else if (type == AntimatterMaterialTypes.DUST_SMALL) {
                    this.add((Item)item, String.join((CharSequence)"", "Small ", Utils.getLocalizedType(item.getMaterial()), " Dust"));
                } else if (type == AntimatterMaterialTypes.DUST_IMPURE) {
                    this.add((Item)item, String.join((CharSequence)"", "Impure ", Utils.getLocalizedType(item.getMaterial()), " Dust"));
                } else if (type == AntimatterMaterialTypes.DUST_PURE) {
                    this.add((Item)item, String.join((CharSequence)"", "Pure ", Utils.getLocalizedType(item.getMaterial()), " Dust"));
                } else if (type == AntimatterMaterialTypes.RAW_ORE) {
                    this.add((Item)item, String.join((CharSequence)"", "Raw ", Utils.getLocalizedType(item.getMaterial())));
                } else if (type == AntimatterMaterialTypes.ITEM_CASING) {
                    this.add((Item)item, String.join((CharSequence)"", Utils.getLocalizedType(item.getMaterial()), " Item Casings"));
                } else if (type == AntimatterMaterialTypes.GEM) {
                    this.add((Item)item, Utils.getLocalizedType(item.getMaterial()));
                } else {
                    String[] split = Utils.getLocalizedMaterialType(type);
                    if (split.length > 1) {
                        if (type.isSplitName()) {
                            this.add((Item)item, String.join((CharSequence)"", split[0], " ", Utils.getLocalizedType(item.getMaterial()), " ", split[1]));
                        } else {
                            this.add((Item)item, String.join((CharSequence)"", Utils.getLocalizedType(item.getMaterial()), " ", split[1], " ", split[0]));
                        }
                    } else {
                        this.add((Item)item, String.join((CharSequence)"", Utils.getLocalizedType(item.getMaterial()), " ", split[0]));
                    }
                }
            });
            AntimatterAPI.all(IAntimatterArmor.class, t -> this.add(t.getItem().m_5524_(), Utils.lowerUnderscoreToUpperSpaced(t.getId())));
            this.customTranslations();
            this.pipeTranslations();
        }
        AntimatterAPI.all(RecipeMap.class, domain, t -> {
            String id = "jei.category." + t.getId();
            this.add(id, Utils.lowerUnderscoreToUpperSpaced(t.getId().replace('.', '_'), 0));
        });
    }

    protected void customTranslations() {
        this.add("machine.voltage.in", "Voltage in");
        this.add("machine.power.capacity", "Capacity");
        this.add("generic.amp", "Amperage");
        this.add("antimatter.tooltip.formula", "Hold Shift to show formula.");
        this.add("antimatter.tooltip.chemical_formula", "Formula");
        this.add("antimatter.tooltip.mass", "Mass");
        this.add("antimatter.tooltip.more", "Hold Shift to show more information.");
        this.add("antimatter.tooltip.stacks", "Stacks");
        this.add("generic.tier", "Tier");
        this.add("generic.voltage", "Voltage");
        this.add("generic.loss", "Loss (per block)");
        this.add("message.discharge.on", "Discharge enabled");
        this.add("message.discharge.off", "Discharge disabled");
        this.add("item.charge", "Energy");
        this.add("item.reusable", "Reusable");
        this.add("antimatter.tooltip.material_primary", "Primary Material: %s");
        this.add("antimatter.tooltip.material_secondary", "Secondary Material: %s");
        this.add("antimatter.tooltip.dye_color", "Handle Color: %s");
        this.add("antimatter.gui.show_recipes", "Show Recipes");
        this.add("antimatter.tooltip.pressure", "Pressure");
        this.add("antimatter.tooltip.capacity", "Capacity");
        this.add("antimatter.tooltip.max_temperature", "Max Temperature");
        this.add("antimatter.tooltip.energy", "Energy");
        this.add("antimatter.tooltip.heat_capacity", "Heat capacity");
        this.add("antimatter.tooltip.heat_capacity_total", "Heat capacity (total)");
        this.add("antimatter.tooltip.material_modid", "Added by: %s");
        this.add("antimatter.tooltip.occurrence", "Indicates occurrence of %s");
        this.add("antimatter.tooltip.behaviour.aoe_enabled", "%s Enabled");
        this.add("antimatter.tooltip.behaviour.aoe_disabled", "%s Disabled");
        this.add("antimatter.tooltip.behaviour.aoe_right_click", "Sneak right click to Enable/Disable %s");
        this.add("antimatter.behaviour.3x3", "3x3 Mining");
    }

    private final void pipeTranslations() {
        this.add("antimatter.pipe.cable.info", "Transmits amperages between machines. \nFor each cable the cable loss is subtracted \nfrom the total energy.");
        this.add("antimatter.pipe.item.info", "Transfers up to capacity item stacks per tick. \nThis capacity is per stack and not per item transferred.");
        this.add("antimatter.pipe.fluid.info", "Transfers up to capacity per tick, with a buffer of 20 times the capacity. \nEvery tick the capacity of the pipe is replenished, up to 20 times. \nThis allows large transfers at once, but \ncontinuous transfers is limited by capacity");
    }

    private void processAntimatterTranslations() {
        this.add(Ref.TAB_BLOCKS, "Antimatter Blocks");
        this.add(Ref.TAB_ITEMS, "Antimatter Items");
        this.add(Ref.TAB_MACHINES, "Antimatter Machines");
        this.add(Ref.TAB_MATERIALS, "Antimatter Material Items");
        this.add(Ref.TAB_TOOLS, "Antimatter Tools");
    }

    public String m_6055_() {
        return this.providerName;
    }

    public void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Block key, String name) {
        this.add(key.m_7705_(), name);
    }

    public void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Item key, String name) {
        this.add(key.m_5524_(), name);
    }

    public void addItemStack(Supplier<ItemStack> key, String name) {
        this.add(key.get(), name);
    }

    public void add(ItemStack key, String name) {
        this.add(key.m_41778_(), name);
    }

    public void addEnchantment(Supplier<? extends Enchantment> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Enchantment key, String name) {
        this.add(key.m_44704_(), name);
    }

    public void addEffect(Supplier<? extends MobEffect> key, String name) {
        this.add(key.get(), name);
    }

    public void add(MobEffect key, String name) {
        this.add(key.m_19481_(), name);
    }

    public void addEntityType(Supplier<? extends EntityType<?>> key, String name) {
        this.add(key.get(), name);
    }

    public void add(EntityType<?> key, String name) {
        this.add(key.m_20675_(), name);
    }

    public void addItemGroup(Supplier<? extends CreativeModeTab> key, String name) {
        this.add(key.get(), name);
    }

    public void add(CreativeModeTab key, String name) {
        this.add("itemGroup." + key.m_40783_(), name);
    }

    public void add(String key, String value) {
        try {
            if (this.data.containsKey((Object)key)) {
                throw new IllegalStateException("Duplicate translation key " + key + ", Name is " + value);
            }
            this.data.put((Object)key, (Object)value);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void override(String key, String value) {
        this.data.put((Object)key, (Object)value);
    }

    public void override(String domain, String key, String value) {
        Map map;
        Map mapMap = (Map)GLOBAL_DATA.get((Object)domain);
        if (mapMap != null && (map = (Map)mapMap.get(this.locale)) != null) {
            map.put(key, value);
        }
    }
}

