/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.datagen.providers;

import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.block.BlockStone;
import muramasa.antimatter.block.BlockStorage;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.datagen.IAntimatterProvider;
import muramasa.antimatter.datagen.providers.AntimatterBlockTagProvider;
import muramasa.antimatter.datagen.providers.AntimatterTagProvider;
import muramasa.antimatter.item.ItemFluidCell;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialItem;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.material.SubTag;
import muramasa.antimatter.ore.BlockOre;
import muramasa.antimatter.ore.BlockOreStone;
import muramasa.antimatter.ore.CobbleStoneType;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.Cable;
import muramasa.antimatter.pipe.types.Wire;
import muramasa.antimatter.tool.IAntimatterTool;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.antimatter.util.TagUtils;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.Registry;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class AntimatterItemTagProvider
extends AntimatterTagProvider<Item>
implements IAntimatterProvider {
    private final boolean replace;
    private final Function<TagKey<Block>, Tag.Builder> blockTags;

    public AntimatterItemTagProvider(String providerDomain, String providerName, boolean replace, AntimatterBlockTagProvider p) {
        super(Registry.f_122827_, providerDomain, providerName, "items");
        Objects.requireNonNull(p);
        this.blockTags = p::getOrCreateRawBuilder;
        this.replace = replace;
    }

    private void antimatterTags() {
        this.tag(TagUtils.getForgelikeItemTag("pistons")).m_126584_((Object[])new Item[]{Items.f_41869_, Items.f_41862_});
    }

    @Override
    protected void processTags(String domain) {
        if (domain.equals("antimatter")) {
            this.antimatterTags();
        }
        TagKey blockTag = AntimatterMaterialTypes.BLOCK.getTag();
        TagKey frameTag = AntimatterMaterialTypes.FRAME.getTag();
        this.copy(TagUtils.getForgelikeBlockTag("ores"), TagUtils.getForgelikeItemTag("ores"));
        this.copy(TagUtils.getForgelikeBlockTag("stone"), TagUtils.getForgelikeItemTag("stone"));
        this.copy(TagUtils.getForgelikeBlockTag("storage_blocks"), TagUtils.getForgelikeItemTag("storage_blocks"));
        this.copy(blockTag, TagUtils.blockToItemTag(blockTag));
        this.copy(frameTag, TagUtils.blockToItemTag(frameTag));
        if (domain.equals("antimatter")) {
            AntimatterAPI.all(BlockOre.class, o -> {
                String name = String.join((CharSequence)"", Utils.getConventionalStoneType(o.getStoneType()), "_", Utils.getConventionalMaterialType(o.getOreType()), "/", o.getMaterial().getId());
                this.copy(TagUtils.getForgelikeBlockTag(name), TagUtils.getForgelikeItemTag(name));
                String forgeName = String.join((CharSequence)"", Utils.getConventionalMaterialType(o.getOreType()), "/", o.getMaterial().getId());
                this.copy(TagUtils.getForgelikeBlockTag(forgeName), TagUtils.getForgelikeItemTag(forgeName));
            });
            this.tag(TagUtils.getForgelikeItemTag("stone_ores/coal")).m_126582_((Object)Items.f_41835_);
            this.tag(TagUtils.getForgelikeItemTag("deepslate_ores/coal")).m_126582_((Object)Items.f_150963_);
            this.tag(TagUtils.getForgelikeItemTag("stone_ores/iron")).m_126582_((Object)Items.f_41834_);
            this.tag(TagUtils.getForgelikeItemTag("deepslate_ores/iron")).m_126582_((Object)Items.f_150964_);
            this.tag(TagUtils.getForgelikeItemTag("stone_ores/copper")).m_126582_((Object)Items.f_150965_);
            this.tag(TagUtils.getForgelikeItemTag("deepslate_ores/copper")).m_126582_((Object)Items.f_150966_);
            this.tag(TagUtils.getForgelikeItemTag("stone_ores/gold")).m_126582_((Object)Items.f_41833_);
            this.tag(TagUtils.getForgelikeItemTag("deepslate_ores/gold")).m_126582_((Object)Items.f_150967_);
            this.tag(TagUtils.getForgelikeItemTag("stone_ores/redstone")).m_126582_((Object)Items.f_41977_);
            this.tag(TagUtils.getForgelikeItemTag("deepslate_ores/redstone")).m_126582_((Object)Items.f_150968_);
            this.tag(TagUtils.getForgelikeItemTag("stone_ores/emerald")).m_126582_((Object)Items.f_42107_);
            this.tag(TagUtils.getForgelikeItemTag("deepslate_ores/emerald")).m_126582_((Object)Items.f_150969_);
            this.tag(TagUtils.getForgelikeItemTag("stone_ores/lapis")).m_126582_((Object)Items.f_41853_);
            this.tag(TagUtils.getForgelikeItemTag("deepslate_ores/lapis")).m_126582_((Object)Items.f_150993_);
            this.tag(TagUtils.getForgelikeItemTag("stone_ores/diamond")).m_126582_((Object)Items.f_42010_);
            this.tag(TagUtils.getForgelikeItemTag("deepslate_ores/diamond")).m_126582_((Object)Items.f_150994_);
            AntimatterAPI.all(BlockStone.class, s -> {
                String id = "blocks/".concat(s.getId());
                if (s.getSuffix().isEmpty()) {
                    this.tag(TagUtils.getForgelikeItemTag("stone")).m_126582_((Object)s.m_5456_());
                } else if (s.getSuffix().equals("cobble")) {
                    this.tag(TagUtils.getForgelikeItemTag("cobblestone")).m_126582_((Object)s.m_5456_());
                } else if (s.getSuffix().contains("bricks")) {
                    this.tag(ItemTags.f_13169_).m_126582_((Object)s.m_5456_());
                }
                this.copy(TagUtils.getBlockTag(new ResourceLocation("antimatter", id)), TagUtils.getItemTag(new ResourceLocation("antimatter", id)));
            });
            AntimatterAPI.all(StoneType.class, s -> {
                if (s instanceof CobbleStoneType) {
                    CobbleStoneType c = (CobbleStoneType)s;
                    this.tag(ItemTags.f_13165_).m_126582_((Object)c.getBlock("cobble").m_5456_());
                }
            });
            AntimatterAPI.all(BlockOreStone.class, domain, s -> {
                String id = "ore_stones/" + s.getMaterial().getId();
                this.copy(TagUtils.getBlockTag(new ResourceLocation(domain, id)), TagUtils.getItemTag(new ResourceLocation(domain, id)));
            });
            AntimatterAPI.all(BlockStorage.class, storage -> {
                MaterialType<?> type = storage.getType();
                String name = String.join((CharSequence)"", Utils.getConventionalMaterialType(type), "/", storage.getMaterial().getId());
                this.copy(TagUtils.getForgelikeBlockTag(name), TagUtils.getForgelikeItemTag(name));
            });
            AntimatterAPI.all(MaterialItem.class, item -> {
                TagKey<?> type = item.getType().getTag();
                TagsProvider.TagAppender<?> provider = this.tag(type);
                provider.m_126582_(item).replace(this.replace);
                this.tag(item.getTag()).m_126582_(item).replace(this.replace);
            });
            AntimatterAPI.all(MaterialType.class, t -> t.getReplacements().forEach((m, i) -> {
                this.tag(t.getMaterialTag((Material)m)).m_126582_(((Supplier)i).get()).replace(this.replace);
                this.tag(t.getTag()).m_126582_(((Supplier)i).get()).replace(this.replace);
            }));
            if (AntimatterPlatformUtils.isFabric()) {
                for (DyeColor dyeColor : DyeColor.values()) {
                    this.tag(TagUtils.getForgelikeItemTag("dyes/" + dyeColor.m_41065_())).m_126582_((Object)((Item)Registry.f_122827_.m_7745_(new ResourceLocation(dyeColor.m_41065_() + "_dye"))));
                }
            }
            this.processSubtags();
        }
        AntimatterAPI.all(IAntimatterTool.class, domain, tool -> {
            this.tag(tool.getAntimatterToolType().getTag()).m_126582_((Object)tool.getItem()).replace(this.replace);
            this.tag(tool.getAntimatterToolType().getForgeTag()).m_126582_((Object)tool.getItem()).replace(this.replace);
        });
        this.copy(TagUtils.getBlockTag(new ResourceLocation("antimatter", "item_pipe")), TagUtils.getItemTag(new ResourceLocation("antimatter", "item_pipe")));
        this.tag(ItemFluidCell.getTag()).m_126584_((Object[])AntimatterAPI.all(ItemFluidCell.class, domain).toArray(new Item[0]));
    }

    protected void processSubtags() {
        for (PipeSize value : PipeSize.values()) {
            Set<Material> mats = MaterialTags.WIRE.allSub(SubTag.COPPER_WIRE);
            if (mats.size() > 0) {
                this.tag(TagUtils.getItemTag(new ResourceLocation("antimatter", SubTag.COPPER_WIRE.getId() + "_" + value.getId()))).m_126584_((Object[])((Item[])mats.stream().map(t -> AntimatterAPI.get(Wire.class, "wire_" + t.getId())).filter(Objects::nonNull).map(t -> t.getBlockItem(value)).toArray(Item[]::new)));
            }
            if ((mats = MaterialTags.CABLE.allSub(SubTag.COPPER_CABLE)).size() <= 0) continue;
            this.tag(TagUtils.getItemTag(new ResourceLocation("antimatter", SubTag.COPPER_CABLE.getId() + "_" + value.getId()))).m_126584_((Object[])((Item[])mats.stream().map(t -> AntimatterAPI.get(Cable.class, "cable_" + t.getId())).filter(Objects::nonNull).map(t -> t.getBlockItem(value)).toArray(Item[]::new)));
        }
    }

    protected void copy(TagKey<Block> blockTag, TagKey<Item> itemTag) {
        Tag.Builder builder = this.getOrCreateRawBuilder(itemTag);
        Tag.Builder builder2 = this.blockTags.apply(blockTag);
        Stream stream = builder2.m_13330_();
        Objects.requireNonNull(builder);
        stream.forEach(arg_0 -> ((Tag.Builder)builder).m_13305_(arg_0));
    }
}

