/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.datagen.providers;

import java.io.IOException;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.client.AntimatterModelManager;
import muramasa.antimatter.datagen.IAntimatterProvider;
import muramasa.antimatter.datagen.builder.AntimatterBlockModelBuilder;
import muramasa.antimatter.datagen.builder.AntimatterItemModelBuilder;
import muramasa.antimatter.datagen.providers.AntimatterModelProvider;
import muramasa.antimatter.fluid.AntimatterFluid;
import muramasa.antimatter.tool.IAntimatterArmor;
import muramasa.antimatter.tool.IAntimatterTool;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class AntimatterItemModelProvider
extends AntimatterModelProvider<AntimatterItemModelBuilder>
implements IAntimatterProvider {
    protected final String providerName;

    public AntimatterItemModelProvider(String providerDomain, String providerName) {
        super(providerDomain, "item", AntimatterItemModelBuilder::new);
        this.providerName = providerName;
    }

    public void m_6865_(HashCache cache) throws IOException {
    }

    @Override
    public String m_6055_() {
        return this.providerName;
    }

    @Override
    public void run() {
        this.registerModels();
    }

    @Override
    public void onCompletion() {
        this.buildAll();
    }

    protected void registerModels() {
        this.processItemModels(this.modid);
    }

    public void processItemModels(String domain) {
        AntimatterAPI.all(Item.class, domain).forEach(i -> AntimatterModelManager.onItemModelBuild((ItemLike)i, this));
        AntimatterAPI.all(Block.class, domain).forEach(b -> AntimatterModelManager.onItemModelBuild((ItemLike)b, this));
        AntimatterAPI.all(IAntimatterTool.class, domain).forEach(t -> this.tex((ItemLike)t.getItem(), "item/handheld", (ResourceLocation[])t.getTextures()));
        AntimatterAPI.all(IAntimatterArmor.class, domain).forEach(t -> this.tex((ItemLike)t.getItem(), "item/handheld", (ResourceLocation[])t.getTextures()));
        AntimatterAPI.all(AntimatterFluid.class, domain).forEach(f -> {
            this.modelAndTexture((ItemLike)f.getContainerItem(), "forge", "item/bucket").bucketProperties((Fluid)f.getFluid());
            this.modelAndTexture((ItemLike)f.getFluidBlock(), AntimatterBlockModelBuilder.getSimple()).tex(a -> a.put("all", f.getAttributes().getFlowingTexture().toString()));
        });
    }

    public AntimatterItemModelBuilder getBuilder(ItemLike item) {
        return (AntimatterItemModelBuilder)this.getBuilder(AntimatterPlatformUtils.getIdFromItem(item.m_5456_()).m_135815_());
    }

    public AntimatterItemModelBuilder tex(ItemLike item, ResourceLocation ... textures) {
        return this.tex(item, "minecraft:item/generated", textures);
    }

    public AntimatterItemModelBuilder tex(ItemLike item, String parent, ResourceLocation ... textures) {
        AntimatterItemModelBuilder builder = this.getBuilder(item);
        builder.parent(new ResourceLocation(parent));
        for (int i = 0; i < textures.length; ++i) {
            builder.texture("layer" + i, textures[i]);
        }
        return builder;
    }

    public AntimatterItemModelBuilder blockItem(Block block) {
        return this.blockItem((ItemLike)block.m_5456_());
    }

    public AntimatterItemModelBuilder blockItem(ItemLike item) {
        return (AntimatterItemModelBuilder)this.withParent(AntimatterPlatformUtils.getIdFromItem(item.m_5456_()).m_135815_(), this.modLoc("block/" + AntimatterPlatformUtils.getIdFromItem(item.m_5456_()).m_135815_()));
    }

    public ResourceLocation existing(String domain, String path) {
        return new ResourceLocation(domain, path);
    }

    public AntimatterItemModelBuilder getAntimatterBuilder(ItemLike item) {
        return (AntimatterItemModelBuilder)this.getBuilder(AntimatterPlatformUtils.getIdFromItem(item.m_5456_()).m_135815_());
    }

    public AntimatterItemModelBuilder modelAndTexture(ItemLike item, String namespace, String path) {
        return (AntimatterItemModelBuilder)this.getAntimatterBuilder(item).parent(new ResourceLocation(namespace, path));
    }

    public AntimatterItemModelBuilder modelAndTexture(ItemLike item, String resource) {
        return (AntimatterItemModelBuilder)this.getAntimatterBuilder(item).parent(new ResourceLocation(resource));
    }
}

