/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.datagen.providers;

import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.block.BlockStone;
import muramasa.antimatter.block.BlockStoneSlab;
import muramasa.antimatter.block.BlockStoneStair;
import muramasa.antimatter.block.BlockStoneWall;
import muramasa.antimatter.block.BlockStorage;
import muramasa.antimatter.data.AntimatterDefaultTools;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.data.AntimatterStoneTypes;
import muramasa.antimatter.datagen.providers.AntimatterTagProvider;
import muramasa.antimatter.machine.BlockMachine;
import muramasa.antimatter.machine.BlockMultiMachine;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.ore.BlockOre;
import muramasa.antimatter.ore.BlockOreStone;
import muramasa.antimatter.pipe.BlockItemPipe;
import muramasa.antimatter.pipe.BlockPipe;
import muramasa.antimatter.pipe.types.PipeType;
import muramasa.antimatter.util.TagUtils;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;

public class AntimatterBlockTagProvider
extends AntimatterTagProvider<Block> {
    private final boolean replace;

    public AntimatterBlockTagProvider(String providerDomain, String providerName, boolean replace) {
        super(Registry.f_122824_, providerDomain, providerName, "blocks");
        this.replace = replace;
    }

    @Override
    protected void processTags(String domain) {
        if (domain.equals("antimatter")) {
            AntimatterAPI.all(BlockOre.class, o -> {
                this.tag(TagUtils.getForgelikeBlockTag(String.join((CharSequence)"", Utils.getConventionalStoneType(o.getStoneType()), "_", Utils.getConventionalMaterialType(o.getOreType()), "/", o.getMaterial().getId()))).m_126582_(o).replace(this.replace);
                this.tag(TagUtils.getForgelikeBlockTag(String.join((CharSequence)"", Utils.getConventionalMaterialType(o.getOreType()), "/", o.getMaterial().getId()))).m_126582_(o).replace(this.replace);
                if (o.getStoneType() == AntimatterStoneTypes.SAND || o.getStoneType() == AntimatterStoneTypes.SAND_RED || o.getStoneType() == AntimatterStoneTypes.GRAVEL) {
                    this.tag(BlockTags.f_144283_).m_126582_(o).replace(this.replace);
                } else {
                    this.tag(BlockTags.f_144282_).m_126582_(o).replace(this.replace);
                }
                int oreMiningLevel = o.getMaterial().has(MaterialTags.MINING_LEVEL) ? MaterialTags.MINING_LEVEL.getInt(o.getMaterial()) : 0;
                int stoneMiningLevel = o.getStoneType().getHarvestLevel();
                int maxLevel = Math.max(oreMiningLevel, stoneMiningLevel);
                if (maxLevel > 0) {
                    this.tag(this.fromMiningLevel(maxLevel)).m_126582_(o);
                }
                if (o.getOreType() == AntimatterMaterialTypes.ORE) {
                    this.tag(TagUtils.getForgelikeBlockTag("ores")).m_126582_(o);
                }
            });
            AntimatterAPI.all(BlockStone.class, s -> {
                if (s.getSuffix().isEmpty()) {
                    this.tag(TagUtils.getForgelikeBlockTag("stone")).m_126582_(s);
                } else if (s.getSuffix().equals("cobble")) {
                    this.tag(TagUtils.getForgelikeBlockTag("cobblestone")).m_126582_(s);
                } else if (s.getSuffix().contains("bricks")) {
                    this.tag(BlockTags.f_13091_).m_126582_(s);
                }
                this.tag(BlockTags.f_144282_).m_126582_(s).replace(this.replace);
                int stoneMiningLevel = s.getType().getHarvestLevel();
                if (stoneMiningLevel > 0) {
                    this.tag(this.fromMiningLevel(stoneMiningLevel)).m_126582_(s);
                }
                this.tag(TagUtils.getBlockTag(new ResourceLocation("antimatter", "blocks/".concat(s.getId())))).m_126582_(s).replace(this.replace);
            });
            AntimatterAPI.all(BlockStoneWall.class, b -> {
                this.tag(BlockTags.f_144282_).m_126582_(b).replace(this.replace);
                this.tag(BlockTags.f_13032_).m_126582_(b);
            });
            AntimatterAPI.all(BlockStoneSlab.class, b -> {
                this.tag(BlockTags.f_144282_).m_126582_(b).replace(this.replace);
                this.tag(BlockTags.f_13031_).m_126582_(b);
            });
            AntimatterAPI.all(BlockStoneStair.class, b -> {
                this.tag(BlockTags.f_144282_).m_126582_(b).replace(this.replace);
                this.tag(BlockTags.f_13030_).m_126582_(b);
            });
            AntimatterAPI.all(BlockOreStone.class, s -> {
                String id = "ore_stones/" + s.getMaterial().getId();
                this.tag(BlockTags.f_144282_).m_126582_(s).replace(this.replace);
                this.tag(TagUtils.getForgelikeBlockTag("ores")).m_126582_(s);
                this.tag(TagUtils.getForgelikeBlockTag(id)).m_126582_(s);
            });
            AntimatterAPI.all(BlockStorage.class, block -> {
                this.tag(block.getType().getTag()).m_126582_(block).replace(this.replace);
                String name = String.join((CharSequence)"", block.getType().getTag().f_203868_().m_135815_(), "/", block.getType().getId().equals("raw_ore_block") ? "raw_" : "", block.getMaterial().getId());
                this.tag(AntimatterDefaultTools.WRENCH.getToolType()).m_126582_(block).replace(this.replace);
                this.tag(TagUtils.getForgelikeBlockTag(name)).m_126582_(block);
            });
            AntimatterAPI.all(BlockItemPipe.class, pipe -> this.tag(TagUtils.getBlockTag(new ResourceLocation("antimatter", "item_pipe"))).m_126582_(pipe));
            AntimatterAPI.all(BlockPipe.class, pipe -> {
                this.tag(pipe.getToolType().getToolType()).m_126582_(pipe);
                if (((PipeType)pipe.getType()).getMaterial() == AntimatterMaterials.Wood) {
                    this.tag(AntimatterDefaultTools.AXE.getToolType()).m_126582_(pipe);
                }
            });
            AntimatterAPI.all(BlockMachine.class, pipe -> this.tag(AntimatterDefaultTools.WRENCH.getToolType()).m_126582_(pipe));
            AntimatterAPI.all(BlockMultiMachine.class, pipe -> this.tag(AntimatterDefaultTools.WRENCH.getToolType()).m_126582_(pipe));
        }
    }

    public TagKey<Block> fromMiningLevel(int miningLevels) {
        return switch (miningLevels) {
            case 2 -> BlockTags.f_144285_;
            case 3 -> BlockTags.f_144284_;
            default -> BlockTags.f_144286_;
        };
    }
}

