/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.datagen.providers;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.block.BlockStone;
import muramasa.antimatter.block.BlockStoneSlab;
import muramasa.antimatter.block.BlockStoneStair;
import muramasa.antimatter.block.BlockStoneWall;
import muramasa.antimatter.block.BlockStorage;
import muramasa.antimatter.data.AntimatterDefaultTools;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.datagen.AntimatterDynamics;
import muramasa.antimatter.datagen.IAntimatterProvider;
import muramasa.antimatter.machine.BlockMachine;
import muramasa.antimatter.machine.BlockMultiMachine;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.ore.BlockOre;
import muramasa.antimatter.ore.BlockOreStone;
import muramasa.antimatter.ore.CobbleStoneType;
import muramasa.antimatter.pipe.BlockPipe;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class AntimatterBlockLootProvider
extends BlockLoot
implements DataProvider,
IAntimatterProvider {
    protected final String providerDomain;
    protected final String providerName;
    protected final Map<Block, Function<Block, LootTable.Builder>> tables = new Object2ObjectOpenHashMap();
    public static final LootItemCondition.Builder BRANCH_CUTTER = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(AntimatterDefaultTools.BRANCH_CUTTER.getTag()));
    public static final LootItemCondition.Builder HAMMER = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(AntimatterDefaultTools.HAMMER.getTag()));
    public static final LootItemCondition.Builder SAW = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(AntimatterDefaultTools.SAW.getTag()).m_45071_(new EnchantmentPredicate(){

        public boolean m_30476_(Map<Enchantment, Integer> enchantmentsIn) {
            return !enchantmentsIn.containsKey(Enchantments.f_44985_);
        }
    }));

    public AntimatterBlockLootProvider(String providerDomain, String providerName) {
        this.providerDomain = providerDomain;
        this.providerName = providerName;
    }

    public static void init() {
    }

    @Override
    public void run() {
        this.loot();
    }

    protected void loot() {
        AntimatterAPI.all(BlockMachine.class, this.providerDomain, this::add);
        AntimatterAPI.all(BlockMultiMachine.class, this.providerDomain, this::add);
        if (this.providerDomain.equals("antimatter")) {
            AntimatterAPI.all(BlockPipe.class, this::add);
            AntimatterAPI.all(BlockStorage.class, this::add);
            AntimatterAPI.all(BlockStone.class, b -> {
                if (b.getType() instanceof CobbleStoneType && b.getSuffix().isEmpty()) {
                    this.tables.put((Block)b, b2 -> AntimatterBlockLootProvider.m_124257_((Block)b, (ItemLike)((CobbleStoneType)b.getType()).getBlock("cobble")));
                    return;
                }
                this.add((Block)b);
            });
            AntimatterAPI.all(BlockStoneSlab.class, b -> this.tables.put((Block)b, BlockLoot::m_124290_));
            AntimatterAPI.all(BlockStoneStair.class, this::add);
            AntimatterAPI.all(BlockStoneWall.class, this::add);
            AntimatterAPI.all(BlockOre.class, this::addToFortune);
            AntimatterAPI.all(BlockOreStone.class, this::addToStone);
        }
    }

    @Override
    public void onCompletion() {
        for (Map.Entry<Block, Function<Block, LootTable.Builder>> e : this.tables.entrySet()) {
            LootTable table = e.getValue().apply(e.getKey()).m_79165_(LootContextParamSets.f_81421_).m_79167_();
            AntimatterDynamics.RUNTIME_DATA_PACK.addData(AntimatterDynamics.fix(AntimatterPlatformUtils.getIdFromBlock(e.getKey()), "loot_tables/blocks", "json"), AntimatterDynamics.serialize(table));
        }
    }

    public void m_6865_(HashCache cache) throws IOException {
    }

    protected void addToFortune(BlockOre block) {
        if (block.getMaterial().has(MaterialTags.CUSTOM_ORE_DROPS)) {
            this.tables.put(block, b -> MaterialTags.CUSTOM_ORE_DROPS.getBuilderFunction(block.getMaterial()).apply(block));
            return;
        }
        this.tables.put(block, AntimatterBlockLootProvider.addToFortuneWithoutCustomDrops(block));
    }

    public static Function<Block, LootTable.Builder> addToFortuneWithoutCustomDrops(BlockOre block) {
        if (block.getOreType() == AntimatterMaterialTypes.ORE_SMALL) {
            if (!block.getMaterial().has(AntimatterMaterialTypes.GEM) && !block.getMaterial().has(AntimatterMaterialTypes.CRUSHED)) {
                return BlockLoot::m_124126_;
            }
            Item item = block.getMaterial().has(AntimatterMaterialTypes.GEM) ? AntimatterMaterialTypes.GEM.get(block.getMaterial()) : null;
            int multiplier = MaterialTags.ORE_MULTI.getInt(block.getMaterial());
            LootPool.Builder builder = item != null ? LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)AntimatterBlockLootProvider.m_124131_((ItemLike)item, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)item).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)multiplier))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)))).m_79707_(30)) : LootPool.m_79043_();
            if (block.getMaterial().has(AntimatterMaterialTypes.CRUSHED)) {
                Item crushed = AntimatterMaterialTypes.CRUSHED.get(block.getMaterial());
                builder.m_79076_((LootPoolEntryContainer.Builder)AntimatterBlockLootProvider.m_124131_((ItemLike)crushed, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)crushed).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)(1.0f * (float)multiplier), (float)(2.0f * (float)multiplier)))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)).m_79707_(40)));
            }
            if (block.getMaterial().has(AntimatterMaterialTypes.DUST_IMPURE)) {
                Item dirty = AntimatterMaterialTypes.DUST_IMPURE.get(block.getMaterial());
                builder.m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)AntimatterBlockLootProvider.m_124131_((ItemLike)dirty, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)dirty).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)(1.0f * (float)multiplier), (float)(2.0f * (float)multiplier)))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)))).m_79707_(60));
            }
            return b -> LootTable.m_79147_().m_79161_(builder);
        }
        if (block.getOreType() == AntimatterMaterialTypes.ORE) {
            Item drop = block.getMaterial().has(AntimatterMaterialTypes.CRUSHED) || block.getMaterial().has(AntimatterMaterialTypes.DUST) ? (block.getMaterial().has(AntimatterMaterialTypes.CRUSHED) ? AntimatterMaterialTypes.CRUSHED.get(block.getMaterial()) : AntimatterMaterialTypes.DUST.get(block.getMaterial())) : null;
            Item item = block.getStoneType().isSandLike() ? block.m_5456_() : AntimatterMaterialTypes.RAW_ORE.get(block.getMaterial());
            return b -> AntimatterBlockLootProvider.createOreDropWithHammer(b, item, drop);
        }
        return BlockLoot::m_124126_;
    }

    public static LootTable.Builder createOreDropWithHammer(Block block, Item primaryDrop, Item hammerDrop) {
        LootTable.Builder builder = LootTable.m_79147_();
        if (block.m_5456_() == primaryDrop) {
            LootPool.Builder loot = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)primaryDrop));
            if (hammerDrop != null) {
                loot.m_6509_(HAMMER.m_81807_());
            }
            builder.m_79161_((LootPool.Builder)AntimatterBlockLootProvider.m_124134_((ItemLike)block, (ConditionUserBuilder)loot));
        } else {
            LootPoolSingletonContainer.Builder pool = LootItem.m_79579_((ItemLike)primaryDrop).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_));
            if (hammerDrop != null) {
                pool.m_6509_(HAMMER.m_81807_());
            }
            builder = AntimatterBlockLootProvider.m_124168_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)AntimatterBlockLootProvider.m_124131_((ItemLike)block, (FunctionUserBuilder)pool)));
        }
        if (hammerDrop != null) {
            builder.m_79161_((LootPool.Builder)AntimatterBlockLootProvider.m_124134_((ItemLike)hammerDrop, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(HAMMER).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)hammerDrop))));
        }
        return builder;
    }

    protected void addToStone(BlockOreStone block) {
        if (block.getMaterial().has(MaterialTags.CUSTOM_ORE_STONE_DROPS)) {
            this.tables.put(block, b -> MaterialTags.CUSTOM_ORE_STONE_DROPS.getBuilderFunction(block.getMaterial()).apply(block));
            return;
        }
        if (block.getMaterial().has(AntimatterMaterialTypes.RAW_ORE)) {
            Item item = AntimatterMaterialTypes.RAW_ORE.get(block.getMaterial());
            this.tables.put(block, b -> AntimatterBlockLootProvider.m_124168_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)AntimatterBlockLootProvider.m_124131_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)item).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))))));
            return;
        }
        this.add(block);
    }

    protected void add(Block block) {
        this.tables.put(block, this::build);
    }

    protected LootTable.Builder build(Block block) {
        return AntimatterBlockLootProvider.m_124126_((ItemLike)block);
    }

    public String m_6055_() {
        return this.providerName;
    }

    protected static LootTable.Builder droppingWithBranchCutters(Block block, Block sapling, float ... chances) {
        return AntimatterBlockLootProvider.m_124157_((Block)block, (Block)sapling, (float[])chances).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(BRANCH_CUTTER).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)sapling)));
    }
}

