/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.datagen.providers;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import muramasa.antimatter.datagen.AntimatterDynamics;
import muramasa.antimatter.datagen.IAntimatterProvider;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.FrameType;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AntimatterAdvancementProvider
implements DataProvider,
IAntimatterProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<Consumer<Consumer<Advancement>>> advancements;
    private final String providerDomain;
    private final String providerName;

    @SafeVarargs
    public AntimatterAdvancementProvider(String providerDomain, String providerName, Consumer<Consumer<Advancement>> ... advancements) {
        this.providerDomain = providerDomain;
        this.providerName = providerName;
        if (advancements.length == 0) {
            throw new IllegalArgumentException("AntimatterAdvancementProvider requires at least one Advancement class.");
        }
        this.advancements = Arrays.asList(advancements);
    }

    @Override
    public void run() {
    }

    @Override
    public void onCompletion() {
        ObjectOpenHashSet locs = new ObjectOpenHashSet();
        Consumer<Advancement> consumer = arg_0 -> AntimatterAdvancementProvider.lambda$onCompletion$0((Set)locs, arg_0);
        this.advancements.forEach(a -> a.accept(consumer));
    }

    public void m_6865_(@Nonnull HashCache cache) {
    }

    private Path getPath(Path path, Advancement advancement) {
        return path.resolve(String.join((CharSequence)"", "data/", this.providerDomain, "/advancements/", advancement.m_138327_().m_135815_(), ".json"));
    }

    @Nonnull
    public String m_6055_() {
        return this.providerName;
    }

    public static Advancement.Builder buildRootAdvancement(ItemLike provider, ResourceLocation backgroundPath, String title, String desc, FrameType type, boolean toast, boolean announce, boolean hide) {
        return Advancement.Builder.m_138353_().m_138371_(provider, (Component)new TranslatableComponent(title), (Component)new TranslatableComponent(desc), backgroundPath, type, toast, announce, hide).m_138354_(AdvancementRewards.Builder.m_10005_((int)10));
    }

    public static Advancement.Builder buildAdvancement(Advancement parent, ItemLike provider, String title, String desc, FrameType type, boolean toast, boolean announce, boolean hide) {
        return Advancement.Builder.m_138353_().m_138398_(parent).m_138371_(provider, (Component)new TranslatableComponent(title), (Component)new TranslatableComponent(desc), null, type, toast, announce, hide).m_138354_(AdvancementRewards.Builder.m_10005_((int)10));
    }

    public static String getLoc(String domain, String id) {
        return String.join((CharSequence)":", domain, id);
    }

    private static /* synthetic */ void lambda$onCompletion$0(Set locs, Advancement a) {
        if (!locs.add(a.m_138327_())) {
            throw new IllegalStateException("Duplicate advancement " + a.m_138327_());
        }
        AntimatterDynamics.RUNTIME_DATA_PACK.addData(AntimatterDynamics.fix(a.m_138327_(), "advancements", "json"), AntimatterDynamics.serialize(a.m_138313_()));
    }
}

