/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.datagen.loaders;

import com.google.common.collect.ImmutableMap;
import java.util.function.Consumer;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterStoneTypes;
import muramasa.antimatter.datagen.providers.AntimatterRecipeProvider;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.ore.CobbleStoneType;
import muramasa.antimatter.ore.StoneType;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class StoneRecipes {
    public static void loadRecipes(Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider) {
        provider.addItemRecipe(output, "minecraft", "", "furnaces", "has_cobble", provider.hasSafeItem((TagKey<Item>)ItemTags.f_13165_), (ItemLike)Items.f_41962_, (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('C'), (Object)ItemTags.f_13165_), "CCC", "C C", "CCC");
        AntimatterAPI.all(StoneType.class).forEach(s -> {
            Material m = s.getMaterial();
            if (m.has(AntimatterMaterialTypes.ROD)) {
                provider.addStackRecipe(output, "antimatter", m.getId() + "_rod", "rods", "has_stone", provider.hasSafeItem((ItemLike)s.getState().m_60734_()), AntimatterMaterialTypes.ROD.get(m, 4), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), (Object)s.getState().m_60734_()), "S", "S");
                if (s == AntimatterStoneTypes.STONE) {
                    provider.addStackRecipe(output, "antimatter", m.getId() + "_rod_2", "rods", "has_stone", provider.hasSafeItem((ItemLike)Items.f_42594_), AntimatterMaterialTypes.ROD.get(m, 4), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), (Object)Items.f_42594_), "S", "S");
                }
                if (s instanceof CobbleStoneType) {
                    provider.addStackRecipe(output, "antimatter", m.getId() + "_rod_2", "rods", "has_stone", provider.hasSafeItem((ItemLike)((CobbleStoneType)s).getBlock("cobble")), AntimatterMaterialTypes.ROD.get(m, 4), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), (Object)((CobbleStoneType)s).getBlock("cobble")), "S", "S");
                }
            }
            if (s instanceof CobbleStoneType) {
                String[] types;
                CobbleStoneType c = (CobbleStoneType)s;
                SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("cobble")}), (ItemLike)c.getBlock(""), (float)0.1f, (int)200).m_142284_("has_cobble", provider.hasSafeItem((ItemLike)c.getBlock("cobble"))).m_176500_(output, m.getId() + "_stone");
                SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("")}), (ItemLike)c.getBlock("smooth"), (float)0.1f, (int)200).m_142284_("has_stone", provider.hasSafeItem((ItemLike)c.getBlock(""))).m_176500_(output, m.getId() + "_smooth");
                SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("bricks")}), (ItemLike)c.getBlock("bricks_cracked"), (float)0.1f, (int)200).m_142284_("has_bricks", provider.hasSafeItem((ItemLike)c.getBlock("bricks"))).m_176500_(output, m.getId() + "_bricks_cracked");
                for (String type : types = new String[]{"bricks_mossy", "cobble_mossy", "bricks", "cobble", "smooth", ""}) {
                    String[] stringArray;
                    String i = type.isEmpty() ? "" : "_";
                    provider.addStackRecipe(output, "antimatter", "slab_" + m.getId() + i + type, "slabs", "has_stone", provider.hasSafeItem((ItemLike)c.getBlock(type)), new ItemStack((ItemLike)c.getBlock(type + i + "slab"), 6), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), (Object)c.getBlock(type)), "SSS");
                    provider.addStackRecipe(output, "antimatter", "stairs_" + m.getId() + i + type, "stairs", "has_stone", provider.hasSafeItem((ItemLike)c.getBlock(type)), new ItemStack((ItemLike)c.getBlock(type + i + "stairs"), 4), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), (Object)c.getBlock(type)), "S  ", "SS ", "SSS");
                    provider.addStackRecipe(output, "antimatter", "wall_" + m.getId() + i + type, "walls", "has_stone", provider.hasSafeItem((ItemLike)c.getBlock(type)), new ItemStack((ItemLike)c.getBlock(type + i + "wall"), 6), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), (Object)c.getBlock(type)), "SSS", "SSS");
                    if (type.equals("bricks")) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = "SS";
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = "S";
                        stringArray = stringArray3;
                        stringArray3[1] = "S";
                    }
                    String[] pattern = stringArray;
                    provider.addStackRecipe(output, "antimatter", m.getId() + i + type + "_from_slabs", "slabs", "has_stone", provider.hasSafeItem((ItemLike)c.getBlock(type + i + "slab")), new ItemStack((ItemLike)c.getBlock(type), 1), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), (Object)c.getBlock(type + i + "slab")), pattern);
                }
                provider.addStackRecipe(output, "antimatter", "bricks_" + m.getId(), "bricks", "has_stone", provider.hasSafeItem((ItemLike)c.getBlock("")), new ItemStack((ItemLike)c.getBlock("bricks"), 4), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), (Object)c.getBlock("")), "SS", "SS");
                provider.addStackRecipe(output, "antimatter", "bricks_chiseled_" + m.getId(), "bricks", "has_stone", provider.hasSafeItem((ItemLike)c.getBlock("bricks_slab")), new ItemStack((ItemLike)c.getBlock("bricks_chiseled"), 1), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), (Object)c.getBlock("bricks_slab")), "S", "S");
                provider.shapeless(output, "bricks_mossy_" + m.getId(), "bricks", "has_vines", provider.hasSafeItem((ItemLike)Items.f_42029_), new ItemStack((ItemLike)c.getBlock("bricks_mossy")), c.getBlock("bricks"), Items.f_42029_);
                provider.shapeless(output, "cobble_mossy_" + m.getId(), "bricks", "has_vines", provider.hasSafeItem((ItemLike)Items.f_42029_), new ItemStack((ItemLike)c.getBlock("cobble_mossy")), c.getBlock("cobble"), Items.f_42029_);
                for (String type : types = new String[]{"stairs", "slab", "wall", "bricks_slab", "bricks_stairs", "bricks_chiseled", "bricks_wall", "bricks"}) {
                    int amount = type.contains("slab") ? 2 : 1;
                    SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("")}), (ItemLike)c.getBlock(type), (int)amount).m_142284_("has_stone", provider.hasSafeItem((ItemLike)c.getBlock(""))).m_176500_(output, m.getId() + "_stone_" + type);
                }
                SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("cobble")}), (ItemLike)c.getBlock("cobble_slab"), (int)2).m_142284_("has_cobble", provider.hasSafeItem((ItemLike)c.getBlock("cobble"))).m_176500_(output, m.getId() + "_cobble_slab");
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("cobble")}), (ItemLike)c.getBlock("cobble_stairs")).m_142284_("has_cobble", provider.hasSafeItem((ItemLike)c.getBlock("cobble"))).m_176500_(output, m.getId() + "_cobble_stairs");
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("cobble")}), (ItemLike)c.getBlock("cobble_wall")).m_142284_("has_cobble", provider.hasSafeItem((ItemLike)c.getBlock("cobble"))).m_176500_(output, m.getId() + "_cobble_wall");
                SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("cobble_mossy")}), (ItemLike)c.getBlock("cobble_mossy_slab"), (int)2).m_142284_("has_cobble_mossy", provider.hasSafeItem((ItemLike)c.getBlock("cobble_mossy"))).m_176500_(output, m.getId() + "_cobble_mossy_slab");
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("cobble_mossy")}), (ItemLike)c.getBlock("cobble_mossy_stairs")).m_142284_("has_cobble_mossy", provider.hasSafeItem((ItemLike)c.getBlock("cobble_mossy"))).m_176500_(output, m.getId() + "_cobble_mossy_stairs");
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("cobble_mossy")}), (ItemLike)c.getBlock("cobble_mossy_wall")).m_142284_("has_cobble_mossy", provider.hasSafeItem((ItemLike)c.getBlock("cobble_mossy"))).m_176500_(output, m.getId() + "_cobble_mossy_wall");
                SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("bricks")}), (ItemLike)c.getBlock("bricks_slab"), (int)2).m_142284_("has_bricks", provider.hasSafeItem((ItemLike)c.getBlock("bricks"))).m_176500_(output, m.getId() + "_bricks_slab2");
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("bricks")}), (ItemLike)c.getBlock("bricks_stairs")).m_142284_("has_bricks", provider.hasSafeItem((ItemLike)c.getBlock("bricks"))).m_176500_(output, m.getId() + "_bricks_stairs2");
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("bricks")}), (ItemLike)c.getBlock("bricks_wall")).m_142284_("has_bricks", provider.hasSafeItem((ItemLike)c.getBlock("bricks"))).m_176500_(output, m.getId() + "_bricks_wall2");
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("bricks")}), (ItemLike)c.getBlock("bricks_chiseled")).m_142284_("has_bricks", provider.hasSafeItem((ItemLike)c.getBlock("bricks"))).m_176500_(output, m.getId() + "_bricks_chiseled2");
                SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("bricks_mossy")}), (ItemLike)c.getBlock("bricks_mossy_slab"), (int)2).m_142284_("has_bricks_mossy", provider.hasSafeItem((ItemLike)c.getBlock("bricks_mossy"))).m_176500_(output, m.getId() + "_bricks_mossy_slab");
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("bricks_mossy")}), (ItemLike)c.getBlock("bricks_mossy_stairs")).m_142284_("has_bricks_mossy", provider.hasSafeItem((ItemLike)c.getBlock("bricks_mossy"))).m_176500_(output, m.getId() + "_bricks_mossy_stairs");
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("bricks_mossy")}), (ItemLike)c.getBlock("bricks_mossy_wall")).m_142284_("has_bricks_mossy", provider.hasSafeItem((ItemLike)c.getBlock("bricks_mossy"))).m_176500_(output, m.getId() + "_bricks_mossy_wall");
                SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("smooth")}), (ItemLike)c.getBlock("smooth_slab"), (int)2).m_142284_("has_smooth", provider.hasSafeItem((ItemLike)c.getBlock("smooth"))).m_176500_(output, m.getId() + "_smooth_slab");
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("smooth")}), (ItemLike)c.getBlock("smooth_stairs")).m_142284_("has_smooth", provider.hasSafeItem((ItemLike)c.getBlock("smooth"))).m_176500_(output, m.getId() + "_smooth_stairs");
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("smooth")}), (ItemLike)c.getBlock("smooth_wall")).m_142284_("has_smooth", provider.hasSafeItem((ItemLike)c.getBlock("smooth"))).m_176500_(output, m.getId() + "_smooth_wall");
            }
        });
    }
}

