/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.datagen.loaders;

import com.google.common.collect.ImmutableMap;
import java.util.function.Consumer;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterDefaultTools;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.datagen.providers.AntimatterRecipeProvider;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.FluidPipe;
import muramasa.antimatter.pipe.types.ItemPipe;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class Pipes {
    public static void loadRecipes(Consumer<FinishedRecipe> consumer, AntimatterRecipeProvider provider) {
        CriterionTriggerInstance in = provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag());
        AntimatterAPI.all(ItemPipe.class, i -> {
            Material m = i.getMaterial();
            if (!m.has(AntimatterMaterialTypes.PLATE) || m == AntimatterMaterials.Wood) {
                return;
            }
            if (i.getSizes().contains((Object)PipeSize.TINY)) {
                provider.addStackRecipe(consumer, "antimatter", m.getId() + "_pipe_item_tiny", "antimatter_pipes", "has_wrench", in, new ItemStack((ItemLike)i.getBlock(PipeSize.TINY), 12), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('H'), AntimatterDefaultTools.HAMMER.getTag(), (Object)Character.valueOf('W'), AntimatterDefaultTools.WRENCH.getTag(), (Object)Character.valueOf('P'), AntimatterMaterialTypes.PLATE.getMaterialTag(m)), "PPP", "H W", "PPP");
            }
            if (i.getSizes().contains((Object)PipeSize.SMALL)) {
                provider.addStackRecipe(consumer, "antimatter", m.getId() + "_pipe_item_small", "antimatter_pipes", "has_wrench", in, new ItemStack((ItemLike)i.getBlock(PipeSize.SMALL), 6), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('H'), AntimatterDefaultTools.HAMMER.getTag(), (Object)Character.valueOf('W'), AntimatterDefaultTools.WRENCH.getTag(), (Object)Character.valueOf('P'), AntimatterMaterialTypes.PLATE.getMaterialTag(m)), "PWP", "P P", "PHP");
            }
            if (i.getSizes().contains((Object)PipeSize.NORMAL)) {
                provider.addStackRecipe(consumer, "antimatter", m.getId() + "_pipe_item_normal", "antimatter_pipes", "has_wrench", in, new ItemStack((ItemLike)i.getBlock(PipeSize.NORMAL), 3), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('H'), AntimatterDefaultTools.HAMMER.getTag(), (Object)Character.valueOf('W'), AntimatterDefaultTools.WRENCH.getTag(), (Object)Character.valueOf('P'), AntimatterMaterialTypes.PLATE.getMaterialTag(m)), "PPP", "W H", "PPP");
            }
            if (i.getSizes().contains((Object)PipeSize.LARGE)) {
                provider.addStackRecipe(consumer, "antimatter", m.getId() + "_pipe_item_large", "antimatter_pipes", "has_wrench", in, new ItemStack((ItemLike)i.getBlock(PipeSize.LARGE), 1), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('H'), AntimatterDefaultTools.HAMMER.getTag(), (Object)Character.valueOf('W'), AntimatterDefaultTools.WRENCH.getTag(), (Object)Character.valueOf('P'), AntimatterMaterialTypes.PLATE.getMaterialTag(m)), "PHP", "P P", "PWP");
            }
        });
        AntimatterAPI.all(FluidPipe.class, f -> {
            Material m = f.getMaterial();
            if (!m.has(AntimatterMaterialTypes.PLATE) || m == AntimatterMaterials.Wood) {
                return;
            }
            if (f.getSizes().contains((Object)PipeSize.TINY)) {
                provider.addStackRecipe(consumer, "antimatter", m.getId() + "_pipe_fluid_tiny", "antimatter_pipes", "has_wrench", in, new ItemStack((ItemLike)f.getBlock(PipeSize.TINY), 12), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('H'), AntimatterDefaultTools.HAMMER.getTag(), (Object)Character.valueOf('W'), AntimatterDefaultTools.WRENCH.getTag(), (Object)Character.valueOf('P'), AntimatterMaterialTypes.PLATE.getMaterialTag(m)), "PPP", "H W", "PPP");
            }
            if (f.getSizes().contains((Object)PipeSize.SMALL)) {
                provider.addStackRecipe(consumer, "antimatter", m.getId() + "_pipe_fluid_small", "antimatter_pipes", "has_wrench", in, new ItemStack((ItemLike)f.getBlock(PipeSize.SMALL), 6), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('H'), AntimatterDefaultTools.HAMMER.getTag(), (Object)Character.valueOf('W'), AntimatterDefaultTools.WRENCH.getTag(), (Object)Character.valueOf('P'), AntimatterMaterialTypes.PLATE.getMaterialTag(m)), "PWP", "P P", "PHP");
            }
            if (f.getSizes().contains((Object)PipeSize.NORMAL)) {
                provider.addStackRecipe(consumer, "antimatter", m.getId() + "_pipe_fluid_normal", "antimatter_pipes", "has_wrench", in, new ItemStack((ItemLike)f.getBlock(PipeSize.NORMAL), 3), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('H'), AntimatterDefaultTools.HAMMER.getTag(), (Object)Character.valueOf('W'), AntimatterDefaultTools.WRENCH.getTag(), (Object)Character.valueOf('P'), AntimatterMaterialTypes.PLATE.getMaterialTag(m)), "PPP", "W H", "PPP");
            }
            if (f.getSizes().contains((Object)PipeSize.LARGE)) {
                provider.addStackRecipe(consumer, "antimatter", m.getId() + "_pipe_fluid_large", "antimatter_pipes", "has_wrench", in, new ItemStack((ItemLike)f.getBlock(PipeSize.LARGE), 1), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('H'), AntimatterDefaultTools.HAMMER.getTag(), (Object)Character.valueOf('W'), AntimatterDefaultTools.WRENCH.getTag(), (Object)Character.valueOf('P'), AntimatterMaterialTypes.PLATE.getMaterialTag(m)), "PHP", "P P", "PWP");
            }
        });
    }
}

