/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.datagen.loaders;

import com.google.common.collect.ImmutableMap;
import java.util.function.Consumer;
import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.data.AntimatterDefaultTools;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.datagen.builder.AntimatterCookingRecipeBuilder;
import muramasa.antimatter.datagen.providers.AntimatterRecipeProvider;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.material.MaterialTypeItem;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MaterialRecipes {
    public static void init(Consumer<FinishedRecipe> consumer, AntimatterRecipeProvider provider) {
        CriterionTriggerInstance in = provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag());
        int craftingMultiplier = AntimatterConfig.GAMEPLAY.LOSSY_PART_CRAFTING ? 1 : 2;
        AntimatterMaterialTypes.DUST.all().forEach(m -> {
            provider.addStackRecipe(consumer, "antimatter", m.getId() + "_dust_small", "antimatter_dusts", "has_wrench", in, AntimatterMaterialTypes.DUST.get((Material)m, 1), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('D'), AntimatterMaterialTypes.DUST_SMALL.getMaterialTag((Material)m)), "DD", "DD");
            provider.addStackRecipe(consumer, "antimatter", m.getId() + "_dust_tiny", "antimatter_dusts", "has_wrench", in, AntimatterMaterialTypes.DUST.get((Material)m, 1), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('D'), AntimatterMaterialTypes.DUST_TINY.getMaterialTag((Material)m)), "DDD", "DDD", "DDD");
        });
        AntimatterMaterialTypes.INGOT.all().forEach(m -> {
            if (m.has(AntimatterMaterialTypes.NUGGET) && m != AntimatterMaterials.Iron && m != AntimatterMaterials.Gold) {
                provider.addItemRecipe(consumer, "antimatter", m.getId() + "_ingot", "ingots", "has_nugget", provider.hasSafeItem(AntimatterMaterialTypes.NUGGET.getMaterialTag((Material)m)), (ItemLike)AntimatterMaterialTypes.INGOT.get((Material)m), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('I'), AntimatterMaterialTypes.NUGGET.getMaterialTag((Material)m)), "III", "III", "III");
                provider.shapeless(consumer, "nugget_" + m.getId() + "_from_ingot", "ingots", "has_ingot", provider.hasSafeItem(AntimatterMaterialTypes.INGOT.getMaterialTag((Material)m)), AntimatterMaterialTypes.NUGGET.get((Material)m, 9), AntimatterMaterialTypes.INGOT.getMaterialTag((Material)m));
            }
        });
        AntimatterMaterialTypes.ROD.all().forEach(m -> {
            if (m.has(AntimatterMaterialTypes.INGOT)) {
                provider.addStackRecipe(consumer, "antimatter", m.getId() + "_rod", "antimatter_material", "has_wrench", in, AntimatterMaterialTypes.ROD.get((Material)m, craftingMultiplier), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('F'), AntimatterDefaultTools.FILE.getTag(), (Object)Character.valueOf('I'), AntimatterMaterialTypes.INGOT.getMaterialTag((Material)m)), "F", "I");
            }
            if (m.has(AntimatterMaterialTypes.BOLT)) {
                provider.addStackRecipe(consumer, "antimatter", m.getId() + "_bolt", "antimatter_material", "has_wrench", in, AntimatterMaterialTypes.BOLT.get((Material)m, 2 * craftingMultiplier), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('F'), AntimatterDefaultTools.SAW.getTag(), (Object)Character.valueOf('I'), AntimatterMaterialTypes.ROD.getMaterialTag((Material)m)), "F ", " I");
                if (m.has(AntimatterMaterialTypes.SCREW)) {
                    String[] stringArray;
                    if (AntimatterConfig.GAMEPLAY.LOSSY_PART_CRAFTING) {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = "FI";
                        stringArray = stringArray2;
                        stringArray2[1] = "I ";
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = "F";
                        stringArray = stringArray3;
                        stringArray3[1] = "I";
                    }
                    String[] pattern = stringArray;
                    provider.addStackRecipe(consumer, "antimatter", m.getId() + "_screw", "antimatter_material", "has_wrench", in, AntimatterMaterialTypes.SCREW.get((Material)m, 1), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('F'), AntimatterDefaultTools.FILE.getTag(), (Object)Character.valueOf('I'), AntimatterMaterialTypes.BOLT.getMaterialTag((Material)m)), pattern);
                }
            }
            if (m.has(AntimatterMaterialTypes.RING) && !m.has(MaterialTags.NOSMASH)) {
                provider.addStackRecipe(consumer, "antimatter", m.getId() + "_ring", "antimatter_material", "has_hammer", provider.hasSafeItem(AntimatterDefaultTools.HAMMER.getTag()), AntimatterMaterialTypes.RING.get((Material)m, craftingMultiplier), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('H'), AntimatterDefaultTools.HAMMER.getTag(), (Object)Character.valueOf('W'), AntimatterMaterialTypes.ROD.getMaterialTag((Material)m)), "H ", " W");
            }
            if (m.has(AntimatterMaterialTypes.ROD_LONG)) {
                provider.addStackRecipe(consumer, "antimatter", m.getId() + "_rod_from_long_rod", "rods", "has_saw", provider.hasSafeItem(AntimatterDefaultTools.SAW.getTag()), AntimatterMaterialTypes.ROD.get((Material)m, 2), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), AntimatterDefaultTools.SAW.getTag(), (Object)Character.valueOf('R'), AntimatterMaterialTypes.ROD_LONG.getMaterialTag((Material)m)), "SR");
                if (!m.has(MaterialTags.NOSMASH)) {
                    provider.addStackRecipe(consumer, "antimatter", "", "rods", "has_hammer", provider.hasSafeItem(AntimatterDefaultTools.HAMMER.getTag()), AntimatterMaterialTypes.ROD_LONG.get((Material)m, 1), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), AntimatterDefaultTools.HAMMER.getTag(), (Object)Character.valueOf('R'), AntimatterMaterialTypes.ROD.getMaterialTag((Material)m)), "RSR");
                }
            }
        });
        AntimatterMaterialTypes.ROTOR.all().forEach(m -> provider.addStackRecipe(consumer, "antimatter", m.getId() + "_rotors", "antimatter_material", "has_screwdriver", provider.hasSafeItem(AntimatterDefaultTools.SCREWDRIVER.getTag()), AntimatterMaterialTypes.ROTOR.get((Material)m, 1), (ImmutableMap<Character, Object>)ImmutableMap.builder().put((Object)Character.valueOf('S'), AntimatterDefaultTools.SCREWDRIVER.getTag()).put((Object)Character.valueOf('F'), AntimatterDefaultTools.FILE.getTag()).put((Object)Character.valueOf('H'), AntimatterDefaultTools.HAMMER.getTag()).put((Object)Character.valueOf('P'), AntimatterMaterialTypes.PLATE.getMaterialTag((Material)m)).put((Object)Character.valueOf('W'), AntimatterMaterialTypes.SCREW.getMaterialTag((Material)m)).put((Object)Character.valueOf('R'), AntimatterMaterialTypes.RING.getMaterialTag((Material)m)).build(), "PHP", "WRF", "PSP"));
        AntimatterMaterialTypes.PLATE.all().forEach(m -> {
            if (!m.has(MaterialTags.NOSMASH)) {
                if (m.has(AntimatterMaterialTypes.INGOT)) {
                    Object[] objectArray;
                    if (AntimatterConfig.GAMEPLAY.LOSSY_PART_CRAFTING) {
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = AntimatterDefaultTools.HAMMER.getTag();
                        objectArray2[1] = AntimatterMaterialTypes.INGOT.getMaterialTag((Material)m);
                        objectArray = objectArray2;
                        objectArray2[2] = AntimatterMaterialTypes.INGOT.getMaterialTag((Material)m);
                    } else {
                        Object[] objectArray3 = new Object[2];
                        objectArray3[0] = AntimatterDefaultTools.HAMMER.getTag();
                        objectArray = objectArray3;
                        objectArray3[1] = AntimatterMaterialTypes.INGOT.getMaterialTag((Material)m);
                    }
                    Object[] array = objectArray;
                    provider.shapeless(consumer, "", "antimatter_material", "has_hammer", provider.hasSafeItem(AntimatterDefaultTools.HAMMER.getTag()), AntimatterMaterialTypes.PLATE.get((Material)m, 1), array);
                }
                if (m.has(AntimatterMaterialTypes.GEAR_SMALL)) {
                    provider.addStackRecipe(consumer, "antimatter", "", "antimatter_material", "has_hammer", provider.hasSafeItem(AntimatterDefaultTools.HAMMER.getTag()), AntimatterMaterialTypes.GEAR_SMALL.get((Material)m, 1), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('H'), AntimatterDefaultTools.HAMMER.getTag(), (Object)Character.valueOf('P'), AntimatterMaterialTypes.PLATE.getMaterialTag((Material)m)), "P ", " H");
                }
                if (m.has(AntimatterMaterialTypes.ITEM_CASING)) {
                    provider.addStackRecipe(consumer, "antimatter", "", "antimatter_material", "has_hammer", provider.hasSafeItem(AntimatterDefaultTools.HAMMER.getTag()), AntimatterMaterialTypes.ITEM_CASING.get((Material)m, 1), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('H'), AntimatterDefaultTools.HAMMER.getTag(), (Object)Character.valueOf('P'), AntimatterMaterialTypes.PLATE.getMaterialTag((Material)m)), "H P");
                }
                if (m.has(AntimatterMaterialTypes.FOIL)) {
                    provider.addStackRecipe(consumer, "antimatter", "", "antimatter_materials", "has_hammer", provider.hasSafeItem(AntimatterDefaultTools.HAMMER.getTag()), AntimatterMaterialTypes.FOIL.get((Material)m, 2), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('H'), AntimatterDefaultTools.HAMMER.getTag(), (Object)Character.valueOf('P'), AntimatterMaterialTypes.PLATE.getMaterialTag((Material)m)), "HP");
                    if (m.has(AntimatterMaterialTypes.WIRE_FINE)) {
                        provider.addItemRecipe(consumer, "antimatter", "", "antimatter_materials", "has_wire_cutters", provider.hasSafeItem(AntimatterDefaultTools.WIRE_CUTTER.getTag()), (ItemLike)AntimatterMaterialTypes.WIRE_FINE.get((Material)m), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('F'), AntimatterMaterialTypes.FOIL.getMaterialTag((Material)m), (Object)Character.valueOf('W'), AntimatterDefaultTools.WIRE_CUTTER.getTag()), "FW");
                    }
                }
            }
            if (m.has(AntimatterMaterialTypes.GEAR)) {
                provider.addStackRecipe(consumer, "antimatter", m.getId() + "_gear", "antimatter_material", "has_hammer", provider.hasSafeItem(AntimatterDefaultTools.HAMMER.getTag()), AntimatterMaterialTypes.GEAR.get((Material)m, 1), (ImmutableMap<Character, Object>)ImmutableMap.builder().put((Object)Character.valueOf('W'), AntimatterDefaultTools.WRENCH.getTag()).put((Object)Character.valueOf('P'), AntimatterMaterialTypes.PLATE.getMaterialTag((Material)m)).put((Object)Character.valueOf('R'), AntimatterMaterialTypes.ROD.getMaterialTag((Material)m)).build(), "RPR", "PWP", "RPR");
            }
            if (m.has(AntimatterMaterialTypes.RING) && m.has(MaterialTags.RUBBERTOOLS)) {
                provider.addStackRecipe(consumer, "antimatter", m.getId() + "_ring", "antimatter_material", "has_wire_cutter", provider.hasSafeItem(AntimatterDefaultTools.WIRE_CUTTER.getTag()), AntimatterMaterialTypes.RING.get((Material)m, craftingMultiplier), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('H'), AntimatterDefaultTools.WIRE_CUTTER.getTag(), (Object)Character.valueOf('W'), AntimatterMaterialTypes.PLATE.getMaterialTag((Material)m)), "H ", " W");
            }
        });
        AntimatterMaterialTypes.DUST.all().forEach(m -> {
            if (m.has(AntimatterMaterialTypes.INGOT)) {
                provider.addStackRecipe(consumer, "antimatter", m.getId() + "_grind_ingot", "antimatter_material", "has_hammer", provider.hasSafeItem(AntimatterDefaultTools.HAMMER.getTag()), AntimatterMaterialTypes.DUST.get((Material)m, 1), (ImmutableMap<Character, Object>)ImmutableMap.builder().put((Object)Character.valueOf('M'), AntimatterDefaultTools.MORTAR.getTag()).put((Object)Character.valueOf('I'), AntimatterMaterialTypes.INGOT.getMaterialTag((Material)m)).build(), "MI");
            }
            if (m.has(AntimatterMaterialTypes.ROCK)) {
                provider.addStackRecipe(consumer, "antimatter", m.getId() + "_grind_rock", "antimatter_material", "has_mortar", provider.hasSafeItem(AntimatterDefaultTools.MORTAR.getTag()), AntimatterMaterialTypes.DUST.get((Material)m, 1), (ImmutableMap<Character, Object>)ImmutableMap.builder().put((Object)Character.valueOf('M'), AntimatterDefaultTools.MORTAR.getTag()).put((Object)Character.valueOf('I'), AntimatterMaterialTypes.ROCK.getMaterialTag((Material)m)).build(), "II ", "IIM");
                provider.shapeless(consumer, m.getId() + "_grind_rock_2", "antimatter_material", "has_mortar", provider.hasSafeItem(AntimatterDefaultTools.MORTAR.getTag()), AntimatterMaterialTypes.DUST_SMALL.get((Material)m, 1), AntimatterDefaultTools.MORTAR.getTag(), AntimatterMaterialTypes.ROCK.getMaterialTag((Material)m));
            }
            if (m.has(AntimatterMaterialTypes.CRUSHED)) {
                provider.shapeless(consumer, m.getId() + "_grind_crushed", "antimatter_material", "has_mortar", provider.hasSafeItem(AntimatterDefaultTools.MORTAR.getTag()), AntimatterMaterialTypes.DUST_IMPURE.get((Material)m, 1), AntimatterDefaultTools.MORTAR.getTag(), AntimatterMaterialTypes.CRUSHED.getMaterialTag((Material)m));
            }
        });
        AntimatterMaterialTypes.RAW_ORE.all().stream().filter(m -> !m.has(MaterialTags.HAS_CUSTOM_SMELTING) && MaterialTags.SMELT_INTO.getMapping((Material)m).has(AntimatterMaterialTypes.INGOT) && !m.has(MaterialTags.HAS_CUSTOM_SMELTING)).forEach(m -> {
            if (m != AntimatterMaterials.Iron && m != AntimatterMaterials.Copper && m != AntimatterMaterials.Gold) {
                MaterialRecipes.addSmeltingRecipe(consumer, provider, AntimatterMaterialTypes.RAW_ORE, AntimatterMaterialTypes.INGOT, 1, m, MaterialTags.SMELT_INTO.getMapping((Material)m));
            }
            MaterialRecipes.addSmeltingRecipe(consumer, provider, AntimatterMaterialTypes.ORE, AntimatterMaterialTypes.INGOT, 1, m, MaterialTags.SMELT_INTO.getMapping((Material)m));
            if (m != MaterialTags.SMELT_INTO.getMapping((Material)m) || !m.has(AntimatterMaterialTypes.NUGGET)) {
                return;
            }
            MaterialRecipes.addSmeltingRecipe(consumer, provider, AntimatterMaterialTypes.CRUSHED, AntimatterMaterialTypes.NUGGET, 12, m);
            MaterialRecipes.addSmeltingRecipe(consumer, provider, AntimatterMaterialTypes.DUST_IMPURE, AntimatterMaterialTypes.INGOT, 1, m);
            MaterialRecipes.addSmeltingRecipe(consumer, provider, AntimatterMaterialTypes.CRUSHED_PURIFIED, AntimatterMaterialTypes.NUGGET, 11, m);
            MaterialRecipes.addSmeltingRecipe(consumer, provider, AntimatterMaterialTypes.DUST_PURE, AntimatterMaterialTypes.INGOT, 1, m);
            MaterialRecipes.addSmeltingRecipe(consumer, provider, AntimatterMaterialTypes.CRUSHED_REFINED, AntimatterMaterialTypes.NUGGET, 10, m);
        });
        AntimatterMaterialTypes.DUST.all().forEach(m -> {
            if (m.has(MaterialTags.HAS_CUSTOM_SMELTING)) {
                return;
            }
            if (!MaterialTags.DIRECT_SMELT_INTO.getMapping((Material)m).has(AntimatterMaterialTypes.INGOT)) {
                return;
            }
            MaterialRecipes.addSmeltingRecipe(consumer, provider, AntimatterMaterialTypes.DUST, AntimatterMaterialTypes.INGOT, 1, m, MaterialTags.DIRECT_SMELT_INTO.getMapping((Material)m));
        });
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> consumer, AntimatterRecipeProvider provider, MaterialType<?> input, MaterialTypeItem<?> output, int amount, Material in) {
        MaterialRecipes.addSmeltingRecipe(consumer, provider, input, output, amount, in, in);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> consumer, AntimatterRecipeProvider provider, MaterialType<?> input, MaterialTypeItem<?> output, int amount, Material in, Material out) {
        AntimatterCookingRecipeBuilder.blastingRecipe(RecipeIngredient.of(input.getMaterialTag(in), 1), new ItemStack((ItemLike)output.get(out), MaterialTags.SMELTING_MULTI.getInt(in) * amount), 2.0f, 100).addCriterion("has_material_" + in.getId(), provider.hasSafeItem(output.getMaterialTag(out))).build(consumer, provider.fixLoc("antimatter", in.getId().concat("_" + input.getId() + "_to_" + output.getId())));
        AntimatterCookingRecipeBuilder.smeltingRecipe(RecipeIngredient.of(input.getMaterialTag(in), 1), new ItemStack((ItemLike)output.get(out), MaterialTags.SMELTING_MULTI.getInt(in) * amount), 2.0f, 200).addCriterion("has_material_" + in.getId(), provider.hasSafeItem(output.getMaterialTag(out))).build(consumer, provider.fixLoc("antimatter", in.getId().concat("_" + input.getId() + "_to_" + output.getId() + "_smelting")));
    }
}

