/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.datagen.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import muramasa.antimatter.datagen.builder.IModelLocation;
import muramasa.antimatter.datagen.builder.IStateBuilder;
import net.devtech.arrp.json.blockstate.JBlockModel;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.blockstate.JVariant;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class VariantBlockStateBuilder
implements IStateBuilder {
    private final Block owner;
    JState state = JState.state();

    public VariantBlockStateBuilder(Block owner) {
        this.owner = owner;
    }

    @Override
    public JState toState() {
        return this.state;
    }

    public VariantBlockStateBuilder wildcard(VariantBuilder builder) {
        this.state.add(new JVariant().put("", builder.model));
        return this;
    }

    public VariantBlockStateBuilder forAllStates(Function<BlockState, VariantBuilder> mapper) {
        return this.forAllStatesExcept(mapper, new Property[0]);
    }

    public VariantBlockStateBuilder forAllStatesExcept(Function<BlockState, VariantBuilder> mapper, Property<?> ... ignored) {
        JVariant variant = new JVariant();
        for (BlockState fullState : this.owner.m_49965_().m_61056_()) {
            LinkedHashMap propertyValues = Maps.newLinkedHashMap((Map)fullState.m_61148_());
            for (Property<?> p2 : ignored) {
                propertyValues.remove(p2);
            }
            JBlockModel model = mapper.apply((BlockState)fullState).model;
            StringBuilder ret = new StringBuilder();
            propertyValues.forEach((p, c) -> {
                if (ret.length() > 0) {
                    ret.append(',');
                }
                ret.append(p.m_61708_()).append('=').append(p.m_6940_(c));
            });
            variant.put(ret.toString(), model);
        }
        this.state.add(variant);
        return this;
    }

    public static class VariantBuilder {
        JBlockModel model = null;

        public VariantBuilder modelFile(IModelLocation model) {
            Preconditions.checkNotNull((Object)model, (Object)"Model must not be null");
            this.model = new JBlockModel(model.getLocation());
            return this;
        }

        public VariantBuilder modelFile(ResourceLocation location) {
            Preconditions.checkNotNull((Object)location, (Object)"Model must not be null");
            this.model = new JBlockModel(location);
            return this;
        }

        public VariantBuilder rotationX(int value) {
            Preconditions.checkNotNull((Object)this.model, (Object)"modelFile must be called first");
            this.model.x(value);
            return this;
        }

        public VariantBuilder rotationY(int value) {
            Preconditions.checkNotNull((Object)this.model, (Object)"modelFile must be called first");
            this.model.y(value);
            return this;
        }

        public VariantBuilder uvLock() {
            Preconditions.checkNotNull((Object)this.model, (Object)"modelFile must be called first");
            this.model.uvlock();
            return this;
        }

        public VariantBuilder uvLock(boolean uv) {
            Preconditions.checkNotNull((Object)this.model, (Object)"modelFile must be called first");
            if (uv) {
                this.model.uvlock();
            }
            return this;
        }

        public VariantBuilder weight(int value) {
            Preconditions.checkNotNull((Object)this.model, (Object)"modelFile must be called first");
            this.model.weight(value);
            return this;
        }
    }
}

