/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.datagen;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import dev.latvian.mods.kubejs.script.ScriptType;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import muramasa.antimatter.Antimatter;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.datagen.DynamicDataPack;
import muramasa.antimatter.datagen.IAntimatterProvider;
import muramasa.antimatter.datagen.ICraftingLoader;
import muramasa.antimatter.datagen.json.JAntimatterModel;
import muramasa.antimatter.datagen.providers.AntimatterBlockLootProvider;
import muramasa.antimatter.datagen.providers.AntimatterLanguageProvider;
import muramasa.antimatter.datagen.providers.AntimatterRecipeProvider;
import muramasa.antimatter.datagen.providers.AntimatterTagProvider;
import muramasa.antimatter.event.CraftingEvent;
import muramasa.antimatter.event.ProvidersEvent;
import muramasa.antimatter.integration.kubejs.AMWorldEvent;
import muramasa.antimatter.integration.kubejs.KubeJSRegistrar;
import muramasa.antimatter.integration.kubejs.RecipeLoaderEventKubeJS;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.recipe.loader.IRecipeRegistrate;
import muramasa.antimatter.recipe.map.IRecipeMap;
import muramasa.antimatter.recipe.map.RecipeBuilder;
import muramasa.antimatter.recipe.map.RecipeMap;
import muramasa.antimatter.registration.IAntimatterRegistrar;
import muramasa.antimatter.registration.ModRegistrar;
import muramasa.antimatter.registration.Side;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.antimatter.worldgen.AntimatterWorldGenerator;
import muramasa.antimatter.worldgen.StoneLayerOre;
import muramasa.antimatter.worldgen.object.WorldGenStoneLayer;
import muramasa.antimatter.worldgen.smallore.WorldGenSmallOre;
import muramasa.antimatter.worldgen.vanillaore.WorldGenVanillaOre;
import muramasa.antimatter.worldgen.vein.WorldGenVeinLayer;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.loot.JCondition;
import net.devtech.arrp.json.models.JTextures;
import net.devtech.arrp.util.UnsafeByteArrayOutputStream;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.storage.loot.Deserializers;

public class AntimatterDynamics {
    public static final RuntimeResourcePack DYNAMIC_RESOURCE_PACK = RuntimeResourcePack.create((ResourceLocation)new ResourceLocation("antimatter", "dynamic"));
    public static final RuntimeResourcePack RUNTIME_DATA_PACK = RuntimeResourcePack.create((ResourceLocation)new ResourceLocation("antimatter", "data"), (int)8);
    public static final Gson GSON = Deserializers.m_78800_().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(Advancement.Builder.class, (src, typeOfSrc, context) -> src.m_138400_()).registerTypeAdapter(FinishedRecipe.class, (src, typeOfSrc, context) -> src.m_125966_()).registerTypeAdapter(JAntimatterModel.class, (Object)new JAntimatterModel.JAntimatterModelSerializer()).registerTypeAdapter(JTextures.class, (Object)new JTextures.Serializer()).registerTypeAdapter(JCondition.class, (Object)new JCondition.Serializer()).create();
    private static final boolean exportPack = true;
    private static boolean initialized = false;
    public static final Set<ResourceLocation> RECIPE_IDS = Sets.newHashSet();
    public static final Consumer<FinishedRecipe> FINISHED_RECIPE_CONSUMER = f -> {
        if (RECIPE_IDS.add(f.m_6445_())) {
            DynamicDataPack.addRecipe(f);
        } else {
            Antimatter.LOGGER.catching((Throwable)new RuntimeException("Recipe duplicated: " + f.m_6445_()));
        }
    };
    private static final Object2ObjectOpenHashMap<String, List<Supplier<IAntimatterProvider>>> PROVIDERS = new Object2ObjectOpenHashMap();

    public static void addResourcePacks(Consumer<PackResources> function) {
        if (initialized) {
            AntimatterAPI.all(Material.class, Material::setChemicalFormula);
        }
        function.accept((PackResources)DYNAMIC_RESOURCE_PACK);
    }

    public static void setInitialized() {
        initialized = true;
    }

    public static void addDataPacks(Consumer<PackResources> function) {
        if (initialized) {
            AntimatterDynamics.onResourceReload(AntimatterAPI.getSIDE().isServer());
        }
        function.accept((PackResources)RUNTIME_DATA_PACK);
        function.accept(new DynamicDataPack("antimatter:recipes", AntimatterAPI.all(IAntimatterRegistrar.class).stream().map(IAntimatterRegistrar::getDomain).collect(Collectors.toSet())));
    }

    public static void onProviderInit(String domain, DataGenerator gen, Side side) {
        if (side == Side.CLIENT) {
            ((List)PROVIDERS.getOrDefault((Object)domain, Collections.emptyList())).stream().map(Supplier::get).filter(p -> p instanceof AntimatterLanguageProvider).forEach(arg_0 -> ((DataGenerator)gen).m_123914_(arg_0));
        }
    }

    public static void clientProvider(String domain, Supplier<IAntimatterProvider> providerFunc) {
        ((List)PROVIDERS.computeIfAbsent((Object)domain, k -> new ObjectArrayList())).add(providerFunc);
    }

    public static void runDataProvidersDynamically() {
        AntimatterBlockLootProvider.init();
        ProvidersEvent ev = AntimatterPlatformUtils.postProviderEvent(AntimatterAPI.getSIDE(), Antimatter.INSTANCE);
        Collection<IAntimatterProvider> providers = ev.getProviders();
        long time = System.currentTimeMillis();
        Stream async = (Stream)providers.stream().filter(IAntimatterProvider::async).parallel();
        Stream<IAntimatterProvider> sync = providers.stream().filter(t -> !t.async());
        Stream.concat(async, sync).forEach(IAntimatterProvider::run);
        providers.forEach(IAntimatterProvider::onCompletion);
        AntimatterTagProvider.afterCompletion();
        Antimatter.LOGGER.info("Time to run data providers: " + (System.currentTimeMillis() - time) + " ms.");
        if (AntimatterConfig.GAMEPLAY.EXPORT_DEFAULT_RECIPES || !AntimatterPlatformUtils.isProduction()) {
            RUNTIME_DATA_PACK.dump(AntimatterPlatformUtils.getConfigDir().getParent().resolve("dumped"));
        }
    }

    public static void runAssetProvidersDynamically() {
        List providers = PROVIDERS.object2ObjectEntrySet().stream().flatMap(v -> ((List)v.getValue()).stream().map(Supplier::get)).toList();
        long time = System.currentTimeMillis();
        Stream async = (Stream)providers.stream().filter(IAntimatterProvider::async).parallel();
        Stream<IAntimatterProvider> sync = providers.stream().filter(t -> !t.async());
        Stream.concat(async, sync).forEach(IAntimatterProvider::run);
        providers.forEach(IAntimatterProvider::onCompletion);
        AntimatterLanguageProvider.postCompletion();
        Antimatter.LOGGER.info("Time to run asset providers: " + (System.currentTimeMillis() - time) + " ms.");
        if (!AntimatterPlatformUtils.isProduction()) {
            DYNAMIC_RESOURCE_PACK.dump(AntimatterPlatformUtils.getConfigDir().getParent().resolve("dumped"));
        }
    }

    public static void collectRecipes(AntimatterRecipeProvider provider, Consumer<FinishedRecipe> rec) {
        CraftingEvent ev = AntimatterPlatformUtils.postCraftingEvent(Antimatter.INSTANCE);
        for (ICraftingLoader loader : ev.getLoaders()) {
            loader.loadRecipes(rec, provider);
        }
    }

    public static void onRecipeManagerBuild(Consumer<FinishedRecipe> objectIn) {
        Antimatter.LOGGER.info("Antimatter recipe manager running..");
        AntimatterDynamics.collectRecipes(new AntimatterRecipeProvider("antimatter", "provider"), objectIn);
        AntimatterAPI.all(ModRegistrar.class, t -> {
            for (String mod : t.modIds()) {
                if (AntimatterAPI.isModLoaded(mod)) continue;
                return;
            }
            t.craftingRecipes(new AntimatterRecipeProvider("Antimatter", "Custom recipes"));
        });
        Antimatter.LOGGER.info("Antimatter recipe manager done..");
    }

    public static void onRecipeCompile(boolean server, RecipeManager manager) {
        Antimatter.LOGGER.info("Compiling GT recipes");
        long time = System.nanoTime();
        for (RecipeMap m : AntimatterAPI.all(RecipeMap.class)) {
            if (m.getProxy() == null) continue;
            List recipes = manager.m_44013_(m.getProxy().loc());
            recipes.forEach(recipe -> m.compileRecipe(m.getProxy().handler().apply((Recipe<?>)recipe, (RecipeBuilder)m.RB())));
        }
        List recipes = manager.m_44013_(muramasa.antimatter.recipe.Recipe.RECIPE_TYPE);
        Map<String, List<IRecipe>> map = recipes.stream().collect(Collectors.groupingBy(IRecipe::getMapId));
        for (Map.Entry entry : map.entrySet()) {
            IRecipeMap rmap;
            String name;
            String[] split = ((String)entry.getKey()).split(":");
            if (split.length == 2) {
                name = split[1];
            } else {
                if (split.length != 1) continue;
                name = split[0];
            }
            if ((rmap = AntimatterAPI.get(IRecipeMap.class, name)) == null) continue;
            ((List)entry.getValue()).forEach(rmap::compileRecipe);
        }
        time = System.nanoTime() - time;
        int size = AntimatterAPI.all(IRecipeMap.class).stream().mapToInt(t -> t.getRecipes(false).size()).sum();
        Antimatter.LOGGER.info("Time to compile GT recipes: (ms) " + time / 1000000L);
        Antimatter.LOGGER.info("No. of GT recipes: " + size);
        Antimatter.LOGGER.info("Average loading time / recipe: (\u00b5s) " + (size > 0 ? time / (long)size : time) / 1000L);
    }

    public static void onResourceReload(boolean serverEvent) {
        Object ev;
        Set<Object> filter;
        AntimatterRecipeProvider provider = new AntimatterRecipeProvider("antimatter", "provider");
        DynamicDataPack.clearServer();
        RECIPE_IDS.clear();
        AntimatterDynamics.collectRecipes(provider, FINISHED_RECIPE_CONSUMER);
        AntimatterAPI.all(RecipeMap.class, RecipeMap::reset);
        if (AntimatterAPI.isModLoaded("kubejs")) {
            if (serverEvent) {
                KubeJSRegistrar.checkKubeJSServerScriptManager();
            }
            RecipeLoaderEventKubeJS ev2 = RecipeLoaderEventKubeJS.createAndPost(serverEvent);
            filter = ev2.forLoaders;
        } else {
            filter = Collections.emptySet();
        }
        Object2ObjectOpenHashMap loaders = new Object2ObjectOpenHashMap(30);
        AntimatterPlatformUtils.postLoaderEvent(Antimatter.INSTANCE, (arg_0, arg_1, arg_2) -> AntimatterDynamics.lambda$onResourceReload$11(filter, (Map)loaders, arg_0, arg_1, arg_2));
        ObjectArrayList veins = new ObjectArrayList();
        ObjectArrayList stoneLayers = new ObjectArrayList();
        ObjectArrayList smallOres = new ObjectArrayList();
        ObjectArrayList vanillaOres = new ObjectArrayList();
        Int2ObjectOpenHashMap collisionMap = new Int2ObjectOpenHashMap();
        boolean runRegular = true;
        WorldGenVeinLayer.resetTotalWeight();
        if (AntimatterAPI.isModLoaded("kubejs") && serverEvent) {
            ev = new AMWorldEvent();
            ev.post(ScriptType.SERVER, "antimatter.worldgen");
            veins.addAll(((AMWorldEvent)((Object)ev)).VEINS);
            stoneLayers.addAll(((AMWorldEvent)((Object)ev)).STONE_LAYERS);
            collisionMap.putAll(((AMWorldEvent)((Object)ev)).COLLISION_MAP);
            boolean bl = runRegular = !((AMWorldEvent)((Object)ev)).disableBuiltin;
        }
        if (runRegular) {
            ev = AntimatterPlatformUtils.postWorldEvent(Antimatter.INSTANCE);
            veins.addAll(ev.VEINS);
            smallOres.addAll(ev.SMALL_ORES);
            stoneLayers.addAll(ev.STONE_LAYERS);
            vanillaOres.addAll(ev.VANILLA_ORES);
            ev.COLLISION_MAP.forEach((i, l) -> ((List)collisionMap.computeIfAbsent(i, i2 -> new ArrayList())).addAll(l));
        }
        AntimatterWorldGenerator.clear();
        for (WorldGenVeinLayer vein : veins) {
            AntimatterWorldGenerator.register(vein.toRegister, vein);
        }
        for (WorldGenStoneLayer stoneLayer : stoneLayers) {
            AntimatterWorldGenerator.register(stoneLayer.toRegister, stoneLayer);
        }
        WorldGenStoneLayer.setCollisionMap((Int2ObjectOpenHashMap<List<StoneLayerOre>>)collisionMap);
        for (WorldGenSmallOre smallOre : smallOres) {
            AntimatterWorldGenerator.register(smallOre.toRegister, smallOre);
        }
        for (WorldGenVanillaOre vanillaOre : vanillaOres) {
            AntimatterWorldGenerator.register(vanillaOre.toRegister, vanillaOre);
        }
        if (AntimatterConfig.WORLD.REGENERATE_DEFAULT_WORLDGEN_JSONS) {
            AntimatterConfig.COMMON_CONFIG.REGENERATE_DEFAULT_WORLDGEN_JSONS.set((Object)false);
        }
        loaders.forEach((r, l) -> {
            RecipeBuilder.setCurrentModId(r.m_135827_());
            l.init();
            RecipeBuilder.setCurrentModId("antimatter_shared");
        });
        AntimatterAPI.all(ModRegistrar.class, t -> {
            for (String mod : t.modIds()) {
                if (AntimatterAPI.isModLoaded(mod)) continue;
                return;
            }
        });
        Antimatter.LOGGER.info("Amount of Antimatter Recipe Loaders registered: " + loaders.size());
    }

    public static ResourceLocation getTagLoc(String identifier, ResourceLocation tagId) {
        return new ResourceLocation(tagId.m_135827_(), String.join((CharSequence)"", identifier, "/", tagId.m_135815_()));
    }

    public static byte[] serialize(Object object) {
        UnsafeByteArrayOutputStream ubaos = new UnsafeByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)ubaos);
        GSON.toJson(object, (Appendable)writer);
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ubaos.getBytes();
    }

    public static ResourceLocation fix(ResourceLocation identifier, String prefix, String append) {
        return new ResourceLocation(identifier.m_135827_(), prefix + "/" + identifier.m_135815_() + "." + append);
    }

    private static /* synthetic */ void lambda$onResourceReload$11(Set filter, Map loaders, String a, String b, IRecipeRegistrate.IRecipeLoader c) {
        if (filter.contains(new ResourceLocation(a, b))) {
            return;
        }
        if (loaders.put(new ResourceLocation(a, b), c) != null) {
            Antimatter.LOGGER.warn("Duplicate recipe loader: " + new ResourceLocation(a, b));
        }
    }
}

