/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.data;

import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.block.BlockStorage;
import muramasa.antimatter.block.BlockSurfaceRock;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.cover.CoverPlate;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.data.AntimatterStoneTypes;
import muramasa.antimatter.fluid.AntimatterFluid;
import muramasa.antimatter.fluid.AntimatterMaterialFluid;
import muramasa.antimatter.item.CoverMaterialItem;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialItem;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.material.MaterialTypeBlock;
import muramasa.antimatter.material.MaterialTypeFluid;
import muramasa.antimatter.material.MaterialTypeItem;
import muramasa.antimatter.ore.BlockOre;
import muramasa.antimatter.ore.BlockOreStone;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.util.Utils;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import tesseract.FluidPlatformUtils;

public class AntimatterMaterialTypes {
    public static MaterialTypeItem<?> DUST = new MaterialTypeItem("dust", 2, true, 18144000L);
    public static MaterialTypeItem<?> DUST_SMALL = new MaterialTypeItem("dust_small", 2, true, 4536000L);
    public static MaterialTypeItem<?> DUST_TINY = new MaterialTypeItem("dust_tiny", 2, true, 2016000L);
    public static MaterialTypeItem<?> DUST_IMPURE = new MaterialTypeItem("dust_impure", 2, true, 18144000L);
    public static MaterialTypeItem<?> DUST_PURE = new MaterialTypeItem("dust_pure", 2, true, 18144000L);
    public static MaterialTypeItem<MaterialTypeBlock.IOreGetter> ROCK = new MaterialTypeItem("rock", 2, false, 2016000L, (domain, type, mat) -> {
        AntimatterAPI.all(StoneType.class).stream().filter(StoneType::doesGenerateOre).forEach(s -> AntimatterAPI.register(BlockSurfaceRock.class, new BlockSurfaceRock(domain, mat, (StoneType)s)));
        new MaterialItem(domain, type, mat);
    });
    public static MaterialTypeItem<?> CRUSHED = new MaterialTypeItem("crushed", 2, true, 18144000L);
    public static MaterialTypeItem<?> CRUSHED_REFINED = new MaterialTypeItem("crushed_refined", 2, true, 18144000L);
    public static MaterialTypeItem<?> CRUSHED_PURIFIED = new MaterialTypeItem("crushed_purified", 2, true, 18144000L);
    public static MaterialTypeItem<?> RAW_ORE = new MaterialTypeItem("raw_ore", 2, true, -1L);
    public static MaterialTypeItem<?> INGOT = new MaterialTypeItem("ingot", 2, true, 18144000L);
    public static MaterialTypeItem<?> INGOT_HOT = new MaterialTypeItem("ingot_hot", 2, true, 18144000L);
    public static MaterialTypeItem<?> NUGGET = new MaterialTypeItem("nugget", 2, true, 2016000L);
    public static MaterialTypeItem<?> GEM = new MaterialTypeItem("gem", 2, true, 18144000L);
    public static MaterialTypeItem<?> GEM_BRITTLE = new MaterialTypeItem("gem_brittle", 2, true, 18144000L);
    public static MaterialTypeItem<?> GEM_POLISHED = new MaterialTypeItem("gem_polished", 2, true, 18144000L);
    public static MaterialTypeItem<?> GEM_EXQUISITE = new MaterialTypeItem("gem_exquisite", 2, true, 18144000L);
    public static MaterialTypeItem<?> GEM_FLAWLESS = new MaterialTypeItem("gem_flawless", 2, true, 18144000L);
    public static MaterialTypeItem<?> GEM_FLAWED = new MaterialTypeItem("gem_flawed", 2, true, 18144000L);
    public static MaterialTypeItem<?> GEM_CHIPPED = new MaterialTypeItem("gem_chipped", 2, true, 18144000L);
    public static MaterialTypeItem<?> LENS = new MaterialTypeItem("lens", 2, true, 13608000L);
    public static MaterialTypeItem<?> PLATE = new MaterialTypeItem("plate", 2, true, 18144000L, (a, b, c) -> CoverFactory.builder((u, v, t, w) -> new CoverPlate(u, v, t, w, b, c)).item((u, v) -> new CoverMaterialItem(u.getDomain(), (MaterialType<?>)b, (CoverFactory)u, c)).build("antimatter", "plate_" + c.getId()));
    public static MaterialTypeItem<?> PLATE_DENSE = new MaterialTypeItem("plate_dense", 2, true, 163296000L);
    public static MaterialTypeItem<?> PLATE_TINY = new MaterialTypeItem("plate_tiny", 2, true, 2268000L);
    public static MaterialTypeItem<?> ITEM_CASING = new MaterialTypeItem("casing_item", 1, true, 9072000L);
    public static MaterialTypeItem<?> ROD = new MaterialTypeItem("rod", 2, true, 9072000L);
    public static MaterialTypeItem<?> ROD_LONG = new MaterialTypeItem("rod_long", 2, true, 18144000L);
    public static MaterialTypeItem<?> RING = new MaterialTypeItem("ring", 2, true, 4536000L);
    public static MaterialTypeItem<?> FOIL = new MaterialTypeItem("foil", 2, true, 18144000L);
    public static MaterialTypeItem<?> BOLT = new MaterialTypeItem("bolt", 2, true, 2268000L);
    public static MaterialTypeItem<?> SCREW = new MaterialTypeItem("screw", 2, true, 2016000L);
    public static MaterialTypeItem<?> GEAR = new MaterialTypeItem("gear", 2, true, 72576000L);
    public static MaterialTypeItem<?> GEAR_SMALL = new MaterialTypeItem("gear_small", 2, true, 18144000L);
    public static MaterialTypeItem<?> WIRE_FINE = new MaterialTypeItem("wire_fine", 2, true, 2268000L);
    public static MaterialTypeItem<?> SPRING = new MaterialTypeItem("spring", 2, true, 18144000L);
    public static MaterialTypeItem<?> ROTOR = new MaterialTypeItem("rotor", 2, true, 77112000L);
    public static MaterialTypeItem<?> DRILLBIT = new MaterialTypeItem("drill_bit", 2, true, 72576000L);
    public static MaterialTypeItem<?> CHAINSAWBIT = new MaterialTypeItem("chainsaw_bit", 2, true, 36288000L);
    public static MaterialTypeItem<?> WRENCHBIT = new MaterialTypeItem("wrench_bit", 2, true, 72576000L);
    public static MaterialTypeItem<?> BUZZSAW_BLADE = new MaterialTypeItem("buzzsaw_blade", 2, true, 72576000L);
    public static MaterialTypeItem<?> FISSILE_FUEL = new MaterialTypeItem("fissile_fuel", 2, true, 18144000L);
    public static MaterialTypeItem<?> DEPLETED_FISSILE_FUEL = new MaterialTypeItem("depleted_fissile_fuel", 2, true, 18144000L);
    public static MaterialTypeBlock<MaterialTypeBlock.IOreGetter> ORE = new MaterialTypeBlock("ore", 1, true, -1L, (domain, type, mat) -> AntimatterAPI.all(StoneType.class).stream().filter(StoneType::doesGenerateOre).forEach(s -> new BlockOre(domain, mat, (StoneType)s, type)));
    public static MaterialTypeBlock<MaterialTypeBlock.IOreGetter> ORE_SMALL = new MaterialTypeBlock("ore_small", 1, false, -1L, (domain, type, mat) -> AntimatterAPI.all(StoneType.class).stream().filter(StoneType::doesGenerateOre).forEach(s -> new BlockOre(domain, mat, (StoneType)s, type)));
    public static MaterialTypeBlock<MaterialTypeBlock.IBlockGetter> ORE_STONE = new MaterialTypeBlock("ore_stone", 1, true, -1L, (domain, type, mat) -> new BlockOreStone(domain, mat));
    public static MaterialTypeBlock<MaterialTypeBlock.IBlockGetter> BLOCK = new MaterialTypeBlock("block", 1, false, 163296000L, BlockStorage::new);
    public static MaterialTypeBlock<MaterialTypeBlock.IBlockGetter> RAW_ORE_BLOCK = new MaterialTypeBlock("raw_ore_block", 2, false, -1L, BlockStorage::new);
    public static MaterialTypeBlock<MaterialTypeBlock.IBlockGetter> FRAME = new MaterialTypeBlock("frame", 1, true, -1L, BlockStorage::new);
    public static MaterialTypeFluid<MaterialTypeFluid.IFluidGetter> LIQUID = new MaterialTypeFluid("liquid", 1, true, -1L);
    public static MaterialTypeFluid<MaterialTypeFluid.IFluidGetter> GAS = new MaterialTypeFluid("gas", 1, true, -1L);
    public static MaterialTypeFluid<MaterialTypeFluid.IFluidGetter> PLASMA = new MaterialTypeFluid("plasma", 1, true, -1L);

    public static void init() {
        NUGGET.replacement(AntimatterMaterials.Iron, () -> Items.f_42749_);
        NUGGET.replacement(AntimatterMaterials.Gold, () -> Items.f_42587_);
        INGOT.replacement(AntimatterMaterials.Iron, () -> Items.f_42416_);
        INGOT.replacement(AntimatterMaterials.Gold, () -> Items.f_42417_);
        INGOT.replacement(AntimatterMaterials.Netherite, () -> Items.f_42418_);
        INGOT.replacement(AntimatterMaterials.Copper, () -> Items.f_151052_);
        DUST.replacement(AntimatterMaterials.Redstone, () -> Items.f_42451_);
        DUST.replacement(AntimatterMaterials.Glowstone, () -> Items.f_42525_);
        DUST.replacement(AntimatterMaterials.Blaze, () -> Items.f_42593_);
        DUST.replacement(AntimatterMaterials.Sugar, () -> Items.f_42501_);
        RAW_ORE.replacement(AntimatterMaterials.Iron, () -> Items.f_151050_);
        RAW_ORE.replacement(AntimatterMaterials.Copper, () -> Items.f_151051_);
        RAW_ORE.replacement(AntimatterMaterials.Gold, () -> Items.f_151053_);
        GEM.replacement(AntimatterMaterials.Flint, () -> Items.f_42484_);
        GEM.replacement(AntimatterMaterials.Diamond, () -> Items.f_42415_);
        GEM.replacement(AntimatterMaterials.Emerald, () -> Items.f_42616_);
        GEM.replacement(AntimatterMaterials.Lapis, () -> Items.f_42534_);
        GEM.replacement(AntimatterMaterials.Quartz, () -> Items.f_42692_);
        GEM.replacement(AntimatterMaterials.Coal, () -> Items.f_42413_);
        GEM.replacement(AntimatterMaterials.Charcoal, () -> Items.f_42414_);
        GEM.replacement(AntimatterMaterials.EnderEye, () -> Items.f_42545_);
        GEM.replacement(AntimatterMaterials.EnderPearl, () -> Items.f_42584_);
        ROD.replacement(AntimatterMaterials.Blaze, () -> Items.f_42585_);
        ROD.replacement(AntimatterMaterials.Bone, () -> Items.f_42500_);
        ROD.replacement(AntimatterMaterials.Wood, () -> Items.f_42398_);
        BLOCK.replacement(AntimatterMaterials.Coal, () -> Items.f_42200_);
        BLOCK.replacement(AntimatterMaterials.Iron, () -> Items.f_41913_);
        BLOCK.replacement(AntimatterMaterials.Copper, () -> Items.f_151000_);
        BLOCK.replacement(AntimatterMaterials.Gold, () -> Items.f_41912_);
        BLOCK.replacement(AntimatterMaterials.Diamond, () -> Items.f_41959_);
        BLOCK.replacement(AntimatterMaterials.Emerald, () -> Items.f_42110_);
        BLOCK.replacement(AntimatterMaterials.Lapis, () -> Items.f_41854_);
        BLOCK.replacement(AntimatterMaterials.Netherite, () -> Items.f_42791_);
        RAW_ORE_BLOCK.replacement(AntimatterMaterials.Iron, () -> Items.f_150995_);
        RAW_ORE_BLOCK.replacement(AntimatterMaterials.Copper, () -> Items.f_150996_);
        RAW_ORE_BLOCK.replacement(AntimatterMaterials.Gold, () -> Items.f_150997_);
        ORE.replacement(AntimatterMaterials.Coal, AntimatterStoneTypes.STONE, () -> Items.f_41835_);
        ORE.replacement(AntimatterMaterials.Coal, AntimatterStoneTypes.DEEPSLATE, () -> Items.f_150963_);
        ORE.replacement(AntimatterMaterials.Iron, AntimatterStoneTypes.STONE, () -> Items.f_41834_);
        ORE.replacement(AntimatterMaterials.Iron, AntimatterStoneTypes.DEEPSLATE, () -> Items.f_150964_);
        ORE.replacement(AntimatterMaterials.Copper, AntimatterStoneTypes.STONE, () -> Items.f_150965_);
        ORE.replacement(AntimatterMaterials.Copper, AntimatterStoneTypes.DEEPSLATE, () -> Items.f_150966_);
        ORE.replacement(AntimatterMaterials.Gold, AntimatterStoneTypes.STONE, () -> Items.f_41833_);
        ORE.replacement(AntimatterMaterials.Gold, AntimatterStoneTypes.DEEPSLATE, () -> Items.f_150967_);
        ORE.replacement(AntimatterMaterials.Redstone, AntimatterStoneTypes.STONE, () -> Items.f_41977_);
        ORE.replacement(AntimatterMaterials.Redstone, AntimatterStoneTypes.DEEPSLATE, () -> Items.f_150968_);
        ORE.replacement(AntimatterMaterials.Emerald, AntimatterStoneTypes.STONE, () -> Items.f_42107_);
        ORE.replacement(AntimatterMaterials.Emerald, AntimatterStoneTypes.DEEPSLATE, () -> Items.f_150969_);
        ORE.replacement(AntimatterMaterials.Lapis, AntimatterStoneTypes.STONE, () -> Items.f_41853_);
        ORE.replacement(AntimatterMaterials.Lapis, AntimatterStoneTypes.DEEPSLATE, () -> Items.f_150993_);
        ORE.replacement(AntimatterMaterials.Diamond, AntimatterStoneTypes.STONE, () -> Items.f_42010_);
        ORE.replacement(AntimatterMaterials.Diamond, AntimatterStoneTypes.DEEPSLATE, () -> Items.f_150994_);
        ORE.replacement(AntimatterMaterials.Quartz, AntimatterStoneTypes.NETHERRACK, () -> Items.f_42154_);
        ROTOR.dependents(PLATE, SCREW, RING);
        SCREW.dependents(BOLT);
        BOLT.dependents(ROD);
        RING.dependents(ROD);
        ROD_LONG.dependents(ROD);
        CRUSHED.dependents(CRUSHED_PURIFIED, CRUSHED_REFINED, DUST_IMPURE);
        DUST_PURE.dependents(DUST);
        DUST_IMPURE.dependents(DUST_PURE);
        DUST.dependents(DUST_SMALL, DUST_TINY);
        GEAR_SMALL.dependents(PLATE);
        GEAR.dependents(PLATE, ROD);
        GEM_EXQUISITE.dependents(GEM_FLAWLESS, GEM_FLAWED, GEM_CHIPPED, GEM_POLISHED, GEM_BRITTLE, GEM);
        DUST_TINY.setHidden();
        DUST_SMALL.setHidden();
        DRILLBIT.setHidden().unSplitName().setIgnoreTextureSets();
        CHAINSAWBIT.setHidden().unSplitName().setIgnoreTextureSets();
        WRENCHBIT.setHidden().unSplitName().setIgnoreTextureSets();
        BUZZSAW_BLADE.setHidden().unSplitName().setIgnoreTextureSets();
        FISSILE_FUEL.setIgnoreTextureSets().unSplitName();
        DEPLETED_FISSILE_FUEL.setIgnoreTextureSets().unSplitName();
        RAW_ORE.unSplitName();
        RAW_ORE_BLOCK.unSplitName();
    }

    public static void postInit() {
        LIQUID.all().stream().filter(l -> !l.getId().equals("water") && !l.getId().equals("lava")).forEach(m -> AntimatterAPI.register(AntimatterFluid.class, new AntimatterMaterialFluid("antimatter_shared", (Material)m, (MaterialType<?>)LIQUID)));
        GAS.all().forEach(m -> AntimatterAPI.register(AntimatterFluid.class, new AntimatterMaterialFluid("antimatter_shared", (Material)m, (MaterialType<?>)GAS)));
        PLASMA.all().forEach(m -> AntimatterAPI.register(AntimatterFluid.class, new AntimatterMaterialFluid("antimatter_shared", (Material)m, (MaterialType<?>)PLASMA)));
    }

    static {
        ROCK.set((m, s) -> {
            if (m == null || s == null || !s.doesGenerateOre() || !ROCK.allowGen(m)) {
                return MaterialTypeBlock.getEmptyBlockAndLog(ROCK, m, s);
            }
            BlockSurfaceRock rock = AntimatterAPI.get(BlockSurfaceRock.class, "surface_rock_" + m.getId() + "_" + s.getId());
            return new MaterialTypeBlock.Container(rock != null ? rock.m_49966_() : Blocks.f_50016_.m_49966_());
        });
        ORE.set((m, s) -> {
            Item item;
            if (m != null && s != null && (item = AntimatterAPI.getReplacement(ORE, m, s, new String[0])) instanceof BlockItem) {
                return new MaterialTypeBlock.Container(((BlockItem)item).m_40614_().m_49966_());
            }
            if (m == null || s == null || !s.doesGenerateOre() || !ORE.allowGen(m)) {
                return MaterialTypeBlock.getEmptyBlockAndLog(ORE, m, s);
            }
            BlockOre block = AntimatterAPI.get(BlockOre.class, ORE.getId() + "_" + m.getId() + "_" + s.getId());
            return new MaterialTypeBlock.Container(block != null ? block.m_49966_() : Blocks.f_50016_.m_49966_());
        }).blockType();
        ORE_SMALL.set((m, s) -> {
            Item item;
            if (m != null && s != null && (item = AntimatterAPI.getReplacement(ORE_SMALL, m, s, new String[0])) instanceof BlockItem) {
                return new MaterialTypeBlock.Container(((BlockItem)item).m_40614_().m_49966_());
            }
            if (m == null || s == null || !ORE_SMALL.allowGen(m)) {
                return MaterialTypeBlock.getEmptyBlockAndLog(ORE_SMALL, m, s);
            }
            BlockOre block = AntimatterAPI.get(BlockOre.class, ORE_SMALL.getId() + "_" + m.getId() + "_" + Utils.getConventionalStoneType(s));
            return new MaterialTypeBlock.Container(block != null ? block.m_49966_() : Blocks.f_50016_.m_49966_());
        }).blockType();
        ORE_STONE.set(m -> {
            if (m == null || !ORE_STONE.allowGen(m)) {
                return MaterialTypeBlock.getEmptyBlockAndLog(ORE_STONE, m);
            }
            BlockOreStone block = AntimatterAPI.get(BlockOreStone.class, ORE_STONE.getId() + "_" + m.getId());
            return new MaterialTypeBlock.Container(block != null ? block.m_49966_() : Blocks.f_50016_.m_49966_());
        }).blockType();
        BLOCK.set(m -> {
            Item item;
            if (m != null && (item = AntimatterAPI.getReplacement(BLOCK, m, new String[0])) instanceof BlockItem) {
                return new MaterialTypeBlock.Container(((BlockItem)item).m_40614_().m_49966_());
            }
            if (m == null || !BLOCK.allowGen(m)) {
                return MaterialTypeBlock.getEmptyBlockAndLog(BLOCK, m);
            }
            BlockStorage block = AntimatterAPI.get(BlockStorage.class, BLOCK.getId() + "_" + m.getId());
            return new MaterialTypeBlock.Container(block != null ? block.m_49966_() : Blocks.f_50016_.m_49966_());
        }).blockType();
        RAW_ORE_BLOCK.set(m -> {
            Item item;
            if (m != null && (item = AntimatterAPI.getReplacement(RAW_ORE_BLOCK, m, new String[0])) instanceof BlockItem) {
                return new MaterialTypeBlock.Container(((BlockItem)item).m_40614_().m_49966_());
            }
            if (m == null || !RAW_ORE_BLOCK.allowGen(m)) {
                return MaterialTypeBlock.getEmptyBlockAndLog(RAW_ORE_BLOCK, m);
            }
            BlockStorage block = AntimatterAPI.get(BlockStorage.class, RAW_ORE_BLOCK.getId() + "_" + m.getId());
            return new MaterialTypeBlock.Container(block != null ? block.m_49966_() : Blocks.f_50016_.m_49966_());
        }).blockType();
        FRAME.set(m -> {
            if (m == null || !FRAME.allowGen(m)) {
                return MaterialTypeBlock.getEmptyBlockAndLog(FRAME, m);
            }
            BlockStorage block = AntimatterAPI.get(BlockStorage.class, FRAME.getId() + "_" + m.getId());
            return new MaterialTypeBlock.Container(block != null ? block.m_49966_() : Blocks.f_50016_.m_49966_());
        }).blockType();
        LIQUID.set((m, i) -> {
            if (m == null || !LIQUID.allowGen(m)) {
                return MaterialTypeFluid.getEmptyFluidAndLog(LIQUID, m);
            }
            if (m.getId().equals("water")) {
                return FluidPlatformUtils.createFluidStack((Fluid)Fluids.f_76193_, (long)i);
            }
            if (m.getId().equals("lava")) {
                return FluidPlatformUtils.createFluidStack((Fluid)Fluids.f_76195_, (long)i);
            }
            AntimatterFluid fluid = AntimatterAPI.get(AntimatterFluid.class, LIQUID.getId() + "_" + m.getId());
            if (fluid == null) {
                throw new IllegalStateException("Tried to get null fluid");
            }
            return FluidPlatformUtils.createFluidStack((Fluid)fluid.getFluid(), (long)i);
        });
        GAS.set((m, i) -> {
            if (m == null || !GAS.allowGen(m)) {
                return MaterialTypeFluid.getEmptyFluidAndLog(GAS, m);
            }
            AntimatterFluid fluid = AntimatterAPI.get(AntimatterFluid.class, GAS.getId() + "_" + m.getId());
            if (fluid == null) {
                throw new IllegalStateException("Tried to get null fluid");
            }
            return FluidPlatformUtils.createFluidStack((Fluid)fluid.getFluid(), (long)i);
        });
        PLASMA.set((m, i) -> {
            if (m == null || !PLASMA.allowGen(m)) {
                return MaterialTypeFluid.getEmptyFluidAndLog(PLASMA, m);
            }
            AntimatterFluid fluid = AntimatterAPI.get(AntimatterFluid.class, PLASMA.getId() + "_" + m.getId());
            if (fluid == null) {
                throw new IllegalStateException("Tried to get null fluid");
            }
            return FluidPlatformUtils.createFluidStack((Fluid)fluid.getFluid(), (long)i);
        });
    }
}

